/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.crafting.MultiblockRecipe;
import blusunrize.immersiveengineering.api.tool.assembler.AssemblerHandler;
import blusunrize.immersiveengineering.api.tool.assembler.RecipeQuery;
import blusunrize.immersiveengineering.api.tool.conveyor.ConveyorHandler;
import blusunrize.immersiveengineering.api.utils.CapabilityReference;
import blusunrize.immersiveengineering.api.utils.DirectionalBlockPos;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.generic.MultiblockPartBlockEntity;
import blusunrize.immersiveengineering.common.blocks.generic.PoweredMultiblockBlockEntity;
import blusunrize.immersiveengineering.common.blocks.multiblocks.IEMultiblocks;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.MultiblockProcess;
import blusunrize.immersiveengineering.common.config.IEServerConfig;
import blusunrize.immersiveengineering.common.register.IEContainerTypes;
import blusunrize.immersiveengineering.common.util.MultiblockCapability;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.compat.computers.generic.ComputerControlState;
import blusunrize.immersiveengineering.common.util.compat.computers.generic.ComputerControllable;
import blusunrize.immersiveengineering.common.util.inventory.IEInventoryHandler;
import blusunrize.immersiveengineering.common.util.inventory.IIEInventory;
import blusunrize.immersiveengineering.common.util.orientation.RelativeBlockFace;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import it.unimi.dsi.fastutil.booleans.BooleanArrayList;
import it.unimi.dsi.fastutil.booleans.BooleanList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class AssemblerBlockEntity
extends PoweredMultiblockBlockEntity<AssemblerBlockEntity, MultiblockRecipe>
implements IEBlockInterfaces.IInteractionObjectIE<AssemblerBlockEntity>,
ConveyorHandler.IConveyorAttachable,
IEBlockInterfaces.IBlockBounds,
ComputerControllable {
    public ComputerControlState[] computerControlByRecipe = new ComputerControlState[]{new ComputerControlState(), new ComputerControlState(), new ComputerControlState()};
    public FluidTank[] tanks = new FluidTank[]{new FluidTank(8000), new FluidTank(8000), new FluidTank(8000)};
    public final NonNullList<ItemStack> inventory = NonNullList.m_122780_((int)21, (Object)ItemStack.f_41583_);
    public CrafterPatternInventory[] patterns = new CrafterPatternInventory[]{new CrafterPatternInventory(this), new CrafterPatternInventory(this), new CrafterPatternInventory(this)};
    public boolean recursiveIngredients = false;
    private final CapabilityReference<IItemHandler> output = CapabilityReference.forBlockEntityAt(this, () -> new DirectionalBlockPos(this.f_58858_.m_5484_(this.getFacing(), 2), this.getFacing().m_122424_()), CapabilityItemHandler.ITEM_HANDLER_CAPABILITY);
    private final MultiblockCapability<IItemHandler> insertionHandler = MultiblockCapability.make(this, be -> be.insertionHandler, MultiblockPartBlockEntity::master, this.registerCapability(new IEInventoryHandler(18, (IIEInventory)this, 0, true, false)));
    private final MultiblockCapability<IItemHandler> extractionHandler = MultiblockCapability.make(this, be -> be.extractionHandler, MultiblockPartBlockEntity::master, this.registerCapability(new IEInventoryHandler(3, (IIEInventory)this, 18, false, true)));
    private static final BlockPos inputPos = new BlockPos(1, 1, 2);
    private static final BlockPos outputPos = new BlockPos(1, 1, 0);
    private static final Set<BlockPos> itemConnections = ImmutableSet.of((Object)inputPos, (Object)outputPos);
    private static final PoweredMultiblockBlockEntity.MultiblockFace fluidInputPos = new PoweredMultiblockBlockEntity.MultiblockFace(1, 0, 2, RelativeBlockFace.FRONT);
    private final MultiblockCapability<IFluidHandler> fluidCap = MultiblockCapability.make(this, be -> be.fluidCap, MultiblockPartBlockEntity::master, this.registerFluidHandler((IFluidTank[])this.tanks));

    public AssemblerBlockEntity(BlockEntityType<AssemblerBlockEntity> type, BlockPos pos, BlockState state) {
        super(IEMultiblocks.ASSEMBLER, 32000, true, type, pos, state);
    }

    @Override
    public void readCustomNBT(CompoundTag nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        if (!descPacket) {
            this.tanks[0].readFromNBT(nbt.m_128469_("tank0"));
            this.tanks[1].readFromNBT(nbt.m_128469_("tank1"));
            this.tanks[2].readFromNBT(nbt.m_128469_("tank2"));
            this.recursiveIngredients = nbt.m_128471_("recursiveIngredients");
            ContainerHelper.m_18980_((CompoundTag)nbt, this.inventory);
            for (int iPattern = 0; iPattern < this.patterns.length; ++iPattern) {
                ListTag patternList = nbt.m_128437_("pattern" + iPattern, 10);
                this.patterns[iPattern] = new CrafterPatternInventory(this);
                this.patterns[iPattern].readFromNBT(patternList);
            }
        }
    }

    @Override
    public void writeCustomNBT(CompoundTag nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        if (!descPacket) {
            nbt.m_128365_("tank0", (Tag)this.tanks[0].writeToNBT(new CompoundTag()));
            nbt.m_128365_("tank1", (Tag)this.tanks[1].writeToNBT(new CompoundTag()));
            nbt.m_128365_("tank2", (Tag)this.tanks[2].writeToNBT(new CompoundTag()));
            nbt.m_128379_("recursiveIngredients", this.recursiveIngredients);
            ContainerHelper.m_18973_((CompoundTag)nbt, this.inventory);
            for (int iPattern = 0; iPattern < this.patterns.length; ++iPattern) {
                ListTag patternList = new ListTag();
                this.patterns[iPattern].writeToNBT(patternList);
                nbt.m_128365_("pattern" + iPattern, (Tag)patternList);
            }
        }
    }

    @Override
    public void receiveMessageFromClient(CompoundTag message) {
        block5: {
            block3: {
                int id;
                block4: {
                    Preconditions.checkState((!this.f_58857_.f_46443_ ? 1 : 0) != 0);
                    if (!message.m_128425_("buttonID", 3)) break block3;
                    id = message.m_128451_("buttonID");
                    if (id < 0 || id >= this.patterns.length) break block4;
                    CrafterPatternInventory pattern = this.patterns[id];
                    for (int i = 0; i < pattern.inv.size(); ++i) {
                        pattern.inv.set(i, (Object)ItemStack.f_41583_);
                    }
                    break block5;
                }
                if (id != 3) break block5;
                this.recursiveIngredients = !this.recursiveIngredients;
                break block5;
            }
            if (message.m_128425_("patternSync", 3)) {
                int r = message.m_128451_("recipe");
                ListTag list = message.m_128437_("patternSync", 10);
                CrafterPatternInventory pattern = this.patterns[r];
                for (int i = 0; i < list.size(); ++i) {
                    CompoundTag itemTag = list.m_128728_(i);
                    pattern.inv.set(itemTag.m_128451_("slot"), (Object)ItemStack.m_41712_((CompoundTag)itemTag));
                }
            }
        }
    }

    @Override
    public void tickServer() {
        super.tickServer();
        if (this.isDummy() || this.isRSDisabled() || this.f_58857_.m_46467_() % 16L != (long)((this.m_58899_().m_123341_() ^ this.m_58899_().m_123343_()) & 0xF)) {
            return;
        }
        boolean update = false;
        NonNullList[] outputBuffer = new NonNullList[this.patterns.length];
        for (int p = 0; p < this.patterns.length; ++p) {
            CrafterPatternInventory pattern = this.patterns[p];
            ComputerControlState state = this.computerControlByRecipe[p];
            if (state.isAttached() && !state.isEnabled() || ((ItemStack)pattern.inv.get(9)).m_41619_() || !this.canOutput((ItemStack)pattern.inv.get(9), p)) continue;
            ItemStack output = ((ItemStack)pattern.inv.get(9)).m_41777_();
            ArrayList<ItemStack> availableStacks = new ArrayList<ItemStack>();
            for (NonNullList bufferedStacks : outputBuffer) {
                if (bufferedStacks == null) continue;
                for (ItemStack stack : bufferedStacks) {
                    if (stack.m_41619_()) continue;
                    availableStacks.add(stack);
                }
            }
            for (ItemStack stack : this.inventory) {
                if (stack.m_41619_()) continue;
                availableStacks.add(stack);
            }
            int consumed = (Integer)IEServerConfig.MACHINES.assembler_consumption.get();
            AssemblerHandler.IRecipeAdapter<?> adapter = AssemblerHandler.findAdapter(pattern.recipe);
            RecipeQuery[] queries = adapter.getQueriedInputs(pattern.recipe, pattern.inv, this.f_58857_);
            if (queries == null || this.energyStorage.extractEnergy(consumed, true) != consumed || !this.consumeIngredients(queries, availableStacks, false, null, null)) continue;
            this.energyStorage.extractEnergy(consumed, false);
            NonNullList outputList = NonNullList.m_122779_();
            outputList.add((Object)output);
            BooleanArrayList providedByNonItem = new BooleanArrayList(new boolean[9]);
            NonNullList gridItems = NonNullList.m_122783_((Object)ItemStack.f_41583_, (Object[])((ItemStack[])pattern.inv.toArray((Object[])new ItemStack[0])));
            this.consumeIngredients(queries, availableStacks, true, (NonNullList<ItemStack>)gridItems, (BooleanList)providedByNonItem);
            NonNullList remainingItems = pattern.recipe.m_7457_((Container)Utils.InventoryCraftingFalse.createFilledCraftingInventory(3, 3, (NonNullList<ItemStack>)gridItems));
            for (int i = 0; i < remainingItems.size(); ++i) {
                ItemStack rem = (ItemStack)remainingItems.get(i);
                if (providedByNonItem.getBoolean(i) || rem.m_41619_()) continue;
                outputList.add((Object)rem);
            }
            outputBuffer[p] = outputList;
            update = true;
        }
        for (int buffer = 0; buffer < outputBuffer.length; ++buffer) {
            if (outputBuffer[buffer] == null || outputBuffer[buffer].size() <= 0) continue;
            for (int iOutput = 0; iOutput < outputBuffer[buffer].size(); ++iOutput) {
                ItemStack output = (ItemStack)outputBuffer[buffer].get(iOutput);
                if (output.m_41619_() || output.m_41613_() <= 0 || !this.isRecipeIngredient(output, buffer) && ((output = Utils.insertStackIntoInventory(this.output, output, false)).m_41619_() || output.m_41613_() <= 0)) continue;
                int free = -1;
                if (iOutput == 0) {
                    if (((ItemStack)this.inventory.get(18 + buffer)).m_41619_() && free < 0) {
                        free = 18 + buffer;
                    } else if (!((ItemStack)this.inventory.get(18 + buffer)).m_41619_() && ItemHandlerHelper.canItemStacksStack((ItemStack)output, (ItemStack)((ItemStack)this.inventory.get(18 + buffer))) && ((ItemStack)this.inventory.get(18 + buffer)).m_41613_() + output.m_41613_() <= ((ItemStack)this.inventory.get(18 + buffer)).m_41741_()) {
                        ((ItemStack)this.inventory.get(18 + buffer)).m_41769_(output.m_41613_());
                        free = -1;
                        continue;
                    }
                } else {
                    for (int i = 0; i < this.inventory.size(); ++i) {
                        if (((ItemStack)this.inventory.get(i)).m_41619_() && free < 0) {
                            free = i;
                            continue;
                        }
                        if (((ItemStack)this.inventory.get(i)).m_41619_() || !ItemHandlerHelper.canItemStacksStack((ItemStack)output, (ItemStack)((ItemStack)this.inventory.get(i))) || ((ItemStack)this.inventory.get(i)).m_41613_() + output.m_41613_() > ((ItemStack)this.inventory.get(i)).m_41741_()) continue;
                        ((ItemStack)this.inventory.get(i)).m_41769_(output.m_41613_());
                        free = -1;
                        break;
                    }
                }
                if (free < 0) continue;
                this.inventory.set(free, (Object)output.m_41777_());
            }
        }
        for (int i = 0; i < 3; ++i) {
            if (this.isRecipeIngredient((ItemStack)this.inventory.get(18 + i), i)) continue;
            this.inventory.set(18 + i, (Object)Utils.insertStackIntoInventory(this.output, (ItemStack)this.inventory.get(18 + i), false));
        }
        if (update) {
            this.m_6596_();
            this.markContainingBlockForUpdate(null);
        }
    }

    public boolean consumeIngredients(RecipeQuery[] queries, ArrayList<ItemStack> itemStacks, boolean doConsume, @Nullable NonNullList<ItemStack> gridItems, @Nullable BooleanList providedByNonItem) {
        Preconditions.checkArgument((gridItems == null == (providedByNonItem == null) ? 1 : 0) != 0);
        if (!doConsume) {
            ArrayList<ItemStack> dupeList = new ArrayList<ItemStack>(itemStacks.size());
            for (ItemStack itemStack : itemStacks) {
                dupeList.add(itemStack.m_41777_());
            }
            itemStacks = dupeList;
        }
        FluidStack[] tankFluids = (FluidStack[])Arrays.stream(this.tanks).map(tank -> doConsume ? tank.getFluid() : tank.getFluid().copy()).toArray(FluidStack[]::new);
        for (int i = 0; i < queries.length; ++i) {
            RecipeQuery recipeQuery = queries[i];
            if (recipeQuery == null) continue;
            int querySize = recipeQuery.getItemCount();
            if (recipeQuery.isFluid()) {
                boolean hasFluid = false;
                for (int t = 0; t < tankFluids.length; ++t) {
                    if (!recipeQuery.matchesFluid(tankFluids[t])) continue;
                    hasFluid = true;
                    if (doConsume) {
                        this.tanks[t].drain(recipeQuery.getFluidSize(), IFluidHandler.FluidAction.EXECUTE);
                        break;
                    }
                    tankFluids[t].shrink(recipeQuery.getFluidSize());
                    break;
                }
                if (hasFluid) {
                    if (providedByNonItem == null) continue;
                    providedByNonItem.set(i, true);
                    continue;
                }
                querySize = 1;
            }
            Iterator<Object> it = itemStacks.iterator();
            while (it.hasNext()) {
                ItemStack next = (ItemStack)it.next();
                if (next.m_41619_() || !recipeQuery.matchesIgnoringSize(next)) continue;
                int taken = Math.min(querySize, next.m_41613_());
                ItemStack forGrid = next.m_41620_(taken);
                if (gridItems != null) {
                    gridItems.set(i, (Object)forGrid);
                    providedByNonItem.set(i, false);
                }
                if (next.m_41613_() <= 0) {
                    it.remove();
                }
                if ((querySize -= taken) > 0) continue;
                break;
            }
            if (querySize <= 0) continue;
            return false;
        }
        return true;
    }

    public boolean canOutput(ItemStack output, int iPattern) {
        if (((ItemStack)this.inventory.get(18 + iPattern)).m_41619_()) {
            return true;
        }
        return ItemHandlerHelper.canItemStacksStack((ItemStack)output, (ItemStack)((ItemStack)this.inventory.get(18 + iPattern))) && ((ItemStack)this.inventory.get(18 + iPattern)).m_41613_() + output.m_41613_() <= ((ItemStack)this.inventory.get(18 + iPattern)).m_41741_();
    }

    public boolean isRecipeIngredient(ItemStack stack, int slot) {
        if (stack.m_41619_()) {
            return false;
        }
        if (slot - 1 < this.patterns.length || this.recursiveIngredients) {
            int p;
            int n = p = this.recursiveIngredients ? 0 : slot;
            while (p < this.patterns.length) {
                CrafterPatternInventory pattern = this.patterns[p];
                for (int i = 0; i < 9; ++i) {
                    if (((ItemStack)pattern.inv.get(i)).m_41619_() || !ItemStack.m_41746_((ItemStack)((ItemStack)pattern.inv.get(i)), (ItemStack)stack)) continue;
                    return true;
                }
                ++p;
            }
        }
        return false;
    }

    @Override
    public VoxelShape getBlockBounds(@Nullable CollisionContext ctx) {
        ImmutableSet fullBlocks = ImmutableSet.of((Object)new BlockPos(1, 1, 2), (Object)new BlockPos(1, 1, 1), (Object)new BlockPos(1, 1, 0), (Object)new BlockPos(1, 2, 1));
        if (this.posInMultiblock.m_123342_() == 0 || fullBlocks.contains(this.posInMultiblock)) {
            return Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)1.0);
        }
        float xMin = 0.0f;
        float yMin = 0.0f;
        float zMin = 0.0f;
        float xMax = 1.0f;
        float yMax = 1.0f;
        float zMax = 1.0f;
        if (this.posInMultiblock.m_123343_() == 2 && this.getFacing() == Direction.SOUTH || this.posInMultiblock.m_123343_() == 0 && this.getFacing() == Direction.NORTH) {
            zMin = 0.25f;
        } else if (this.posInMultiblock.m_123343_() == 2 && this.getFacing() == Direction.NORTH || this.posInMultiblock.m_123343_() == 0 && this.getFacing() == Direction.SOUTH) {
            zMax = 0.75f;
        } else if (this.posInMultiblock.m_123343_() == 2 && this.getFacing() == Direction.EAST || this.posInMultiblock.m_123343_() == 0 && this.getFacing() == Direction.WEST) {
            xMin = 0.25f;
        } else if (this.posInMultiblock.m_123343_() == 2 && this.getFacing() == Direction.WEST || this.posInMultiblock.m_123343_() == 0 && this.getFacing() == Direction.EAST) {
            xMax = 0.75f;
        }
        if (this.posInMultiblock.m_123341_() == 0 && this.getFacing() == Direction.EAST || this.posInMultiblock.m_123341_() == 2 && this.getFacing() == Direction.WEST) {
            zMin = 0.1875f;
        } else if (this.posInMultiblock.m_123341_() == 0 && this.getFacing() == Direction.WEST || this.posInMultiblock.m_123341_() == 2 && this.getFacing() == Direction.EAST) {
            zMax = 0.8125f;
        } else if (this.posInMultiblock.m_123341_() == 0 && this.getFacing() == Direction.NORTH || this.posInMultiblock.m_123341_() == 2 && this.getFacing() == Direction.SOUTH) {
            xMin = 0.1875f;
        } else if (this.posInMultiblock.m_123341_() == 0 && this.getFacing() == Direction.SOUTH || this.posInMultiblock.m_123341_() == 2 && this.getFacing() == Direction.NORTH) {
            xMax = 0.8125f;
        }
        return Shapes.m_83048_((double)xMin, (double)yMin, (double)zMin, (double)xMax, (double)yMax, (double)zMax);
    }

    @Override
    public Set<PoweredMultiblockBlockEntity.MultiblockFace> getEnergyPos() {
        return ImmutableSet.of((Object)new PoweredMultiblockBlockEntity.MultiblockFace(1, 2, 1, RelativeBlockFace.UP));
    }

    @Override
    public Set<BlockPos> getRedstonePos() {
        return ImmutableSet.of((Object)new BlockPos(0, 0, 1), (Object)new BlockPos(2, 0, 1));
    }

    @Override
    public boolean isInWorldProcessingMachine() {
        return false;
    }

    @Override
    public boolean additionalCanProcessCheck(MultiblockProcess<MultiblockRecipe> process) {
        return false;
    }

    @Override
    public void doProcessOutput(ItemStack output) {
    }

    @Override
    public void doProcessFluidOutput(FluidStack output) {
    }

    @Override
    public void onProcessFinish(MultiblockProcess<MultiblockRecipe> process) {
    }

    @Override
    public int getMaxProcessPerTick() {
        return 0;
    }

    @Override
    public int getProcessQueueMaxLength() {
        return 0;
    }

    @Override
    public float getMinProcessDistance(MultiblockProcess<MultiblockRecipe> process) {
        return 0.0f;
    }

    @Override
    public NonNullList<ItemStack> getInventory() {
        return this.inventory;
    }

    @Override
    public boolean isStackValid(int slot, ItemStack stack) {
        return true;
    }

    @Override
    public int getSlotLimit(int slot) {
        return 64;
    }

    @Override
    public int[] getOutputSlots() {
        return new int[0];
    }

    @Override
    public int[] getOutputTanks() {
        return new int[0];
    }

    @Override
    public IFluidTank[] getInternalTanks() {
        return this.tanks;
    }

    @Override
    public void doGraphicalUpdates() {
        this.m_6596_();
        this.markContainingBlockForUpdate(null);
    }

    @Override
    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && (facing == null || fluidInputPos.equals(this.asRelativeFace(facing)))) {
            return this.fluidCap.getAndCast();
        }
        if (itemConnections.contains(this.posInMultiblock) && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (inputPos.equals((Object)this.posInMultiblock) && facing == this.getFacing().m_122424_()) {
                return this.insertionHandler.getAndCast();
            }
            if (outputPos.equals((Object)this.posInMultiblock) && facing == this.getFacing()) {
                return this.extractionHandler.getAndCast();
            }
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public MultiblockRecipe findRecipeForInsertion(ItemStack inserting) {
        return null;
    }

    @Override
    protected MultiblockRecipe getRecipeForId(Level level, ResourceLocation id) {
        return null;
    }

    @Override
    public boolean canUseGui(Player player) {
        return this.formed;
    }

    @Override
    public AssemblerBlockEntity getGuiMaster() {
        return (AssemblerBlockEntity)this.master();
    }

    @Override
    public IEContainerTypes.BEContainer<AssemblerBlockEntity, ?> getContainerType() {
        return IEContainerTypes.ASSEMBLER;
    }

    @Override
    public Direction[] sigOutputDirections() {
        return new Direction[]{this.getFacing()};
    }

    @Override
    public void m_142339_(Level world) {
        super.m_142339_(world);
        if (this.m_58904_() != null) {
            for (CrafterPatternInventory pattern : this.patterns) {
                pattern.recalculateOutput();
            }
        }
    }

    @Override
    public Stream<ComputerControlState> getAllComputerControlStates() {
        return Arrays.stream(this.computerControlByRecipe);
    }

    public static class CrafterPatternInventory
    implements Container {
        public NonNullList<ItemStack> inv = NonNullList.m_122780_((int)10, (Object)ItemStack.f_41583_);
        public Recipe<CraftingContainer> recipe;
        final AssemblerBlockEntity tile;

        public CrafterPatternInventory(AssemblerBlockEntity tile) {
            this.tile = tile;
        }

        public int m_6643_() {
            return 10;
        }

        public boolean m_7983_() {
            for (ItemStack stack : this.inv) {
                if (stack.m_41619_()) continue;
                return false;
            }
            return true;
        }

        public ItemStack m_8020_(int slot) {
            return (ItemStack)this.inv.get(slot);
        }

        public ItemStack m_7407_(int slot, int amount) {
            ItemStack stack = this.m_8020_(slot);
            if (slot < 9 && !stack.m_41619_()) {
                if (stack.m_41613_() <= amount) {
                    this.m_6836_(slot, ItemStack.f_41583_);
                } else if ((stack = stack.m_41620_(amount)).m_41613_() == 0) {
                    this.m_6836_(slot, ItemStack.f_41583_);
                }
            }
            return stack;
        }

        public ItemStack m_8016_(int slot) {
            ItemStack stack = this.m_8020_(slot);
            if (!stack.m_41619_()) {
                this.m_6836_(slot, ItemStack.f_41583_);
            }
            return stack;
        }

        public void m_6836_(int slot, ItemStack stack) {
            if (slot < 9) {
                this.inv.set(slot, (Object)stack);
                if (!stack.m_41619_() && stack.m_41613_() > this.m_6893_()) {
                    stack.m_41764_(this.m_6893_());
                }
            }
            this.recalculateOutput();
        }

        public void m_6211_() {
            for (int i = 0; i < this.inv.size(); ++i) {
                this.inv.set(i, (Object)ItemStack.f_41583_);
            }
        }

        public void recalculateOutput() {
            if (this.tile.m_58904_() != null) {
                CraftingContainer invC = Utils.InventoryCraftingFalse.createFilledCraftingInventory(3, 3, this.inv);
                this.recipe = Utils.findCraftingRecipe(invC, this.tile.getLevelNonnull()).orElse(null);
                this.inv.set(9, (Object)(this.recipe != null ? this.recipe.m_5874_((Container)invC) : ItemStack.f_41583_));
            }
        }

        public int m_6893_() {
            return 1;
        }

        public boolean m_6542_(Player player) {
            return true;
        }

        public void m_5856_(Player player) {
        }

        public void m_5785_(Player player) {
        }

        public boolean m_7013_(int slot, ItemStack stack) {
            return true;
        }

        public void m_6596_() {
            this.tile.m_6596_();
        }

        public void writeToNBT(ListTag list) {
            for (int i = 0; i < this.inv.size(); ++i) {
                if (((ItemStack)this.inv.get(i)).m_41619_()) continue;
                CompoundTag itemTag = new CompoundTag();
                itemTag.m_128344_("Slot", (byte)i);
                ((ItemStack)this.inv.get(i)).m_41739_(itemTag);
                list.add((Object)itemTag);
            }
        }

        public void readFromNBT(ListTag list) {
            for (int i = 0; i < list.size(); ++i) {
                CompoundTag itemTag = list.m_128728_(i);
                int slot = itemTag.m_128445_("Slot") & 0xFF;
                if (slot >= this.m_6643_()) continue;
                this.inv.set(slot, (Object)ItemStack.m_41712_((CompoundTag)itemTag));
            }
            this.recalculateOutput();
        }
    }
}

