/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.utils;

import blusunrize.immersiveengineering.client.utils.IEGLShaders;
import blusunrize.immersiveengineering.client.utils.WhiteTexture;
import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.OptionalDouble;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.resources.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class IERenderTypes
extends RenderStateShard {
    public static final VertexFormat BLOCK_WITH_OVERLAY = new VertexFormat(ImmutableMap.builder().put((Object)"Position", (Object)DefaultVertexFormat.f_85804_).put((Object)"Color", (Object)DefaultVertexFormat.f_85805_).put((Object)"UV0", (Object)DefaultVertexFormat.f_85806_).put((Object)"UV1", (Object)DefaultVertexFormat.f_85807_).put((Object)"UV2", (Object)DefaultVertexFormat.f_85808_).put((Object)"Normal", (Object)DefaultVertexFormat.f_85809_).put((Object)"Padding", (Object)DefaultVertexFormat.f_85810_).build());
    public static final RenderType TRANSLUCENT_FULLBRIGHT;
    public static final RenderType SOLID_FULLBRIGHT;
    public static final RenderType LINES;
    public static final RenderType POINTS;
    public static final RenderType TRANSLUCENT_TRIANGLES;
    public static final RenderType TRANSLUCENT_POSITION_COLOR;
    public static final RenderType TRANSLUCENT_NO_DEPTH;
    public static final RenderType CHUNK_MARKER;
    public static final RenderType POSITION_COLOR_LIGHTMAP;
    public static final RenderType ITEM_DAMAGE_BAR;
    public static final RenderType PARTICLES;
    private static final Function<ResourceLocation, RenderType> GUI_CUTOUT;
    private static final Function<ResourceLocation, RenderType> GUI_TRANSLUCENT;
    private static final Function<ResourceLocation, RenderType> FULLBRIGHT_TRANSLUCENT;
    private static final RenderStateShard.ShaderStateShard RENDERTYPE_POSITION_COLOR;
    protected static final RenderStateShard.TextureStateShard BLOCK_SHEET_MIPPED;
    protected static final RenderStateShard.LightmapStateShard LIGHTMAP_DISABLED;
    protected static final RenderStateShard.TransparencyStateShard TRANSLUCENT_TRANSPARENCY;
    protected static final RenderStateShard.ShaderStateShard FULLBRIGHT_BLOCKS;
    protected static final RenderStateShard.ShaderStateShard POINTS_SHADER;
    protected static final RenderStateShard.TransparencyStateShard NO_TRANSPARENCY;
    protected static final RenderStateShard.DepthTestStateShard DEPTH_ALWAYS;

    private IERenderTypes(String p_110161_, Runnable p_110162_, Runnable p_110163_) {
        super(p_110161_, p_110162_, p_110163_);
    }

    public static RenderType getGui(ResourceLocation texture) {
        return GUI_CUTOUT.apply(texture);
    }

    public static RenderType getGuiTranslucent(ResourceLocation texture) {
        return GUI_TRANSLUCENT.apply(texture);
    }

    private static RenderType.CompositeState.CompositeStateBuilder makeGuiState(ResourceLocation texture) {
        return RenderType.CompositeState.m_110628_().m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(texture, false, false)).m_173292_(f_173101_);
    }

    public static RenderType getLines(float lineWidth) {
        return IERenderTypes.createDefault("lines_color_pos_" + lineWidth, DefaultVertexFormat.f_166851_, VertexFormat.Mode.LINES, RenderType.CompositeState.m_110628_().m_110673_(new RenderStateShard.LineStateShard(OptionalDouble.of(lineWidth))).m_173292_(f_173095_).m_110691_(false));
    }

    public static RenderType getPositionTex(ResourceLocation texture) {
        return IERenderTypes.createDefault("immersiveengineering:pos_tex_" + texture, DefaultVertexFormat.f_85817_, VertexFormat.Mode.QUADS, RenderType.CompositeState.m_110628_().m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(texture, false, false)).m_173292_(f_173102_).m_110691_(false));
    }

    private static RenderType createDefault(String name, VertexFormat format, VertexFormat.Mode mode, RenderType.CompositeState state) {
        return RenderType.m_173215_((String)name, (VertexFormat)format, (VertexFormat.Mode)mode, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)state);
    }

    public static RenderType getFullbrightTranslucent(ResourceLocation texture) {
        return FULLBRIGHT_TRANSLUCENT.apply(texture);
    }

    public static MultiBufferSource wrapWithStencil(MultiBufferSource in, Consumer<VertexConsumer> setupStencilArea, String name, int ref) {
        return IERenderTypes.wrapWithAdditional(in, "stencil_" + name + "_" + ref, () -> {
            GL11.glEnable((int)2960);
            RenderSystem.m_69444_((boolean)false, (boolean)false, (boolean)false, (boolean)false);
            RenderSystem.m_69458_((boolean)false);
            GL11.glStencilFunc((int)512, (int)1, (int)255);
            GL11.glStencilOp((int)7681, (int)7680, (int)7680);
            GL11.glStencilMask((int)255);
            RenderSystem.m_69421_((int)1024, (boolean)true);
            RenderSystem.m_69472_();
            Tesselator tes = Tesselator.m_85913_();
            BufferBuilder bb = tes.m_85915_();
            bb.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85814_);
            setupStencilArea.accept((VertexConsumer)bb);
            tes.m_85914_();
            RenderSystem.m_69493_();
            RenderSystem.m_69444_((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            RenderSystem.m_69458_((boolean)true);
            GL11.glStencilMask((int)0);
            GL11.glStencilFunc((int)514, (int)ref, (int)255);
        }, () -> GL11.glDisable((int)2960));
    }

    public static MultiBufferSource whiteLightmap(MultiBufferSource in) {
        return IERenderTypes.wrapWithAdditional(in, "white_light", () -> WhiteTexture.INSTANCE.get().bind(), () -> Minecraft.m_91087_().f_91063_.m_109154_().m_109896_());
    }

    private static MultiBufferSource wrapWithAdditional(MultiBufferSource in, String name, Runnable setup, Runnable teardown) {
        return type -> in.m_6299_(new RenderType("immersiveengineering:" + type + "_" + name, type.m_110508_(), type.m_173186_(), type.m_110507_(), type.m_110405_(), false, () -> {
            type.m_110185_();
            setup.run();
        }, () -> {
            teardown.run();
            type.m_110188_();
        }){});
    }

    static {
        RENDERTYPE_POSITION_COLOR = f_173091_;
        BLOCK_SHEET_MIPPED = new RenderStateShard.TextureStateShard(TextureAtlas.f_118259_, false, true);
        LIGHTMAP_DISABLED = new RenderStateShard.LightmapStateShard(false);
        TRANSLUCENT_TRANSPARENCY = new RenderStateShard.TransparencyStateShard("translucent_transparency", () -> {
            RenderSystem.m_69478_();
            RenderSystem.m_69453_();
        }, RenderSystem::m_69461_);
        FULLBRIGHT_BLOCKS = new RenderStateShard.ShaderStateShard(IEGLShaders::getBlockFullbrightShader);
        POINTS_SHADER = new RenderStateShard.ShaderStateShard(IEGLShaders::getPointShader);
        NO_TRANSPARENCY = new RenderStateShard.TransparencyStateShard("no_transparency", RenderSystem::m_69461_, () -> {});
        DEPTH_ALWAYS = new RenderStateShard.DepthTestStateShard("always", 519);
        SOLID_FULLBRIGHT = IERenderTypes.createDefault("immersiveengineering:solid_fullbright", BLOCK_WITH_OVERLAY, VertexFormat.Mode.QUADS, RenderType.CompositeState.m_110628_().m_173292_(FULLBRIGHT_BLOCKS).m_110677_(f_110154_).m_110671_(LIGHTMAP_DISABLED).m_173290_((RenderStateShard.EmptyTextureStateShard)BLOCK_SHEET_MIPPED).m_110691_(false));
        TRANSLUCENT_FULLBRIGHT = IERenderTypes.createDefault("immersiveengineering:translucent_fullbright", BLOCK_WITH_OVERLAY, VertexFormat.Mode.QUADS, RenderType.CompositeState.m_110628_().m_173292_(FULLBRIGHT_BLOCKS).m_110671_(LIGHTMAP_DISABLED).m_110677_(f_110154_).m_173290_((RenderStateShard.EmptyTextureStateShard)BLOCK_SHEET_MIPPED).m_110685_(TRANSLUCENT_TRANSPARENCY).m_110691_(false));
        RenderType.CompositeState translucentNoDepthState = RenderType.CompositeState.m_110628_().m_110685_(TRANSLUCENT_TRANSPARENCY).m_110673_(new RenderStateShard.LineStateShard(OptionalDouble.of(2.0))).m_110663_(DEPTH_ALWAYS).m_173292_(RENDERTYPE_POSITION_COLOR).m_110691_(false);
        LINES = IERenderTypes.createDefault("immersiveengineering:translucent_lines", DefaultVertexFormat.f_166851_, VertexFormat.Mode.LINES, RenderType.CompositeState.m_110628_().m_173292_(f_173095_).m_110673_(new RenderStateShard.LineStateShard(OptionalDouble.of(2.0))).m_110669_(f_110119_).m_110685_(TRANSLUCENT_TRANSPARENCY).m_110675_(f_110129_).m_110687_(f_110114_).m_110661_(f_110110_).m_110691_(false));
        POINTS = IERenderTypes.createDefault("immersiveengineering:points", DefaultVertexFormat.f_166851_, VertexFormat.Mode.QUADS, RenderType.CompositeState.m_110628_().m_173292_(POINTS_SHADER).m_110685_(TRANSLUCENT_TRANSPARENCY).m_110675_(f_110129_).m_110687_(f_110114_).m_110661_(f_110110_).m_110691_(false));
        TRANSLUCENT_TRIANGLES = IERenderTypes.createDefault("immersiveengineering:translucent_triangles", DefaultVertexFormat.f_85815_, VertexFormat.Mode.TRIANGLES, translucentNoDepthState);
        RenderType.CompositeState translucentNoTextureState = RenderType.CompositeState.m_110628_().m_110685_(TRANSLUCENT_TRANSPARENCY).m_173290_((RenderStateShard.EmptyTextureStateShard)BLOCK_SHEET_MIPPED).m_173292_(RENDERTYPE_POSITION_COLOR).m_110691_(false);
        TRANSLUCENT_POSITION_COLOR = IERenderTypes.createDefault("immersiveengineering:translucent_pos_color", DefaultVertexFormat.f_85815_, VertexFormat.Mode.QUADS, translucentNoTextureState);
        TRANSLUCENT_NO_DEPTH = IERenderTypes.createDefault("immersiveengineering:translucent_no_depth", DefaultVertexFormat.f_85815_, VertexFormat.Mode.QUADS, translucentNoDepthState);
        CHUNK_MARKER = IERenderTypes.createDefault("immersiveengineering:chunk_marker", DefaultVertexFormat.f_166851_, VertexFormat.Mode.LINES, RenderType.CompositeState.m_110628_().m_110685_(TRANSLUCENT_TRANSPARENCY).m_173292_(f_173095_).m_110673_(new RenderStateShard.LineStateShard(OptionalDouble.of(5.0))).m_110669_(f_110119_).m_110661_(f_110110_).m_110675_(f_110129_).m_110687_(f_110114_).m_110691_(false));
        POSITION_COLOR_LIGHTMAP = IERenderTypes.createDefault("immersiveengineering:pos_color_lightmap", DefaultVertexFormat.f_85816_, VertexFormat.Mode.QUADS, RenderType.CompositeState.m_110628_().m_110671_(new RenderStateShard.LightmapStateShard(true)).m_173292_(f_173099_).m_110691_(false));
        ITEM_DAMAGE_BAR = IERenderTypes.createDefault("immersiveengineering:item_damage_bar", DefaultVertexFormat.f_85815_, VertexFormat.Mode.QUADS, RenderType.CompositeState.m_110628_().m_110663_(DEPTH_ALWAYS).m_173290_((RenderStateShard.EmptyTextureStateShard)BLOCK_SHEET_MIPPED).m_173292_(f_173104_).m_110685_(NO_TRANSPARENCY).m_110691_(false));
        PARTICLES = IERenderTypes.createDefault("immersiveengineering:particles", DefaultVertexFormat.f_85813_, VertexFormat.Mode.QUADS, RenderType.CompositeState.m_110628_().m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(TextureAtlas.f_118260_, false, false)).m_173292_(new RenderStateShard.ShaderStateShard(GameRenderer::m_172829_)).m_110685_(TRANSLUCENT_TRANSPARENCY).m_110675_(f_110125_).m_110671_(f_110153_).m_110691_(true));
        GUI_CUTOUT = Util.m_143827_(texture -> IERenderTypes.createDefault("gui_" + texture, DefaultVertexFormat.f_85818_, VertexFormat.Mode.QUADS, IERenderTypes.makeGuiState(texture).m_110691_(false)));
        GUI_TRANSLUCENT = Util.m_143827_(texture -> IERenderTypes.createDefault("gui_translucent_" + texture, DefaultVertexFormat.f_85818_, VertexFormat.Mode.QUADS, IERenderTypes.makeGuiState(texture).m_110685_(TRANSLUCENT_TRANSPARENCY).m_110691_(false)));
        FULLBRIGHT_TRANSLUCENT = Util.m_143827_(texture -> IERenderTypes.createDefault("immersiveengineering:fullbright_translucent_" + texture, DefaultVertexFormat.f_85812_, VertexFormat.Mode.QUADS, RenderType.CompositeState.m_110628_().m_110685_(TRANSLUCENT_TRANSPARENCY).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(texture, false, false)).m_110671_(LIGHTMAP_DISABLED).m_173292_(FULLBRIGHT_BLOCKS).m_110661_(f_110110_).m_110677_(f_110154_).m_110691_(true)));
    }
}

