/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.manual;

import blusunrize.immersiveengineering.api.crafting.BlueprintCraftingRecipe;
import blusunrize.immersiveengineering.client.manual.ManualElementIECrafting;
import blusunrize.lib.manual.ManualInstance;
import blusunrize.lib.manual.ManualUtils;
import blusunrize.lib.manual.PositionedItemStack;
import net.minecraft.client.Minecraft;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class ManualElementBlueprint
extends ManualElementIECrafting {
    public ManualElementBlueprint(ManualInstance manual, ItemStack ... stacks) {
        super(manual, stacks);
        this.recalculateCraftingRecipes();
    }

    @Override
    public void recalculateCraftingRecipes() {
        this.recipes.clear();
        for (String category : BlueprintCraftingRecipe.recipeCategories) {
            for (BlueprintCraftingRecipe recipe : BlueprintCraftingRecipe.findRecipes((Level)Minecraft.m_91087_().f_91073_, category)) {
                for (int iStack = 0; iStack < this.stacks.length; ++iStack) {
                    ItemStack output = this.stacks[iStack];
                    if (((ItemStack)recipe.output.get()).m_41619_() || !ManualUtils.stackMatchesObject((ItemStack)recipe.output.get(), output) || recipe.inputs == null || recipe.inputs.length <= 0) continue;
                    int h = (int)Math.ceil((float)recipe.inputs.length / 2.0f);
                    PositionedItemStack[] pIngredients = new PositionedItemStack[recipe.inputs.length + 2];
                    for (int i = 0; i < recipe.inputs.length; ++i) {
                        pIngredients[i] = new PositionedItemStack(recipe.inputs[i].getMatchingStacks(), 32 + i % 2 * 18, i / 2 * 18);
                    }
                    int middle = (int)((float)h / 2.0f * 18.0f);
                    pIngredients[pIngredients.length - 2] = new PositionedItemStack((ItemStack)recipe.output.get(), 86, middle - 9);
                    pIngredients[pIngredients.length - 1] = new PositionedItemStack(BlueprintCraftingRecipe.getTypedBlueprint(category), 8, middle - 9);
                    this.recipes.add(pIngredients);
                    this.arrowPositions.add(new ManualElementIECrafting.ArrowPosition(69, middle - 5));
                    if (h * 18 <= this.yOff) continue;
                    this.yOff = h * 18;
                }
            }
        }
        this.providedItems.clear();
        for (ItemStack stack : this.stacks) {
            this.addProvidedItem(stack);
        }
    }
}

