/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.utils;

import blusunrize.immersiveengineering.api.utils.CapabilityUtils;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class ItemUtils {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();

    public static CompoundTag parseNbtFromJson(JsonElement jsonElement) throws CommandSyntaxException {
        if (jsonElement.isJsonObject()) {
            return TagParser.m_129359_((String)GSON.toJson(jsonElement));
        }
        return TagParser.m_129359_((String)jsonElement.getAsString());
    }

    public static HumanoidArm getLivingHand(LivingEntity living, InteractionHand hand) {
        HumanoidArm handside = living.m_5737_();
        if (hand != InteractionHand.MAIN_HAND) {
            handside = handside == HumanoidArm.LEFT ? HumanoidArm.RIGHT : HumanoidArm.LEFT;
        }
        return handside;
    }

    public static void removeTag(ItemStack stack, String key) {
        if (stack.m_41782_()) {
            CompoundTag tag = stack.m_41784_();
            tag.m_128473_(key);
            if (tag.m_128456_()) {
                stack.m_41751_(null);
            }
        }
    }

    public static boolean hasTag(ItemStack stack, String key, int type) {
        return stack.m_41782_() && stack.m_41784_().m_128425_(key, type);
    }

    public static void tryInsertEntity(Level level, BlockPos pos, Direction side, ItemEntity toInsert) {
        LazyOptional<IItemHandler> cap = CapabilityUtils.findItemHandlerAtPos(level, pos, side, true);
        cap.ifPresent(itemHandler -> {
            ItemStack stack = toInsert.m_32055_();
            ItemStack temp = ItemHandlerHelper.insertItem((IItemHandler)itemHandler, (ItemStack)stack, (boolean)true);
            if (temp.m_41613_() < stack.m_41613_()) {
                temp = ItemHandlerHelper.insertItem((IItemHandler)itemHandler, (ItemStack)stack, (boolean)false);
                if (temp.m_41619_()) {
                    toInsert.m_146870_();
                } else if (temp.m_41613_() < stack.m_41613_()) {
                    toInsert.m_32045_(temp);
                }
            }
        });
    }
}

