/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.crafting;

import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Transformation;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public interface ClocheRenderFunction {
    public static final Map<String, ClocheRenderFunctionFactory> RENDER_FUNCTION_FACTORIES = new HashMap<String, ClocheRenderFunctionFactory>();

    public float getScale(ItemStack var1, float var2);

    public Collection<Pair<BlockState, Transformation>> getBlocks(ItemStack var1, float var2);

    default public void injectQuads(ItemStack stack, float growth, Consumer<?> quadConsumer) {
    }

    public static class ClocheRenderReference {
        private final String type;
        private final Block block;

        public ClocheRenderReference(String type, Block block) {
            this.type = type;
            this.block = block;
        }

        public String getType() {
            return this.type;
        }

        public Block getBlock() {
            return this.block;
        }

        public void write(FriendlyByteBuf buffer) {
            buffer.m_130070_(this.getType());
            buffer.m_130085_(ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)this.getBlock()));
        }

        public static ClocheRenderReference read(FriendlyByteBuf buffer) {
            String key = buffer.m_130277_();
            ResourceLocation rl = buffer.m_130281_();
            return new ClocheRenderReference(key, (Block)ForgeRegistries.BLOCKS.getValue(rl));
        }

        public JsonObject serialize() {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("type", this.getType());
            jsonObject.addProperty("block", ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)this.getBlock()).toString());
            return jsonObject;
        }

        public static ClocheRenderReference deserialize(JsonObject jsonObject) {
            String key = GsonHelper.m_13906_((JsonObject)jsonObject, (String)"type");
            ResourceLocation rl = new ResourceLocation(GsonHelper.m_13906_((JsonObject)jsonObject, (String)"block"));
            return new ClocheRenderReference(key, (Block)ForgeRegistries.BLOCKS.getValue(rl));
        }
    }

    public static interface ClocheRenderFunctionFactory
    extends Function<Block, ClocheRenderFunction> {
    }
}

