/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.gamestages.command;

import com.google.gson.JsonObject;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.darkhax.bookshelf.api.serialization.Serializers;
import net.darkhax.gamestages.GameStageHelper;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.synchronization.ArgumentSerializer;
import net.minecraft.network.FriendlyByteBuf;

public class StageArgumentType
implements ArgumentType<String> {
    public static final ArgumentSerializer<StageArgumentType> SERIALIZERS = new Serializer();
    private static final List<String> examples = Arrays.asList("stage", "stage_name", "example:stage");
    private Set<String> knownStages = GameStageHelper.getKnownStages();

    public static String getStage(CommandContext<?> context, String name) {
        return (String)context.getArgument(name, String.class);
    }

    public String parse(StringReader reader) throws CommandSyntaxException {
        return reader.readUnquotedString();
    }

    public String toString() {
        return "stagename";
    }

    public Collection<String> getExamples() {
        return examples;
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        return SharedSuggestionProvider.m_82970_(this.knownStages, (SuggestionsBuilder)builder);
    }

    static class Serializer
    implements ArgumentSerializer<StageArgumentType> {
        Serializer() {
        }

        public void serializeToNetwork(StageArgumentType argument, FriendlyByteBuf buffer) {
            Serializers.STRING.toByteBufList(buffer, new ArrayList<String>(argument.knownStages));
        }

        public StageArgumentType deserializeFromNetwork(FriendlyByteBuf buffer) {
            StageArgumentType arg = new StageArgumentType();
            arg.knownStages = new HashSet<String>(Serializers.STRING.fromByteBufList(buffer));
            return arg;
        }

        public void serializeToJson(StageArgumentType argument, JsonObject json) {
            json.add("known_stages", Serializers.STRING.toJSONSet(argument.knownStages));
        }
    }
}

