/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.network;

import com.jaquadro.minecraft.storagedrawers.StorageDrawers;
import com.jaquadro.minecraft.storagedrawers.block.tile.TileEntityDrawers;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class CountUpdateMessage {
    private int x;
    private int y;
    private int z;
    private int slot;
    private int count;
    private boolean failed;

    public CountUpdateMessage(BlockPos pos, int slot, int count) {
        this.x = pos.m_123341_();
        this.y = pos.m_123342_();
        this.z = pos.m_123343_();
        this.slot = slot;
        this.count = count;
        this.failed = false;
    }

    private CountUpdateMessage(boolean failed) {
        this.failed = failed;
    }

    public static CountUpdateMessage decode(ByteBuf buf) {
        try {
            int x = buf.readInt();
            short y = buf.readShort();
            int z = buf.readInt();
            byte slot = buf.readByte();
            int count = buf.readInt();
            return new CountUpdateMessage(new BlockPos(x, (int)y, z), slot, count);
        }
        catch (IndexOutOfBoundsException e) {
            StorageDrawers.log.error("CountUpdateMessage: Unexpected end of packet.\nMessage: " + ByteBufUtil.hexDump((ByteBuf)buf, (int)0, (int)buf.writerIndex()), (Throwable)e);
            return new CountUpdateMessage(true);
        }
    }

    public static void encode(CountUpdateMessage msg, FriendlyByteBuf buf) {
        buf.writeInt(msg.x);
        buf.writeShort(msg.y);
        buf.writeInt(msg.z);
        buf.writeByte(msg.slot);
        buf.writeInt(msg.count);
    }

    public static void handle(CountUpdateMessage msg, Supplier<NetworkEvent.Context> ctx) {
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> CountUpdateMessage.lambda$handle$0(msg, (Supplier)ctx));
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void handleClient(CountUpdateMessage msg, NetworkEvent.Context ctx) {
        BlockPos pos;
        BlockEntity tileEntity;
        ClientLevel world;
        if (!msg.failed && (world = Minecraft.m_91087_().f_91073_) != null && (tileEntity = world.m_7702_(pos = new BlockPos(msg.x, msg.y, msg.z))) instanceof TileEntityDrawers) {
            ((TileEntityDrawers)tileEntity).clientUpdateCount(msg.slot, msg.count);
        }
        ctx.setPacketHandled(true);
    }

    private static /* synthetic */ void lambda$handle$0(CountUpdateMessage msg, Supplier ctx) {
        CountUpdateMessage.handleClient(msg, (NetworkEvent.Context)ctx.get());
    }
}

