/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.lib.util.managers;

import cofh.lib.util.ComparableItemStack;
import cofh.lib.util.ComparableItemStackNBT;
import cofh.lib.util.helpers.MathHelper;
import cofh.thermal.lib.util.managers.IManager;
import net.minecraft.world.item.ItemStack;

public abstract class AbstractManager
implements IManager {
    private static final int MIN_POWER = 1;
    private static final int MAX_POWER = 200;
    protected int defaultEnergy;
    protected float defaultScale = 1.0f;
    protected int basePower = 20;

    protected AbstractManager() {
    }

    protected AbstractManager(int defaultEnergy) {
        this.defaultEnergy = defaultEnergy;
    }

    protected AbstractManager setDefaultEnergy(int defaultEnergy) {
        if (defaultEnergy > 0) {
            this.defaultEnergy = defaultEnergy;
        }
        return this;
    }

    protected AbstractManager setDefaultScale(int defaultScale) {
        if (defaultScale > 0) {
            this.defaultScale = defaultScale;
        }
        return this;
    }

    public static ComparableItemStack convert(ItemStack stack) {
        return new ComparableItemStack(stack);
    }

    public static ComparableItemStack convertNBT(ItemStack stack) {
        return new ComparableItemStackNBT(stack);
    }

    public int getDefaultEnergy() {
        return this.defaultEnergy;
    }

    public float getDefaultScale() {
        return this.defaultScale;
    }

    public void setBasePower(int rate) {
        this.basePower = MathHelper.clamp((int)rate, (int)this.getMinPower(), (int)this.getMaxPower());
    }

    public int getBasePower() {
        return this.basePower;
    }

    public int getMinPower() {
        return 1;
    }

    public int getMaxPower() {
        return 200;
    }
}

