/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.lib.tileentity;

import cofh.lib.util.helpers.AugmentDataHelper;
import cofh.lib.util.helpers.AugmentableHelper;
import cofh.thermal.lib.common.ThermalAugmentRules;
import cofh.thermal.lib.tileentity.ThermalTileAugmentable;
import java.util.List;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public abstract class DeviceTileBase
extends ThermalTileAugmentable {
    protected float baseMod = 1.0f;

    public DeviceTileBase(BlockEntityType<?> tileEntityTypeIn, BlockPos pos, BlockState state) {
        super(tileEntityTypeIn, pos, state);
    }

    protected void updateValidity() {
    }

    protected void updateActiveState() {
        boolean curActive = this.isActive;
        this.isActive = this.redstoneControl.getState() && this.isValid();
        this.updateActiveState(curActive);
    }

    protected boolean isValid() {
        return true;
    }

    @Override
    public void neighborChanged(Block blockIn, BlockPos fromPos) {
        super.neighborChanged(blockIn, fromPos);
        this.updateValidity();
        this.updateActiveState();
    }

    @Override
    public void onPlacedBy(Level worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.onPlacedBy(worldIn, pos, state, placer, stack);
        this.updateValidity();
        this.updateActiveState();
    }

    @Override
    protected Predicate<ItemStack> augValidator() {
        BiPredicate<ItemStack, List<ItemStack>> validator = this.tankInv.hasTanks() ? ThermalAugmentRules.DEVICE_VALIDATOR : ThermalAugmentRules.DEVICE_NO_FLUID_VALIDATOR;
        return item -> AugmentDataHelper.hasAugmentData((ItemStack)item) && validator.test((ItemStack)item, this.getAugmentsAsList());
    }

    @Override
    protected void finalizeAttributes(Map<Enchantment, Integer> enchantmentMap) {
        super.finalizeAttributes(enchantmentMap);
        this.baseMod = AugmentableHelper.getAttributeModWithDefault((CompoundTag)this.augmentNBT, (String)"BaseMod", (float)1.0f);
    }

    @Override
    public void onControlUpdate() {
        this.updateActiveState();
        super.onControlUpdate();
    }
}

