/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.lib.item;

import cofh.core.item.EnergyContainerItem;
import cofh.lib.item.ContainerType;
import cofh.lib.item.IAugmentableItem;
import cofh.lib.util.helpers.AugmentDataHelper;
import cofh.lib.util.helpers.AugmentableHelper;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.IntSupplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public abstract class EnergyContainerItemAugmentable
extends EnergyContainerItem
implements IAugmentableItem {
    protected IntSupplier numSlots = () -> 0;
    protected BiPredicate<ItemStack, List<ItemStack>> augValidator = (e, f) -> true;

    public EnergyContainerItemAugmentable(Item.Properties builder, int maxEnergy, int maxTransfer) {
        super(builder, maxEnergy, maxTransfer);
    }

    public EnergyContainerItemAugmentable setNumSlots(IntSupplier numSlots) {
        this.numSlots = numSlots;
        return this;
    }

    public EnergyContainerItemAugmentable setAugValidator(BiPredicate<ItemStack, List<ItemStack>> augValidator) {
        this.augValidator = augValidator;
        return this;
    }

    public int getItemEnchantability(ItemStack stack) {
        return Math.round((float)super.getItemEnchantability(stack) * this.getBaseMod(stack));
    }

    protected float getBaseMod(ItemStack stack) {
        return AugmentableHelper.getPropertyWithDefault((ItemStack)stack, (String)"BaseMod", (float)1.0f);
    }

    protected void setAttributesFromAugment(ItemStack container, CompoundTag augmentData) {
        CompoundTag subTag = container.m_41737_("Properties");
        if (subTag == null) {
            return;
        }
        AugmentableHelper.setAttributeFromAugmentMax((CompoundTag)subTag, (CompoundTag)augmentData, (String)"BaseMod");
        AugmentableHelper.setAttributeFromAugmentMax((CompoundTag)subTag, (CompoundTag)augmentData, (String)"RFMax");
        AugmentableHelper.setAttributeFromAugmentMax((CompoundTag)subTag, (CompoundTag)augmentData, (String)"RFXfer");
        AugmentableHelper.setAttributeFromAugmentMax((CompoundTag)subTag, (CompoundTag)augmentData, (String)"RFCre");
    }

    public int getExtract(ItemStack container) {
        float base = AugmentableHelper.getPropertyWithDefault((ItemStack)container, (String)"BaseMod", (float)1.0f);
        float mod = AugmentableHelper.getPropertyWithDefault((ItemStack)container, (String)"RFXfer", (float)1.0f);
        return Math.round((float)this.extract * mod * base);
    }

    public int getReceive(ItemStack container) {
        float base = AugmentableHelper.getPropertyWithDefault((ItemStack)container, (String)"BaseMod", (float)1.0f);
        float mod = AugmentableHelper.getPropertyWithDefault((ItemStack)container, (String)"RFXfer", (float)1.0f);
        return Math.round((float)this.receive * mod * base);
    }

    public int getMaxEnergyStored(ItemStack container) {
        float base = AugmentableHelper.getPropertyWithDefault((ItemStack)container, (String)"BaseMod", (float)1.0f);
        float mod = AugmentableHelper.getPropertyWithDefault((ItemStack)container, (String)"RFMax", (float)1.0f);
        return this.getMaxStored(container, Math.round((float)this.maxEnergy * mod * base));
    }

    public int getAugmentSlots(ItemStack augmentable) {
        return this.numSlots.getAsInt();
    }

    public boolean validAugment(ItemStack augmentable, ItemStack augment, List<ItemStack> augments) {
        return this.augValidator.test(augment, augments);
    }

    public void updateAugmentState(ItemStack container, List<ItemStack> augments) {
        container.m_41784_().m_128365_("Properties", (Tag)new CompoundTag());
        for (ItemStack augment : augments) {
            CompoundTag augmentData = AugmentDataHelper.getAugmentData((ItemStack)augment);
            if (augmentData == null) continue;
            this.setAttributesFromAugment(container, augmentData);
        }
        if (this.isCreative(container, ContainerType.ENERGY)) {
            this.setEnergyStored(container, this.getMaxEnergyStored(container));
        } else {
            int energyExcess = this.getEnergyStored(container) - this.getMaxEnergyStored(container);
            if (energyExcess > 0) {
                this.setEnergyStored(container, this.getMaxEnergyStored(container));
            }
        }
    }
}

