/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.item;

import cofh.core.util.helpers.FluidHelper;
import cofh.lib.fluid.FluidStorageCoFH;
import cofh.lib.fluid.IFluidContainerItem;
import cofh.lib.item.ContainerType;
import cofh.lib.util.helpers.AugmentDataHelper;
import cofh.lib.util.helpers.AugmentableHelper;
import cofh.lib.util.helpers.StringHelper;
import cofh.thermal.lib.item.BlockItemAugmentable;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class FluidCellBlockItem
extends BlockItemAugmentable
implements IFluidContainerItem {
    public FluidCellBlockItem(Block blockIn, Item.Properties builder) {
        super(blockIn, builder);
        this.setEnchantability(5);
    }

    protected void tooltipDelegate(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        FluidStack fluid = this.getFluid(stack);
        if (!fluid.isEmpty()) {
            tooltip.add((Component)StringHelper.getFluidName((FluidStack)fluid));
        }
        tooltip.add((Component)(this.isCreative(stack, ContainerType.FLUID) ? StringHelper.getTextComponent((String)"info.cofh.infinite_source") : StringHelper.getTextComponent((String)(StringHelper.localize((String)"info.cofh.amount") + ": " + StringHelper.format((long)fluid.getAmount()) + " / " + StringHelper.format((long)this.getCapacity(stack)) + " mB"))));
        if (FluidHelper.hasPotionTag((FluidStack)fluid)) {
            tooltip.add((Component)StringHelper.getEmptyLine());
            tooltip.add((Component)StringHelper.getTextComponent((String)(StringHelper.localize((String)"info.cofh.effects") + ":")));
            FluidHelper.addPotionTooltip((FluidStack)fluid, tooltip);
        }
    }

    protected void setAttributesFromAugment(ItemStack container, CompoundTag augmentData) {
        CompoundTag subTag = container.m_41737_("Properties");
        if (subTag == null) {
            return;
        }
        AugmentableHelper.setAttributeFromAugmentMax((CompoundTag)subTag, (CompoundTag)augmentData, (String)"BaseMod");
        AugmentableHelper.setAttributeFromAugmentMax((CompoundTag)subTag, (CompoundTag)augmentData, (String)"FluidMax");
        AugmentableHelper.setAttributeFromAugmentMax((CompoundTag)subTag, (CompoundTag)augmentData, (String)"FluidCre");
    }

    public CompoundTag getOrCreateTankTag(ItemStack container) {
        CompoundTag blockTag = container.m_41698_("BlockEntityTag");
        ListTag tanks = blockTag.m_128437_("TankInv", 10);
        if (tanks.isEmpty()) {
            CompoundTag tag = new CompoundTag();
            tag.m_128344_("Tank", (byte)0);
            new FluidStorageCoFH(32000).write(tag);
            tanks.add((Object)tag);
            blockTag.m_128365_("TankInv", (Tag)tanks);
        }
        return tanks.m_128728_(0);
    }

    public FluidStack getFluid(ItemStack container) {
        CompoundTag tag = this.getOrCreateTankTag(container);
        return FluidStack.loadFluidStackFromNBT((CompoundTag)tag);
    }

    public int getCapacity(ItemStack container) {
        CompoundTag tag = this.getOrCreateTankTag(container);
        if (tag == null) {
            return 0;
        }
        float base = AugmentableHelper.getPropertyWithDefault((ItemStack)container, (String)"BaseMod", (float)1.0f);
        float mod = AugmentableHelper.getPropertyWithDefault((ItemStack)container, (String)"FluidMax", (float)1.0f);
        return this.getMaxStored(container, Math.round((float)tag.m_128451_("Capacity") * mod * base));
    }

    public int fill(ItemStack container, FluidStack resource, IFluidHandler.FluidAction action) {
        CompoundTag containerTag = this.getOrCreateTankTag(container);
        if (resource.isEmpty() || !this.isFluidValid(container, resource)) {
            return 0;
        }
        FluidStorageCoFH tank = new FluidStorageCoFH(32000).setCapacity(this.getCapacity(container)).read(containerTag);
        if (this.isCreative(container, ContainerType.FLUID)) {
            if (action.execute()) {
                tank.setFluidStack(new FluidStack(resource, tank.getCapacity()));
                tank.write(containerTag);
            }
            return resource.getAmount();
        }
        int ret = tank.fill(resource, action);
        tank.write(containerTag);
        return ret;
    }

    public FluidStack drain(ItemStack container, int maxDrain, IFluidHandler.FluidAction action) {
        CompoundTag containerTag = this.getOrCreateTankTag(container);
        FluidStorageCoFH tank = new FluidStorageCoFH(32000).setCapacity(this.getCapacity(container)).read(containerTag);
        if (this.isCreative(container, ContainerType.FLUID)) {
            return new FluidStack(tank.getFluidStack(), maxDrain);
        }
        FluidStack ret = tank.drain(maxDrain, action);
        tank.write(containerTag);
        return ret;
    }

    @Override
    public void updateAugmentState(ItemStack container, List<ItemStack> augments) {
        container.m_41784_().m_128365_("Properties", (Tag)new CompoundTag());
        for (ItemStack augment : augments) {
            CompoundTag augmentData = AugmentDataHelper.getAugmentData((ItemStack)augment);
            if (augmentData == null) continue;
            this.setAttributesFromAugment(container, augmentData);
        }
        int fluidExcess = this.getFluidAmount(container) - this.getCapacity(container);
        if (fluidExcess > 0) {
            this.drain(container, fluidExcess, IFluidHandler.FluidAction.EXECUTE);
        }
    }
}

