/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.item;

import cofh.core.item.ArmorItemCoFH;
import cofh.lib.client.renderer.entity.model.ArmorFullSuitModel;
import cofh.lib.util.helpers.StringHelper;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.IItemRenderProperties;
import net.minecraftforge.common.ForgeMod;

public class DivingArmorItem
extends ArmorItemCoFH {
    protected static final double[] SWIM_SPEED_BONUS = new double[]{0.6, 0.3, 0.1, 0.0};
    protected static final int AIR_DURATION = 1800;
    private Multimap<Attribute, AttributeModifier> armorAttributes;

    public DivingArmorItem(ArmorMaterial materialIn, EquipmentSlot slot, Item.Properties builder) {
        super(materialIn, slot, builder);
        ImmutableMultimap.Builder multimap = ImmutableMultimap.builder();
        this.armorAttributes = multimap.build();
    }

    public void setup() {
        ImmutableMultimap.Builder multimap = ImmutableMultimap.builder();
        multimap.putAll(super.m_7167_(this.f_40377_));
        multimap.put((Object)((Attribute)ForgeMod.SWIM_SPEED.get()), (Object)new AttributeModifier(UUID_SWIM_SPEED[this.f_40377_.m_20749_()], "Swim Speed", SWIM_SPEED_BONUS[this.f_40377_.m_20749_()], AttributeModifier.Operation.ADDITION));
        this.armorAttributes = multimap.build();
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        if (this.f_40377_ == EquipmentSlot.HEAD) {
            tooltip.add((Component)StringHelper.getTextComponent((String)"info.thermal.diving_helmet").m_130940_(ChatFormatting.GOLD));
        }
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        return slot == this.f_40377_ ? this.armorAttributes : ImmutableMultimap.of();
    }

    public void onArmorTick(ItemStack stack, Level world, Player player) {
        if (this.f_40377_ == EquipmentSlot.HEAD && player.m_20146_() < player.m_6062_() && world.f_46441_.nextInt(5) > 0) {
            player.m_20301_(player.m_20146_() + 1);
        }
    }

    public void initializeClient(Consumer<IItemRenderProperties> consumer) {
        consumer.accept(new IItemRenderProperties(){

            @Nonnull
            public HumanoidModel<?> getArmorModel(LivingEntity entityLiving, ItemStack itemStack, EquipmentSlot armorSlot, HumanoidModel<?> _default) {
                return armorSlot == EquipmentSlot.LEGS || armorSlot == EquipmentSlot.FEET ? _default : (HumanoidModel)ArmorFullSuitModel.INSTANCE.get();
            }
        });
    }
}

