/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.entity.projectile;

import cofh.lib.entity.ElectricArc;
import cofh.lib.util.Utils;
import cofh.lib.util.references.CoreReferences;
import cofh.thermal.core.config.ThermalCoreConfig;
import cofh.thermal.core.entity.monster.Basalz;
import cofh.thermal.core.entity.projectile.ElementalProjectile;
import cofh.thermal.core.init.TCoreReferences;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.EntityDamageSource;
import net.minecraft.world.damagesource.IndirectEntityDamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;

public class BlitzProjectile
extends ElementalProjectile {
    public static float defaultDamage = 5.0f;
    public static int effectAmplifier = 0;
    public static int effectDuration = 100;

    public BlitzProjectile(EntityType<? extends AbstractHurtingProjectile> type, Level world) {
        super(type, world);
    }

    public BlitzProjectile(LivingEntity shooter, double accelX, double accelY, double accelZ, Level world) {
        super(TCoreReferences.BLITZ_PROJECTILE_ENTITY, shooter, accelX, accelY, accelZ, world);
    }

    public BlitzProjectile(double x, double y, double z, double accelX, double accelY, double accelZ, Level world) {
        super(TCoreReferences.BLITZ_PROJECTILE_ENTITY, x, y, z, accelX, accelY, accelZ, world);
    }

    protected ParticleOptions m_5967_() {
        return ParticleTypes.f_123751_;
    }

    protected void m_6532_(HitResult result) {
        Entity entity;
        Entity owner = this.m_37282_();
        this.f_19853_.m_7967_((Entity)new ElectricArc(this.f_19853_, result.m_82450_()).setCosmetic(true).setOwner(owner instanceof LivingEntity ? (LivingEntity)owner : null));
        if (result.m_6662_() == HitResult.Type.ENTITY && (entity = ((EntityHitResult)result).m_82443_()).m_6469_(BlitzDamageSource.causeDamage(this, owner), this.getDamage(entity)) && !entity.m_20147_() && entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            living.m_7292_(new MobEffectInstance(CoreReferences.SHOCKED, this.getEffectDuration(entity), this.getEffectAmplifier(entity), false, false));
        }
        if (ThermalCoreConfig.mobBlitzLightning && Utils.isServerWorld((Level)this.f_19853_)) {
            BlockPos pos = new BlockPos(result.m_82450_());
            if (this.f_19853_.m_45527_(pos)) {
                float f = this.f_19796_.nextFloat();
                float f2 = this.f_19853_.m_46758_(pos) ? (this.f_19853_.m_46470_() ? 0.2f : 0.1f) : 0.04f;
                if (f < f2) {
                    Utils.spawnLightningBolt((Level)this.f_19853_, (BlockPos)pos);
                }
            }
            this.f_19853_.m_7605_((Entity)this, (byte)3);
            this.m_146870_();
        }
    }

    protected float m_6884_() {
        return 1.0f;
    }

    @Override
    public float getDamage(Entity target) {
        return target.m_20070_() || target instanceof Basalz ? defaultDamage + 3.0f : defaultDamage;
    }

    @Override
    public int getEffectAmplifier(Entity target) {
        return effectAmplifier;
    }

    @Override
    public int getEffectDuration(Entity target) {
        return effectDuration;
    }

    protected static class BlitzDamageSource
    extends EntityDamageSource {
        public BlitzDamageSource(Entity source) {
            super("blitz", source);
        }

        public static DamageSource causeDamage(BlitzProjectile entityProj, Entity entitySource) {
            return new IndirectEntityDamageSource("blitz", (Entity)entityProj, (Entity)(entitySource == null ? entityProj : entitySource)).m_19366_();
        }
    }
}

