/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.entity.projectile;

import cofh.lib.util.Utils;
import cofh.lib.util.references.CoreReferences;
import cofh.thermal.core.entity.monster.Blitz;
import cofh.thermal.core.entity.projectile.ElementalProjectile;
import cofh.thermal.core.init.TCoreReferences;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.EntityDamageSource;
import net.minecraft.world.damagesource.IndirectEntityDamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class BasalzProjectile
extends ElementalProjectile {
    public static float defaultDamage = 6.0f;
    public static int effectAmplifier = 0;
    public static int effectDuration = 100;
    public static float knockbackStrength = 1.2f;

    public BasalzProjectile(EntityType<? extends AbstractHurtingProjectile> type, Level world) {
        super(type, world);
    }

    public BasalzProjectile(LivingEntity shooter, double accelX, double accelY, double accelZ, Level world) {
        super(TCoreReferences.BASALZ_PROJECTILE_ENTITY, shooter, accelX, accelY, accelZ, world);
    }

    public BasalzProjectile(double x, double y, double z, double accelX, double accelY, double accelZ, Level world) {
        super(TCoreReferences.BASALZ_PROJECTILE_ENTITY, x, y, z, accelX, accelY, accelZ, world);
    }

    protected ParticleOptions m_5967_() {
        return ParticleTypes.f_123801_;
    }

    public void m_6532_(HitResult result) {
        Entity entity;
        if (result.m_6662_() == HitResult.Type.ENTITY && (entity = ((EntityHitResult)result).m_82443_()).m_6469_(BasalzDamageSource.causeDamage(this, this.m_37282_()), this.getDamage(entity)) && !entity.m_20147_() && entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            living.m_7292_(new MobEffectInstance(CoreReferences.SUNDERED, this.getEffectDuration(entity), this.getEffectAmplifier(entity), false, false));
            Vec3 velocity = this.m_20184_();
            if (velocity.m_82556_() > 0.01) {
                living.m_147240_((double)knockbackStrength, -velocity.f_82479_, -velocity.f_82481_);
            }
        }
        if (Utils.isServerWorld((Level)this.f_19853_)) {
            this.f_19853_.m_7605_((Entity)this, (byte)3);
            this.m_146870_();
        }
    }

    @Override
    public float getDamage(Entity target) {
        return target instanceof Blitz ? defaultDamage + 3.0f : defaultDamage;
    }

    @Override
    public int getEffectAmplifier(Entity target) {
        return effectAmplifier;
    }

    @Override
    public int getEffectDuration(Entity target) {
        return effectDuration;
    }

    protected static class BasalzDamageSource
    extends EntityDamageSource {
        public BasalzDamageSource(Entity source) {
            super("basalz", source);
        }

        public static DamageSource causeDamage(BasalzProjectile entityProj, Entity entitySource) {
            return new IndirectEntityDamageSource("basalz", (Entity)entityProj, (Entity)(entitySource == null ? entityProj : entitySource)).m_19366_();
        }
    }
}

