/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.compat.jei.device;

import cofh.core.util.helpers.RenderHelper;
import cofh.lib.util.helpers.StringHelper;
import cofh.thermal.core.client.gui.device.DeviceTreeExtractorScreen;
import cofh.thermal.core.compat.jei.TCoreJeiPlugin;
import cofh.thermal.core.init.TCoreReferences;
import cofh.thermal.core.util.recipes.device.TreeExtractorMapping;
import cofh.thermal.lib.compat.jei.Drawables;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.fluids.FluidStack;

public class TreeExtractorCategory
implements IRecipeCategory<TreeExtractorMapping> {
    protected final ResourceLocation uid;
    protected IDrawable background;
    protected IDrawable icon;
    protected Component name;
    protected IDrawableStatic tankBackground;
    protected IDrawableStatic tankOverlay;
    protected IDrawableStatic progressFluidBackground;
    protected IDrawableAnimated progressFluid;

    public TreeExtractorCategory(IGuiHelper guiHelper, ItemStack icon, ResourceLocation uid) {
        this.uid = uid;
        this.icon = guiHelper.createDrawableIngredient(VanillaTypes.ITEM, (Object)icon);
        this.background = guiHelper.drawableBuilder(DeviceTreeExtractorScreen.TEXTURE, 86, 11, 80, 62).addPadding(0, 0, 16, 68).build();
        this.name = StringHelper.getTextComponent((String)TCoreReferences.DEVICE_TREE_EXTRACTOR_BLOCK.m_7705_());
        this.tankBackground = Drawables.getDrawables(guiHelper).getTank(1);
        this.tankOverlay = Drawables.getDrawables(guiHelper).getTankOverlay(1);
        this.progressFluidBackground = Drawables.getDrawables(guiHelper).getProgressFill(2);
        this.progressFluid = guiHelper.createAnimatedDrawable(Drawables.getDrawables(guiHelper).getProgress(2), 100, IDrawableAnimated.StartDirection.LEFT, true);
    }

    public ResourceLocation getUid() {
        return this.uid;
    }

    public Class<? extends TreeExtractorMapping> getRecipeClass() {
        return TreeExtractorMapping.class;
    }

    public Component getTitle() {
        return this.name;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, TreeExtractorMapping recipe, IFocusGroup focuses) {
        ItemStack trunk = new ItemStack((ItemLike)recipe.getTrunk());
        ItemStack leaves = new ItemStack((ItemLike)recipe.getLeaves());
        builder.addSlot(RecipeIngredientRole.INPUT, 35, 41).addItemStack(trunk);
        builder.addSlot(RecipeIngredientRole.INPUT, 35, 23).addItemStack(trunk);
        builder.addSlot(RecipeIngredientRole.INPUT, 17, 14).addItemStack(leaves);
        builder.addSlot(RecipeIngredientRole.INPUT, 35, 5).addItemStack(leaves);
        builder.addSlot(RecipeIngredientRole.INPUT, 53, 14).addItemStack(leaves);
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 116, 11).addIngredients(VanillaTypes.FLUID, List.of(recipe.getFluid()))).setFluidRenderer(TCoreJeiPlugin.tankSize(8000), false, 16, 40).setOverlay((IDrawable)this.tankOverlay, 0, 0).addTooltipCallback(TCoreJeiPlugin.defaultFluidTooltip());
    }

    public void draw(TreeExtractorMapping recipe, IRecipeSlotsView recipeSlotsView, PoseStack matrixStack, double mouseX, double mouseY) {
        this.tankBackground.draw(matrixStack, 115, 10);
        RenderHelper.drawFluid((PoseStack)matrixStack, (int)78, (int)23, (FluidStack)recipe.getFluid(), (int)24, (int)16);
        this.progressFluidBackground.draw(matrixStack, 78, 23);
        this.progressFluid.draw(matrixStack, 78, 23);
    }
}

