/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.client.renderer.model;

import cofh.core.client.renderer.model.ModelUtils;
import cofh.core.util.helpers.FluidHelper;
import cofh.core.util.helpers.RenderHelper;
import cofh.lib.client.renderer.model.RetexturedBakedQuad;
import cofh.lib.fluid.IFluidContainerItem;
import cofh.lib.item.ContainerType;
import cofh.lib.item.ICoFHItem;
import cofh.lib.util.ComparableItemStack;
import cofh.lib.util.helpers.MathHelper;
import cofh.thermal.core.client.ThermalTextures;
import cofh.thermal.core.client.renderer.model.UnderlayBakedModel;
import cofh.thermal.lib.util.Constants;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.IDynamicBakedModel;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.fluids.FluidStack;

public class FluidCellBakedModel
extends UnderlayBakedModel
implements IDynamicBakedModel {
    private static final Map<List<Integer>, BakedQuad> FACE_QUAD_CACHE = new Object2ObjectOpenHashMap();
    private static final Int2ObjectMap<BakedQuad[]> SIDE_QUAD_CACHE = new Int2ObjectOpenHashMap();
    private static final Int2ObjectMap<BakedQuad[]> ITEM_UNDERLAY_QUAD_CACHE = new Int2ObjectOpenHashMap();
    private static final Int2ObjectMap<BakedQuad[]> ITEM_QUAD_CACHE = new Int2ObjectOpenHashMap();
    private static final Map<List<Integer>, BakedModel> MODEL_CACHE = new Object2ObjectOpenHashMap();
    private final ItemOverrides overrideList = new ItemOverrides(){

        @Nullable
        public BakedModel m_173464_(BakedModel model, ItemStack stack, @Nullable ClientLevel worldIn, @Nullable LivingEntity entityIn, int seed) {
            CompoundTag tag = stack.m_41737_("BlockEntityTag");
            byte[] sideConfigRaw = FluidCellBakedModel.this.getSideConfigRaw(tag);
            int itemHash = new ComparableItemStack(stack).hashCode();
            int level = FluidCellBakedModel.this.getLevel(stack);
            int configHash = Arrays.hashCode(sideConfigRaw);
            FluidStack fluid = FluidCellBakedModel.this.getFluid(tag);
            int fluidHash = fluid.isEmpty() ? 0 : FluidHelper.fluidHashcode((FluidStack)fluid);
            BakedModel ret = MODEL_CACHE.get(Arrays.asList(itemHash, level, configHash, fluidHash));
            if (ret == null) {
                BakedQuad[] cachedQuads;
                ModelUtils.WrappedBakedModelBuilder builder = new ModelUtils.WrappedBakedModelBuilder(model);
                builder.addFaceQuad(Direction.NORTH, (BakedQuad)new RetexturedBakedQuad((BakedQuad)builder.getQuads(Direction.NORTH).get(0), FluidCellBakedModel.this.getLevelTexture(level)));
                if (!fluid.isEmpty()) {
                    BakedQuad[] cachedUnderlayQuads = (BakedQuad[])ITEM_UNDERLAY_QUAD_CACHE.get(FluidHelper.fluidHashcode((FluidStack)fluid));
                    if (cachedUnderlayQuads == null || cachedUnderlayQuads.length < 6) {
                        cachedUnderlayQuads = new BakedQuad[6];
                        TextureAtlasSprite fluidTexture = RenderHelper.getFluidTexture((FluidStack)fluid);
                        int fluidColor = RenderHelper.getFluidColor((FluidStack)fluid);
                        cachedUnderlayQuads[0] = new RetexturedBakedQuad(RenderHelper.mulColor((BakedQuad)((BakedQuad)builder.getQuads(Direction.DOWN).get(0)), (int)fluidColor), fluidTexture);
                        cachedUnderlayQuads[1] = new RetexturedBakedQuad(RenderHelper.mulColor((BakedQuad)((BakedQuad)builder.getQuads(Direction.UP).get(0)), (int)fluidColor), fluidTexture);
                        cachedUnderlayQuads[2] = new RetexturedBakedQuad(RenderHelper.mulColor((BakedQuad)((BakedQuad)builder.getQuads(Direction.NORTH).get(0)), (int)fluidColor), fluidTexture);
                        cachedUnderlayQuads[3] = new RetexturedBakedQuad(RenderHelper.mulColor((BakedQuad)((BakedQuad)builder.getQuads(Direction.SOUTH).get(0)), (int)fluidColor), fluidTexture);
                        cachedUnderlayQuads[4] = new RetexturedBakedQuad(RenderHelper.mulColor((BakedQuad)((BakedQuad)builder.getQuads(Direction.WEST).get(0)), (int)fluidColor), fluidTexture);
                        cachedUnderlayQuads[5] = new RetexturedBakedQuad(RenderHelper.mulColor((BakedQuad)((BakedQuad)builder.getQuads(Direction.EAST).get(0)), (int)fluidColor), fluidTexture);
                        ITEM_UNDERLAY_QUAD_CACHE.put(fluidHash, (Object)cachedUnderlayQuads);
                    }
                    builder.addUnderlayQuad(Direction.DOWN, cachedUnderlayQuads[0]);
                    builder.addUnderlayQuad(Direction.UP, cachedUnderlayQuads[1]);
                    builder.addUnderlayQuad(Direction.NORTH, cachedUnderlayQuads[2]);
                    builder.addUnderlayQuad(Direction.SOUTH, cachedUnderlayQuads[3]);
                    builder.addUnderlayQuad(Direction.WEST, cachedUnderlayQuads[4]);
                    builder.addUnderlayQuad(Direction.EAST, cachedUnderlayQuads[5]);
                }
                if ((cachedQuads = (BakedQuad[])ITEM_QUAD_CACHE.get(configHash)) == null || cachedQuads.length < 6) {
                    cachedQuads = new BakedQuad[]{new RetexturedBakedQuad((BakedQuad)builder.getQuads(Direction.DOWN).get(0), FluidCellBakedModel.this.getConfigTexture(sideConfigRaw[0])), new RetexturedBakedQuad((BakedQuad)builder.getQuads(Direction.UP).get(0), FluidCellBakedModel.this.getConfigTexture(sideConfigRaw[1])), new RetexturedBakedQuad((BakedQuad)builder.getQuads(Direction.NORTH).get(0), FluidCellBakedModel.this.getConfigTexture(sideConfigRaw[2])), new RetexturedBakedQuad((BakedQuad)builder.getQuads(Direction.SOUTH).get(0), FluidCellBakedModel.this.getConfigTexture(sideConfigRaw[3])), new RetexturedBakedQuad((BakedQuad)builder.getQuads(Direction.WEST).get(0), FluidCellBakedModel.this.getConfigTexture(sideConfigRaw[4])), new RetexturedBakedQuad((BakedQuad)builder.getQuads(Direction.EAST).get(0), FluidCellBakedModel.this.getConfigTexture(sideConfigRaw[5]))};
                    ITEM_QUAD_CACHE.put(configHash, (Object)cachedQuads);
                }
                builder.addFaceQuad(Direction.DOWN, cachedQuads[0]);
                builder.addFaceQuad(Direction.UP, cachedQuads[1]);
                builder.addFaceQuad(Direction.NORTH, cachedQuads[2]);
                builder.addFaceQuad(Direction.SOUTH, cachedQuads[3]);
                builder.addFaceQuad(Direction.WEST, cachedQuads[4]);
                builder.addFaceQuad(Direction.EAST, cachedQuads[5]);
                ret = builder.build();
                MODEL_CACHE.put(Arrays.asList(itemHash, level, configHash, fluidHash), ret);
            }
            return ret;
        }
    };

    public static void clearCache() {
        FACE_QUAD_CACHE.clear();
        SIDE_QUAD_CACHE.clear();
        ITEM_UNDERLAY_QUAD_CACHE.clear();
        ITEM_QUAD_CACHE.clear();
        MODEL_CACHE.clear();
    }

    public FluidCellBakedModel(BakedModel originalModel) {
        super(originalModel);
        this.underlayQuadLevel = 1;
    }

    @Override
    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData) {
        byte[] sideConfigRaw;
        LinkedList<BakedQuad> quads = new LinkedList<BakedQuad>(this.originalModel.getQuads(state, side, rand, extraData));
        if (side == null || quads.isEmpty()) {
            return quads;
        }
        BakedQuad baseQuad = quads.get(0);
        int sideIndex = side.m_122411_();
        Direction face = (Direction)extraData.getData(ModelUtils.FACING);
        if (side == face) {
            Integer level = (Integer)extraData.getData(ModelUtils.LEVEL);
            if (level == null) {
                return quads;
            }
            BakedQuad faceQuad = FACE_QUAD_CACHE.get(Arrays.asList(face.m_122411_(), level));
            if (faceQuad == null) {
                faceQuad = new RetexturedBakedQuad(quads.get(1), this.getLevelTexture(level));
                FACE_QUAD_CACHE.put(Arrays.asList(face.m_122411_(), level), faceQuad);
            }
            quads.add(faceQuad);
        }
        if ((sideConfigRaw = (byte[])extraData.getData(ModelUtils.SIDES)) == null) {
            return quads;
        }
        int configHash = Arrays.hashCode(sideConfigRaw);
        BakedQuad[] cachedSideQuads = (BakedQuad[])SIDE_QUAD_CACHE.get(configHash);
        if (cachedSideQuads == null || cachedSideQuads.length < 6) {
            cachedSideQuads = new BakedQuad[6];
        }
        if (cachedSideQuads[sideIndex] == null) {
            cachedSideQuads[sideIndex] = new RetexturedBakedQuad(baseQuad, this.getConfigTexture(sideConfigRaw[sideIndex]));
            SIDE_QUAD_CACHE.put(configHash, (Object)cachedSideQuads);
        }
        quads.add(cachedSideQuads[sideIndex]);
        return super.addUnderlayQuads(quads, state, side, rand, extraData);
    }

    public ItemOverrides m_7343_() {
        return this.overrideList;
    }

    private TextureAtlasSprite getConfigTexture(byte side) {
        switch (side) {
            case 1: {
                return ThermalTextures.CELL_CONFIG_INPUT;
            }
            case 2: {
                return ThermalTextures.CELL_CONFIG_OUTPUT;
            }
            case 3: {
                return ThermalTextures.CELL_CONFIG_BOTH;
            }
        }
        return ThermalTextures.CELL_CONFIG_NONE;
    }

    private TextureAtlasSprite getLevelTexture(int level) {
        if (level > 8) {
            return level >= 10 ? ThermalTextures.FLUID_CELL_LEVEL_0_C : ThermalTextures.FLUID_CELL_LEVEL_8_C;
        }
        return ThermalTextures.FLUID_CELL_LEVELS[MathHelper.clamp((int)level, (int)0, (int)8)];
    }

    private FluidStack getFluid(CompoundTag tag) {
        if (tag == null) {
            return FluidStack.EMPTY;
        }
        ListTag tanks = tag.m_128437_("TankInv", 10);
        if (tanks.isEmpty()) {
            return FluidStack.EMPTY;
        }
        return FluidStack.loadFluidStackFromNBT((CompoundTag)tanks.m_128728_(0));
    }

    private byte[] getSideConfigRaw(CompoundTag tag) {
        if (tag == null) {
            return Constants.DEFAULT_CELL_SIDES_RAW;
        }
        byte[] ret = tag.m_128463_("Sides");
        return ret.length == 0 ? Constants.DEFAULT_CELL_SIDES_RAW : ret;
    }

    private int getLevel(ItemStack stack) {
        Item item = stack.m_41720_();
        if (item instanceof ICoFHItem && ((ICoFHItem)item).isCreative(stack, ContainerType.FLUID)) {
            if (item instanceof IFluidContainerItem && ((IFluidContainerItem)item).getFluidAmount(stack) > 0) {
                return 9;
            }
            return 10;
        }
        if (item instanceof IFluidContainerItem && ((IFluidContainerItem)item).getFluidAmount(stack) > 0) {
            return 1 + Math.min(((IFluidContainerItem)item).getScaledFluidStored(stack, 8), 7);
        }
        return 0;
    }
}

