/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.rainshield.util;

import com.mrbysco.rainshield.block.RainShieldBlock;
import com.mrbysco.rainshield.client.RainShieldConfig;
import com.mrbysco.rainshield.handler.SyncHandler;
import com.mrbysco.rainshield.network.PacketHandler;
import com.mrbysco.rainshield.network.message.SyncShieldMapMessage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;
import net.minecraftforge.network.PacketDistributor;

public class RainShieldData
extends SavedData {
    private static final String DATA_NAME = "rainshield_world_data";
    public static Map<ResourceLocation, List<BlockPos>> rainShieldMap = new HashMap<ResourceLocation, List<BlockPos>>();

    public RainShieldData(Map<ResourceLocation, List<BlockPos>> rainShieldMap) {
        RainShieldData.rainShieldMap = rainShieldMap;
    }

    public RainShieldData() {
        this(new HashMap<ResourceLocation, List<BlockPos>>());
    }

    public static void addRainShieldPos(BlockPos pos, Level level) {
        ResourceLocation dimensionLocation = level.m_46472_().m_135782_();
        List blockPositions = rainShieldMap.getOrDefault(dimensionLocation, new ArrayList());
        blockPositions.add(pos);
        rainShieldMap.put(dimensionLocation, blockPositions);
        if (!level.f_46443_) {
            RainShieldData data = RainShieldData.get(level);
            data.m_77760_(true);
            ((ServerLevel)level).m_6907_().forEach(SyncHandler::syncShieldMap);
        }
    }

    public static void removeRainShieldPos(BlockPos pos, Level level) {
        ResourceLocation dimensionLocation = level.m_46472_().m_135782_();
        List blockPositions = rainShieldMap.getOrDefault(dimensionLocation, new ArrayList());
        if (!blockPositions.isEmpty()) {
            blockPositions.removeIf(position -> position.equals((Object)pos));
            rainShieldMap.put(dimensionLocation, blockPositions);
            if (!level.f_46443_) {
                RainShieldData data = RainShieldData.get(level);
                data.m_77760_(true);
            }
        }
    }

    public static boolean cancelRain(Level level, BlockPos pos) {
        ResourceLocation dimensionLocation;
        if (level != null && rainShieldMap.containsKey(dimensionLocation = level.m_46472_().m_135782_())) {
            List<BlockPos> blockPositions = rainShieldMap.get(dimensionLocation);
            for (BlockPos shieldPos : blockPositions) {
                BlockState state;
                double distance;
                if (!level.isAreaLoaded(shieldPos, 1) || !((distance = (double)pos.m_123333_((Vec3i)shieldPos)) <= (double)((Integer)RainShieldConfig.COMMON.rainShieldDistance.get()).intValue()) || !((state = level.m_8055_(shieldPos)).m_60734_() instanceof RainShieldBlock) || ((Boolean)state.m_61143_((Property)RainShieldBlock.POWERED)).booleanValue()) continue;
                return true;
            }
        }
        return false;
    }

    public static RainShieldData load(CompoundTag tag) {
        PacketHandler.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new SyncShieldMapMessage(tag));
        ListTag rainShieldMap = tag.m_128437_("RainShieldMap", 10);
        HashMap<ResourceLocation, List<BlockPos>> shieldMap = new HashMap<ResourceLocation, List<BlockPos>>();
        for (int i = 0; i < rainShieldMap.size(); ++i) {
            CompoundTag listTag = rainShieldMap.m_128728_(i);
            String dimension = listTag.m_128461_("Dimension");
            ResourceLocation dimensionLocation = ResourceLocation.m_135820_((String)dimension);
            ArrayList<BlockPos> blockPositionsList = new ArrayList<BlockPos>();
            ListTag blockPositions = listTag.m_128437_("BlockPositions", 10);
            for (int j = 0; j < blockPositions.size(); ++j) {
                CompoundTag blockPosTag = blockPositions.m_128728_(j);
                BlockPos pos = BlockPos.m_122022_((long)blockPosTag.m_128454_("BlockPos"));
                blockPositionsList.add(pos);
            }
            shieldMap.put(dimensionLocation, blockPositionsList);
        }
        return new RainShieldData(shieldMap);
    }

    public CompoundTag m_7176_(CompoundTag tag) {
        ListTag rainShieldList = new ListTag();
        for (Map.Entry<ResourceLocation, List<BlockPos>> entry : rainShieldMap.entrySet()) {
            CompoundTag shieldTag = new CompoundTag();
            shieldTag.m_128359_("Dimension", entry.getKey().toString());
            ListTag blockPositions = new ListTag();
            for (BlockPos pos : entry.getValue()) {
                CompoundTag blockPosTag = new CompoundTag();
                blockPosTag.m_128356_("BlockPos", pos.m_121878_());
                blockPositions.add((Object)blockPosTag);
            }
            shieldTag.m_128365_("BlockPositions", (Tag)blockPositions);
            rainShieldList.add((Object)shieldTag);
        }
        tag.m_128365_("RainShieldMap", (Tag)rainShieldList);
        return tag;
    }

    public static RainShieldData get(Level level) {
        if (!(level instanceof ServerLevel)) {
            throw new RuntimeException("Attempted to get the data from a client level. This is wrong.");
        }
        ServerLevel overworld = level.m_142572_().m_129880_(Level.f_46428_);
        DimensionDataStorage storage = overworld.m_8895_();
        return (RainShieldData)storage.m_164861_(RainShieldData::load, RainShieldData::new, DATA_NAME);
    }
}

