/*
 * Decompiled with CFR 0.152.
 */
package com.rejahtavi.betterflight.common;

import com.rejahtavi.betterflight.client.ClientConfig;
import com.rejahtavi.betterflight.common.ServerConfig;
import com.rejahtavi.betterflight.common.Sounds;
import com.rejahtavi.betterflight.network.CFlightActionPacket;
import com.rejahtavi.betterflight.network.SElytraChargePacket;
import java.util.function.Supplier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.NetworkEvent;

@Mod.EventBusSubscriber(modid="betterflight", value={Dist.DEDICATED_SERVER})
public class ServerLogic {
    private static final Vec3 NORMAL_UP = new Vec3(0.0, 1.0, 0.0);

    public static void applyTakeOffImpulse(Player player) {
        Vec3 verticalThrust = NORMAL_UP.m_82490_(1.0).m_82490_(ServerLogic.getCeilingFactor(player));
        player.m_36320_();
        player.m_20256_(player.m_20184_().m_82549_(verticalThrust));
        player.m_5496_(Sounds.FLAP, (float)ClientConfig.takeOffVolume, 2.0f);
    }

    public static void applyFlapImpulse(Player player) {
        double ceilingFactor = ServerLogic.getCeilingFactor(player);
        Vec3 verticalThrust = NORMAL_UP.m_82490_(0.65).m_82490_(ceilingFactor);
        Vec3 forwardThrust = player.m_20184_().m_82541_().m_82490_(0.1625).m_82490_(ceilingFactor);
        player.m_20256_(player.m_20184_().m_82549_(forwardThrust).m_82549_(verticalThrust));
        player.m_5496_(Sounds.FLAP, (float)ClientConfig.flapVolume, 2.0f);
    }

    public static void applyFlareImpulse(Player player) {
        Vec3 dragDirection = player.m_20184_().m_82541_().m_82548_();
        double velocitySquared = player.m_20184_().m_82556_();
        Vec3 dragThrust = dragDirection.m_82490_(velocitySquared * 0.05);
        player.m_20256_(player.m_20184_().m_82549_(dragThrust));
    }

    public static void applyElytraRechargeFoodCost(Player player) {
        player.m_36399_((float)ServerConfig.exhaustionPerChargePoint);
    }

    public static double getCeilingFactor(Player player) {
        double altitude = player.m_20186_();
        if (altitude < (double)ServerConfig.softCeiling) {
            return 1.0;
        }
        if (altitude > (double)ServerConfig.hardCeiling) {
            return 0.0;
        }
        return (altitude - (double)ServerConfig.softCeiling) / (double)ServerConfig.ceilingRange;
    }

    public static void handleCFlightActionPacket(CFlightActionPacket message, Supplier<NetworkEvent.Context> context) {
        switch (message.getUpdateType()) {
            case TAKEOFF: {
                ServerLogic.applyTakeOffImpulse((Player)context.get().getSender());
                break;
            }
            case FLAP: {
                ServerLogic.applyFlapImpulse((Player)context.get().getSender());
                break;
            }
            case FLARE: {
                ServerLogic.applyFlareImpulse((Player)context.get().getSender());
                break;
            }
            case RECHARGE: {
                ServerLogic.applyElytraRechargeFoodCost((Player)context.get().getSender());
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        SElytraChargePacket.send(event.getPlayer(), ServerConfig.maxCharge);
    }

    @SubscribeEvent
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        SElytraChargePacket.send(event.getPlayer(), ServerConfig.maxCharge);
    }

    @SubscribeEvent
    public static void onPlayerChangeGameMode(PlayerEvent.PlayerChangeGameModeEvent event) {
        SElytraChargePacket.send(event.getPlayer(), ServerConfig.maxCharge);
    }
}

