/*
 * Decompiled with CFR 0.152.
 */
package com.rejahtavi.betterflight.common;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;

public class ServerConfig {
    public static final Server SERVER;
    public static final ForgeConfigSpec SERVER_SPEC;
    public static final double TAKE_OFF_SPEED = 0.17;
    public static final double TAKE_OFF_THRUST = 1.0;
    public static final double FLAP_THRUST = 0.65;
    public static final double FLARE_DRAG = 0.05;
    public static final int TAKE_OFF_JUMP_DELAY = 4;
    public static int maxCharge;
    public static int takeOffCost;
    public static int flapCost;
    public static int rechargeTicksInAir;
    public static int rechargeTicksOnGround;
    public static int flareTicksPerChargePoint;
    public static double exhaustionPerChargePoint;
    public static int minFood;
    public static int cooldownTicks;
    public static int softCeiling;
    public static int hardCeiling;
    public static int ceilingRange;
    public static List<Item> elytraItems;

    public static void bake() {
        maxCharge = (Integer)ServerConfig.SERVER.maxCharge.get();
        takeOffCost = (Integer)ServerConfig.SERVER.takeOffCost.get();
        flapCost = (Integer)ServerConfig.SERVER.flapCost.get();
        rechargeTicksInAir = (Integer)ServerConfig.SERVER.rechargeTicksInAir.get();
        rechargeTicksOnGround = (Integer)ServerConfig.SERVER.rechargeTicksOnGround.get();
        flareTicksPerChargePoint = (Integer)ServerConfig.SERVER.flareTicksPerChargePoint.get();
        exhaustionPerChargePoint = (Double)ServerConfig.SERVER.exhaustionPerChargePoint.get();
        minFood = (Integer)ServerConfig.SERVER.minFood.get();
        cooldownTicks = (Integer)ServerConfig.SERVER.cooldownTicks.get();
        softCeiling = (Integer)ServerConfig.SERVER.softCeiling.get();
        hardCeiling = (Integer)ServerConfig.SERVER.hardCeiling.get();
        elytraItems = new ArrayList<Item>();
        for (String id : (List)ServerConfig.SERVER.elytraItems.get()) {
            Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(id));
            if (item == null || item == Items.f_41852_) continue;
            elytraItems.add(item);
        }
        if (softCeiling > hardCeiling) {
            softCeiling = hardCeiling;
            ServerConfig.SERVER.softCeiling.set((Object)hardCeiling);
        }
        ceilingRange = hardCeiling - softCeiling;
    }

    static {
        Pair serverSpecPair = new ForgeConfigSpec.Builder().configure(Server::new);
        SERVER = (Server)serverSpecPair.getLeft();
        SERVER_SPEC = (ForgeConfigSpec)serverSpecPair.getRight();
    }

    public static class Server {
        public final ForgeConfigSpec.IntValue maxCharge;
        public final ForgeConfigSpec.IntValue takeOffCost;
        public final ForgeConfigSpec.IntValue flapCost;
        public final ForgeConfigSpec.IntValue rechargeTicksInAir;
        public final ForgeConfigSpec.IntValue rechargeTicksOnGround;
        public final ForgeConfigSpec.IntValue flareTicksPerChargePoint;
        public final ForgeConfigSpec.DoubleValue exhaustionPerChargePoint;
        public final ForgeConfigSpec.IntValue minFood;
        public final ForgeConfigSpec.IntValue cooldownTicks;
        public final ForgeConfigSpec.IntValue softCeiling;
        public final ForgeConfigSpec.IntValue hardCeiling;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> elytraItems;

        public Server(ForgeConfigSpec.Builder builder) {
            builder.push("betterflight");
            this.maxCharge = builder.comment("Maximum points of charge in a 'full' elytra meter.").defineInRange("MaxCharge", 15, 3, 255);
            this.takeOffCost = builder.comment("Meter point cost to take off.").defineInRange("TakeOffCost", 3, 0, 255);
            this.flapCost = builder.comment("Meter point cost to flap wings.").defineInRange("FlapCost", 1, 0, 255);
            this.rechargeTicksInAir = builder.comment("Time, in ticks, it takes to recharge 1 point on the meter while in the air.").defineInRange("RechargeTicksInAir", 100, 5, 600);
            this.rechargeTicksOnGround = builder.comment("Time, in ticks, it takes to recharge 1 point on the meter while on the ground.").defineInRange("RechargeTicksOnGround", 20, 5, 600);
            this.flareTicksPerChargePoint = builder.comment("Time, in ticks, players can flare per point on the meter.").defineInRange("FlareTicksPerChargePoint", 20, 5, 600);
            this.exhaustionPerChargePoint = builder.comment("How much food it costs to recharge a point on the meter.").defineInRange("ExhaustionPerChargePoint", 4.0, 0.0, 20.0);
            this.minFood = builder.comment("Minimum food required on hunger bar to recharge elytra meter. (6 = same as sprint)").defineInRange("MinFood", 6, 0, 20);
            this.cooldownTicks = builder.comment("Time, in ticks, players must wait between wing flaps.").defineInRange("CooldownTicks", 20, 5, 200);
            this.softCeiling = builder.comment("Height above which flapping begins to be less effective. (Must be less than hardCeiling).").defineInRange("softCeiling", 320, 0, 10000);
            this.hardCeiling = builder.comment("Height above which flapping no longer provides any thrust.").defineInRange("hardCeiling", 400, 0, 10000);
            this.elytraItems = builder.comment("A list of modid:itemname registry keys that count as an Elytra.").defineList("elytraItems", new ArrayList<String>(Arrays.asList("minecraft:elytra", "mekanism:hdpe_elytra", "alexsmobs:tarantula_hawk_elytra", "tconstruct:slime_chestplate", "customizableelytra:customizable_elytra")), s -> s instanceof String);
            builder.pop();
        }
    }
}

