/*
 * Decompiled with CFR 0.152.
 */
package com.rejahtavi.betterflight.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.rejahtavi.betterflight.client.ClientConfig;
import com.rejahtavi.betterflight.client.ClientLogic;
import com.rejahtavi.betterflight.common.ServerConfig;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.gui.ForgeIngameGui;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class HUDOverlay {
    private static final int OFFSET_FROM_CURSOR = 24;
    private static final int OFFSET_TO_HOTBAR_SIDES = 105;
    private static final int OFFSET_ABOVE_HOTBAR = 44;
    private static final int TEXTURE_SIZE = 128;
    private static final int ICON_SIZE = 16;
    private static final int HALF_ICON_SIZE = 8;
    private static final int SPRITE_DURABILITY_FULL = 0;
    private static final int SPRITE_DURABILITY_HALF = 16;
    private static final int SPRITE_DURABILITY_QUARTER = 32;
    private static final int SPRITE_DURABILITY_LOW = 48;
    private static final int SPRITE_BORDER_BLACK = 0;
    private static final int SPRITE_BORDER_RECHARGE = 16;
    private static final int SPRITE_BORDER_DEPLETION = 32;
    private static final int SPRITE_BORDER_FLARE = 48;
    private static final int SPRITE_METER_EMPTY = 64;
    private static final int SPRITE_METER_FULL = 80;
    private static final int SPRITE_ALARM = 96;
    public static Random random = new Random(System.currentTimeMillis());
    public static final ResourceLocation elytraIcons = new ResourceLocation("betterflight", "textures/elytraicons.png");

    @SubscribeEvent
    public static void onRenderOverlay(RenderGameOverlayEvent.Post event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.ALL) {
            HUDOverlay.renderOverlay(event.getMatrixStack());
        }
    }

    public static void renderOverlay(PoseStack stack) {
        if (!ClientLogic.isElytraEquipped) {
            return;
        }
        if (ClientLogic.elytraDurabilityLeft <= 1) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc == null) {
            return;
        }
        int shakeX = 0;
        int shakeY = 0;
        int scaleWidth = mc.m_91268_().m_85445_();
        int scaleHeight = mc.m_91268_().m_85446_();
        int widgetPosX = 0;
        int widgetPosY = 0;
        switch (ClientConfig.hudLocation) {
            case CURSOR_BELOW: {
                widgetPosX = scaleWidth / 2 - 8;
                widgetPosY = scaleHeight / 2 + 24 - 8;
                break;
            }
            case CURSOR_LEFT: {
                widgetPosX = scaleWidth / 2 - 24 - 8;
                widgetPosY = scaleHeight / 2 - 8;
                break;
            }
            case CURSOR_RIGHT: {
                widgetPosX = scaleWidth / 2 + 24 - 8;
                widgetPosY = scaleHeight / 2 - 8;
                break;
            }
            case CURSOR_ABOVE: {
                widgetPosX = scaleWidth / 2 - 8;
                widgetPosY = scaleHeight / 2 - 24 - 8;
                break;
            }
            case BAR_LEFT: {
                widgetPosX = scaleWidth / 2 - 105 - 8;
                widgetPosY = scaleHeight - 12 - 8;
                break;
            }
            case BAR_RIGHT: {
                widgetPosX = scaleWidth / 2 + 105 - 8;
                widgetPosY = scaleHeight - 12 - 8;
                break;
            }
            default: {
                widgetPosX = scaleWidth / 2 - 8;
                widgetPosY = scaleHeight - 44 - 8;
            }
        }
        int durabilityOffset = 0;
        if (ClientLogic.elytraDurability > 0.5) {
            durabilityOffset = 16;
        }
        if (ClientLogic.elytraDurability > 0.75) {
            durabilityOffset = 32;
        }
        if (ClientLogic.elytraDurability > (double)0.9f) {
            durabilityOffset = 48;
        }
        int borderOffset = 0;
        if (ClientLogic.elytraDurability > 0.95) {
            if (mc.f_91073_ != null) {
                long thisTick = mc.f_91073_.m_46467_();
                borderOffset = (int)(thisTick / 5L % 2L * 16L) + 96;
                if (thisTick / 3L % 2L > 0L) {
                    shakeX = random.nextInt(3) - 1;
                } else {
                    shakeY = random.nextInt(3) - 1;
                }
            }
        } else if (ClientLogic.isFlaring) {
            borderOffset = 48;
        } else if (ClientLogic.depletionBorderTimer > 0) {
            borderOffset = 32;
        } else if (ClientLogic.rechargeBorderTimer > 0) {
            borderOffset = 16;
        }
        int drainedPixels = (int)Math.floor((1.0f - (float)ClientLogic.charge / (float)ServerConfig.maxCharge) * 16.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)elytraIcons);
        ForgeIngameGui.m_93133_((PoseStack)stack, (int)(widgetPosX + shakeX), (int)(widgetPosY + shakeY), (float)80.0f, (float)durabilityOffset, (int)16, (int)16, (int)128, (int)128);
        ForgeIngameGui.m_93133_((PoseStack)stack, (int)(widgetPosX + shakeX), (int)(widgetPosY + shakeY), (float)64.0f, (float)durabilityOffset, (int)16, (int)drainedPixels, (int)128, (int)128);
        ForgeIngameGui.m_93133_((PoseStack)stack, (int)(widgetPosX + shakeX), (int)(widgetPosY + shakeY), (float)borderOffset, (float)durabilityOffset, (int)16, (int)16, (int)128, (int)128);
        RenderSystem.m_157456_((int)0, (ResourceLocation)Gui.f_93098_);
    }
}

