/*
 * Decompiled with CFR 0.152.
 */
package com.rejahtavi.betterflight.client;

import com.mojang.blaze3d.platform.InputConstants;
import com.rejahtavi.betterflight.BetterFlight;
import com.rejahtavi.betterflight.client.ClientConfig;
import com.rejahtavi.betterflight.common.FlightActionType;
import com.rejahtavi.betterflight.common.ServerConfig;
import com.rejahtavi.betterflight.common.ServerLogic;
import com.rejahtavi.betterflight.common.Sounds;
import com.rejahtavi.betterflight.network.CFlightActionPacket;
import com.rejahtavi.betterflight.network.SElytraChargePacket;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.ClientRegistry;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.client.settings.KeyModifier;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import top.theillusivec4.curios.api.CuriosApi;

@Mod.EventBusSubscriber(modid="betterflight", value={Dist.CLIENT})
public class ClientLogic {
    public static KeyMapping takeOffKey;
    public static KeyMapping flapKey;
    public static KeyMapping flareKey;
    public static KeyMapping widgetPosKey;
    public static boolean isElytraEquipped;
    public static boolean isFlaring;
    public static int charge;
    public static double elytraDurability;
    public static int elytraDurabilityLeft;
    public static int rechargeTickCounter;
    public static int flareTickCounter;
    public static int offGroundTickCounter;
    public static int cooldownTimer;
    public static int rechargeBorderTimer;
    public static int depletionBorderTimer;

    public static void init() {
        takeOffKey = new KeyMapping("betterflight.keys.takeoff", (IKeyConflictContext)KeyConflictContext.IN_GAME, KeyModifier.NONE, InputConstants.Type.KEYSYM.m_84895_(32), "betterflight");
        ClientRegistry.registerKeyBinding((KeyMapping)takeOffKey);
        flapKey = new KeyMapping("betterflight.keys.flap", (IKeyConflictContext)KeyConflictContext.IN_GAME, KeyModifier.NONE, InputConstants.Type.KEYSYM.m_84895_(32), "betterflight");
        ClientRegistry.registerKeyBinding((KeyMapping)flapKey);
        flareKey = new KeyMapping("betterflight.keys.flare", (IKeyConflictContext)KeyConflictContext.IN_GAME, KeyModifier.NONE, InputConstants.Type.KEYSYM.m_84895_(88), "betterflight");
        ClientRegistry.registerKeyBinding((KeyMapping)flareKey);
        widgetPosKey = new KeyMapping("betterflight.keys.widget", (IKeyConflictContext)KeyConflictContext.IN_GAME, KeyModifier.NONE, InputConstants.Type.KEYSYM.m_84895_(299), "betterflight");
        ClientRegistry.registerKeyBinding((KeyMapping)widgetPosKey);
        charge = ServerConfig.maxCharge;
    }

    @SubscribeEvent
    public static void onKeyInput(InputEvent.KeyInputEvent event) {
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player == null) {
            return;
        }
        if (mc.f_91080_ != null) {
            return;
        }
        if (event.getKey() == takeOffKey.getKey().m_84873_() && event.getAction() == 1) {
            ClientLogic.tryTakeOff(player);
        }
        if (event.getKey() == flapKey.getKey().m_84873_() && event.getAction() == 1) {
            ClientLogic.tryFlap(player);
        }
        if (event.getKey() == widgetPosKey.getKey().m_84873_() && event.getAction() == 1) {
            ClientLogic.cycleWidgetLocation();
        }
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player == null) {
            return;
        }
        offGroundTickCounter = player.m_20096_() ? 0 : ++offGroundTickCounter;
        if (depletionBorderTimer > 0) {
            --depletionBorderTimer;
        }
        if (rechargeBorderTimer > 0) {
            --rechargeBorderTimer;
        }
        if (cooldownTimer > 0) {
            --cooldownTimer;
        }
        ClientLogic.updateElytraStatus(player);
        ClientLogic.handleRecharge(player);
        ClientLogic.handleFlare(player);
    }

    private static void tryTakeOff(LocalPlayer player) {
        if (isElytraEquipped && offGroundTickCounter > 4 && player.m_20142_() && !player.m_21255_() && player.m_20184_().m_82553_() > 0.17 && ClientLogic.spendCharge(player, ServerConfig.takeOffCost)) {
            CFlightActionPacket.send(FlightActionType.TAKEOFF);
            ServerLogic.applyTakeOffImpulse((Player)player);
            player.m_5496_(Sounds.FLAP, (float)ClientConfig.takeOffVolume, 2.0f);
        }
    }

    private static void tryFlap(LocalPlayer player) {
        if (isElytraEquipped && cooldownTimer <= 0 && !player.m_20096_() && player.m_21255_() && ClientLogic.spendCharge(player, ServerConfig.flapCost)) {
            CFlightActionPacket.send(FlightActionType.FLAP);
            ServerLogic.applyFlapImpulse((Player)player);
            player.m_5496_(Sounds.FLAP, (float)ClientConfig.flapVolume, 2.0f);
        }
    }

    private static void handleRecharge(LocalPlayer player) {
        int threshold;
        if (player.m_7500_()) {
            charge = ServerConfig.maxCharge;
            return;
        }
        int n = threshold = player.m_20096_() ? ServerConfig.rechargeTicksOnGround : ServerConfig.rechargeTicksInAir;
        if (rechargeTickCounter < threshold) {
            ++rechargeTickCounter;
        }
        if (!isFlaring && rechargeTickCounter >= threshold && charge < ServerConfig.maxCharge && player.m_36324_().m_38702_() > ServerConfig.minFood) {
            ++charge;
            rechargeTickCounter = 0;
            rechargeBorderTimer = 5;
            CFlightActionPacket.send(FlightActionType.RECHARGE);
            player.m_36399_((float)ServerConfig.exhaustionPerChargePoint);
        }
    }

    private static void handleFlare(LocalPlayer player) {
        if (isElytraEquipped && flareKey.m_90857_() && (player.m_7500_() || charge > 0) && !player.m_20096_() && player.m_21255_()) {
            CFlightActionPacket.send(FlightActionType.FLARE);
            ServerLogic.applyFlareImpulse((Player)player);
            isFlaring = true;
            if (++flareTickCounter >= ServerConfig.flareTicksPerChargePoint) {
                ClientLogic.spendCharge(player, 1);
                flareTickCounter = 0;
            }
        } else {
            if (flareTickCounter > 0) {
                --flareTickCounter;
            }
            isFlaring = false;
        }
    }

    private static boolean spendCharge(LocalPlayer player, int points) {
        if (player.m_7500_()) {
            return true;
        }
        if (charge >= points) {
            charge -= points;
            rechargeTickCounter = 0;
            cooldownTimer = ServerConfig.cooldownTicks;
            depletionBorderTimer = 5;
            return true;
        }
        return false;
    }

    private static void updateElytraStatus(LocalPlayer player) {
        isElytraEquipped = false;
        elytraDurability = 0.0;
        elytraDurabilityLeft = 0;
        ItemStack elytraStack = player.m_6844_(EquipmentSlot.CHEST);
        if (ServerConfig.elytraItems.contains(elytraStack.m_41720_())) {
            isElytraEquipped = true;
        }
        if (BetterFlight.isCuriousElytraLoaded) {
            for (Item elytraItem : ServerConfig.elytraItems) {
                if (!CuriosApi.getCuriosHelper().findEquippedCurio(elytraItem, (LivingEntity)player).isPresent()) continue;
                isElytraEquipped = true;
                elytraStack = (ItemStack)((ImmutableTriple)CuriosApi.getCuriosHelper().findEquippedCurio(elytraItem, (LivingEntity)player).get()).getRight();
            }
        }
        if (isElytraEquipped) {
            elytraDurabilityLeft = elytraStack.m_41776_() - elytraStack.m_41773_();
            if (elytraDurabilityLeft > 1) {
                elytraDurability = (float)elytraStack.m_41720_().getDamage(elytraStack) / (float)elytraStack.m_41776_();
            } else {
                isElytraEquipped = false;
            }
        }
    }

    private static void cycleWidgetLocation() {
        switch (ClientConfig.hudLocation) {
            case BAR_CENTER: {
                ClientConfig.hudLocation = ClientConfig.HudLocation.BAR_LEFT;
                break;
            }
            case BAR_LEFT: {
                ClientConfig.hudLocation = ClientConfig.HudLocation.BAR_RIGHT;
                break;
            }
            case BAR_RIGHT: {
                ClientConfig.hudLocation = ClientConfig.HudLocation.CURSOR_ABOVE;
                break;
            }
            case CURSOR_ABOVE: {
                ClientConfig.hudLocation = ClientConfig.HudLocation.CURSOR_RIGHT;
                break;
            }
            case CURSOR_RIGHT: {
                ClientConfig.hudLocation = ClientConfig.HudLocation.CURSOR_BELOW;
                break;
            }
            case CURSOR_BELOW: {
                ClientConfig.hudLocation = ClientConfig.HudLocation.CURSOR_LEFT;
                break;
            }
            case CURSOR_LEFT: {
                ClientConfig.hudLocation = ClientConfig.HudLocation.BAR_CENTER;
            }
        }
        ClientConfig.CLIENT.hudLocation.set((Object)ClientConfig.hudLocation);
        ClientConfig.CLIENT.hudLocation.save();
    }

    public static void handleSElytraChargePacket(SElytraChargePacket message) {
        charge = message.getCharge();
    }

    static {
        isElytraEquipped = false;
        isFlaring = false;
        charge = ServerConfig.maxCharge;
        elytraDurability = 0.5;
        elytraDurabilityLeft = 1;
        rechargeTickCounter = 0;
        flareTickCounter = 0;
        offGroundTickCounter = 0;
        cooldownTimer = 0;
        rechargeBorderTimer = 0;
        depletionBorderTimer = 0;
    }
}

