/*
 * Decompiled with CFR 0.152.
 */
package com.rejahtavi.betterflight.client;

import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class ClientConfig {
    public static final Client CLIENT;
    public static final ForgeConfigSpec CLIENT_SPEC;
    public static final int BORDER_FLASH_TICKS = 5;
    public static final float FLAP_SOUND_PITCH = 2.0f;
    public static HudLocation hudLocation;
    public static double takeOffVolume;
    public static double flapVolume;

    public static void bake() {
        takeOffVolume = (Double)ClientConfig.CLIENT.takeOffVolume.get();
        flapVolume = (Double)ClientConfig.CLIENT.flapVolume.get();
        hudLocation = (HudLocation)((Object)ClientConfig.CLIENT.hudLocation.get());
    }

    static {
        hudLocation = HudLocation.BAR_CENTER;
        Pair clientSpecPair = new ForgeConfigSpec.Builder().configure(Client::new);
        CLIENT = (Client)clientSpecPair.getLeft();
        CLIENT_SPEC = (ForgeConfigSpec)clientSpecPair.getRight();
    }

    public static class Client {
        public final ForgeConfigSpec.DoubleValue takeOffVolume;
        public final ForgeConfigSpec.DoubleValue flapVolume;
        public final ForgeConfigSpec.EnumValue<HudLocation> hudLocation;

        public Client(ForgeConfigSpec.Builder builder) {
            builder.push("betterflight");
            this.takeOffVolume = builder.comment("Loudness of the flap sound on takeoff.").defineInRange("TakeOffVolume", 1.0, 0.0, 1.0);
            this.flapVolume = builder.comment("Loudness of the flap sound when flapping wings.").defineInRange("FlapVolume", 0.5, 0.0, 1.0);
            this.hudLocation = builder.comment("Stores preferred position of elytra widget on HUD.\nOptions: BAR_CENTER, BAR_LEFT, BAR_RIGHT,\nCURSOR_BELOW, CURSOR_ABOVE, CURSOR_RIGHT, CURSOR_LEFT.").defineEnum("HudLocation", (Enum)HudLocation.BAR_CENTER);
            builder.pop();
        }
    }

    public static enum HudLocation {
        BAR_CENTER,
        BAR_LEFT,
        BAR_RIGHT,
        CURSOR_ABOVE,
        CURSOR_RIGHT,
        CURSOR_BELOW,
        CURSOR_LEFT;

    }
}

