/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.unit.token;

import dev.latvian.mods.unit.FixedColorUnit;
import dev.latvian.mods.unit.Unit;
import dev.latvian.mods.unit.UnitContext;
import dev.latvian.mods.unit.operator.GroupUnit;
import dev.latvian.mods.unit.token.CharStream;
import dev.latvian.mods.unit.token.FunctionUnitToken;
import dev.latvian.mods.unit.token.PostfixUnitToken;
import dev.latvian.mods.unit.token.StringUnitToken;
import dev.latvian.mods.unit.token.TernaryUnitToken;
import dev.latvian.mods.unit.token.UnaryOpUnitToken;
import dev.latvian.mods.unit.token.UnitInterpretException;
import dev.latvian.mods.unit.token.UnitParseException;
import dev.latvian.mods.unit.token.UnitSymbol;
import dev.latvian.mods.unit.token.UnitToken;
import java.util.ArrayList;

public final class UnitTokenStream {
    public final UnitContext context;
    public final String input;
    public final CharStream charStream;
    public final ArrayList<UnitToken> infix;
    public final ArrayList<Integer> inputStringPos;
    private int infixPos;
    public final Unit unit;

    private static boolean isHex(char c) {
        return c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F';
    }

    public UnitTokenStream(UnitContext context, String input) {
        char c;
        this.context = context;
        this.input = input;
        this.charStream = new CharStream(input.toCharArray());
        this.infix = new ArrayList();
        this.inputStringPos = new ArrayList();
        this.infixPos = -1;
        StringBuilder current = new StringBuilder();
        while ((c = this.charStream.next()) != '\u0000') {
            UnitSymbol unary;
            int cpos = this.charStream.position;
            UnitSymbol symbol = UnitSymbol.read(c, this.charStream);
            if (symbol == UnitSymbol.HASH) {
                if (UnitTokenStream.isHex(this.charStream.peek(1)) && UnitTokenStream.isHex(this.charStream.peek(2)) && UnitTokenStream.isHex(this.charStream.peek(3)) && UnitTokenStream.isHex(this.charStream.peek(4)) && UnitTokenStream.isHex(this.charStream.peek(5)) && UnitTokenStream.isHex(this.charStream.peek(6))) {
                    boolean alpha = UnitTokenStream.isHex(this.charStream.peek(7)) && UnitTokenStream.isHex(this.charStream.peek(8));
                    current.append('#');
                    for (int i = 0; i < (alpha ? 8 : 6); ++i) {
                        current.append(this.charStream.next());
                    }
                    int color = Long.decode(current.toString()).intValue();
                    current.setLength(0);
                    this.inputStringPos.add(cpos);
                    this.infix.add(FixedColorUnit.of(color, alpha));
                    continue;
                }
                throw new UnitParseException("Invalid color code @ " + this.charStream.position);
            }
            if (symbol != null && current.length() > 0) {
                this.inputStringPos.add(cpos);
                this.infix.add(new StringUnitToken(current.toString()));
                current.setLength(0);
            }
            UnitSymbol unitSymbol = unary = symbol == null ? null : symbol.getUnarySymbol();
            if (unary != null && (this.infix.isEmpty() || this.infix.get(this.infix.size() - 1).nextUnaryOperator())) {
                this.inputStringPos.add(cpos);
                this.infix.add(unary);
                continue;
            }
            if (symbol != null) {
                this.inputStringPos.add(cpos);
                this.infix.add(symbol);
                continue;
            }
            current.append(c);
        }
        if (current.length() > 0) {
            this.inputStringPos.add(this.charStream.position - current.length());
            this.infix.add(new StringUnitToken(current.toString()));
            current.setLength(0);
        }
        ArrayList<Unit> interpretedUnits = new ArrayList<Unit>();
        if (context.isDebug()) {
            context.debugInfo("Infix", this.infix);
        }
        try {
            do {
                UnitToken unitToken = this.readFully();
                interpretedUnits.add(unitToken.interpret(this));
            } while (this.ifNextToken(UnitSymbol.SEMICOLON));
        }
        catch (UnitInterpretException ex) {
            throw new RuntimeException("Error parsing '" + input + "' @ " + (this.infixPos < 0 || this.infixPos >= this.inputStringPos.size() ? -1 : this.inputStringPos.get(this.infixPos)), ex);
        }
        this.unit = interpretedUnits.size() == 1 ? (Unit)interpretedUnits.get(0) : new GroupUnit(interpretedUnits.toArray(Unit.EMPTY_ARRAY));
    }

    public Unit getUnit() {
        return this.unit;
    }

    public String toString() {
        return this.infix.toString();
    }

    public UnitToken nextToken() {
        if (++this.infixPos >= this.infix.size()) {
            throw new UnitInterpretException("EOL!");
        }
        return this.infix.get(this.infixPos);
    }

    public UnitToken peekToken() {
        if (this.infixPos + 1 >= this.infix.size()) {
            return null;
        }
        return this.infix.get(this.infixPos + 1);
    }

    public boolean ifNextToken(UnitToken token) {
        if (token.equals(this.peekToken())) {
            this.nextToken();
            return true;
        }
        return false;
    }

    public UnitToken readFully() {
        UnitToken unitToken;
        PostfixUnitToken postfix = new PostfixUnitToken(new ArrayList<UnitToken>());
        if (this.ifNextToken(UnitSymbol.LP)) {
            postfix.infix().add(this.readFully());
            if (!this.ifNextToken(UnitSymbol.RP)) {
                throw new UnitInterpretException("Expected ')', got '" + this.peekToken() + "'!");
            }
        } else {
            postfix.infix().add(this.readSingleToken());
        }
        while ((unitToken = this.peekToken()) instanceof UnitSymbol) {
            UnitSymbol symbol = (UnitSymbol)unitToken;
            if (symbol.op == null) break;
            postfix.infix().add(this.nextToken());
            if (this.peekToken() == UnitSymbol.LP) {
                postfix.infix().add(this.readFully());
                continue;
            }
            postfix.infix().add(this.readSingleToken());
        }
        if (this.ifNextToken(UnitSymbol.HOOK)) {
            UnitToken left = this.readFully();
            if (!this.ifNextToken(UnitSymbol.COLON)) {
                throw new UnitInterpretException("Expected ':', got '" + this.peekToken() + "'!");
            }
            UnitToken right = this.readFully();
            return new TernaryUnitToken(postfix.normalize(), left, right);
        }
        return postfix.normalize();
    }

    public UnitToken readSingleToken() {
        UnitToken token = this.nextToken();
        if (token instanceof UnitSymbol) {
            UnitSymbol symbol = (UnitSymbol)token;
            if (symbol.unaryOp != null) {
                if (this.peekToken() == UnitSymbol.LP) {
                    return new UnaryOpUnitToken(symbol, this.readFully());
                }
                return new UnaryOpUnitToken(symbol, this.readSingleToken());
            }
        }
        if (token instanceof StringUnitToken) {
            StringUnitToken str = (StringUnitToken)token;
            if (this.ifNextToken(UnitSymbol.LP)) {
                FunctionUnitToken func = new FunctionUnitToken(str.name(), new ArrayList<UnitToken>());
                while (!this.ifNextToken(UnitSymbol.RP)) {
                    if (this.ifNextToken(UnitSymbol.COMMA)) continue;
                    func.args().add(this.readFully());
                }
                return func;
            }
            return str;
        }
        if (token instanceof FixedColorUnit) {
            return token;
        }
        throw new UnitInterpretException("Unexpected token: " + token);
    }
}

