/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.rhino.typedarrays;

import dev.latvian.mods.rhino.Context;
import dev.latvian.mods.rhino.IdScriptableObject;
import dev.latvian.mods.rhino.ScriptRuntime;
import dev.latvian.mods.rhino.Undefined;
import dev.latvian.mods.rhino.typedarrays.NativeArrayBuffer;

public abstract class NativeArrayBufferView
extends IdScriptableObject {
    private static final long serialVersionUID = 6884475582973958419L;
    private static Boolean useLittleEndian = null;
    protected final NativeArrayBuffer arrayBuffer;
    protected final int offset;
    protected final int byteLength;
    private static final int Id_buffer = 1;
    private static final int Id_byteOffset = 2;
    private static final int Id_byteLength = 3;
    protected static final int MAX_INSTANCE_ID = 3;

    public NativeArrayBufferView() {
        this.arrayBuffer = new NativeArrayBuffer();
        this.offset = 0;
        this.byteLength = 0;
    }

    protected NativeArrayBufferView(NativeArrayBuffer ab, int offset, int byteLength) {
        this.offset = offset;
        this.byteLength = byteLength;
        this.arrayBuffer = ab;
    }

    public NativeArrayBuffer getBuffer() {
        return this.arrayBuffer;
    }

    public int getByteOffset() {
        return this.offset;
    }

    public int getByteLength() {
        return this.byteLength;
    }

    protected static boolean useLittleEndian() {
        if (useLittleEndian == null) {
            Context ctx = Context.getCurrentContext();
            if (ctx == null) {
                return false;
            }
            useLittleEndian = ctx.hasFeature(19);
        }
        return useLittleEndian;
    }

    protected static boolean isArg(Object[] args, int i) {
        return args.length > i && !Undefined.instance.equals(args[i]);
    }

    @Override
    protected int getMaxInstanceId() {
        return 3;
    }

    @Override
    protected String getInstanceIdName(int id) {
        return switch (id) {
            case 1 -> "buffer";
            case 2 -> "byteOffset";
            case 3 -> "byteLength";
            default -> super.getInstanceIdName(id);
        };
    }

    @Override
    protected Object getInstanceIdValue(int id) {
        return switch (id) {
            case 1 -> this.arrayBuffer;
            case 2 -> ScriptRuntime.wrapInt(this.offset);
            case 3 -> ScriptRuntime.wrapInt(this.byteLength);
            default -> super.getInstanceIdValue(id);
        };
    }

    @Override
    protected int findInstanceIdInfo(String s) {
        int id;
        switch (s) {
            case "buffer": {
                int n = 1;
                break;
            }
            case "byteOffset": {
                int n = 2;
                break;
            }
            case "byteLength": {
                int n = 3;
                break;
            }
            default: {
                int n = id = 0;
            }
        }
        if (id == 0) {
            return super.findInstanceIdInfo(s);
        }
        return NativeArrayBufferView.instanceIdInfo(5, id);
    }
}

