/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.rhino.mod.util.forge;

import dev.latvian.mods.rhino.mod.util.MinecraftRemapper;
import dev.latvian.mods.rhino.mod.util.RhinoProperties;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.Util;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.commons.io.IOUtils;

public class ForgeRemapper
extends MinecraftRemapper {
    @Override
    public String getModLoader() {
        return "forge";
    }

    @Override
    public boolean isServer() {
        return FMLLoader.getDist().isDedicatedServer();
    }

    @Override
    public String getRuntimeMappings() {
        return FMLLoader.isProduction() ? "srg" : "dev";
    }

    @Override
    public void init(MinecraftRemapper.MinecraftClasses minecraftClasses) throws Exception {
        String[] srg;
        MinecraftRemapper.RemappedClass current = null;
        MinecraftRemapper.RemappedClass mmCurrent = null;
        URL url = new URL(RhinoProperties.INSTANCE.srgRemoteUrl.replace("$version", this.getMcVersion()));
        try {
            srg = IOUtils.toString((InputStream)((URLConnection)Util.m_137469_((Object)url.openConnection(), conn -> {
                conn.setConnectTimeout(5000);
                conn.setReadTimeout(10000);
            })).getInputStream(), (Charset)StandardCharsets.UTF_8).split("\n");
        }
        catch (Exception e) {
            if (e instanceof InterruptedIOException) {
                LOGGER.error("Timeout while downloading SRG mappings from {}!", (Object)url);
            } else {
                LOGGER.error("Failed to download SRG mappings from {}!", (Object)url);
            }
            LOGGER.error("If the site is blocked in your country, try setting an alternative mirror in rhino.local.properties");
            LOGGER.error("We will proceed without remapping here, so you will have to use obfuscated names for internal Minecraft classes!");
            LOGGER.error("As a workaround, you can try out the fix outlined here: https://github.com/KubeJS-Mods/Rhino/issues/26#issuecomment-1187123192");
            throw e;
        }
        Pattern pattern = Pattern.compile("[\t ]");
        Pattern argPattern = Pattern.compile("L([\\w/$]+);");
        for (int i = 1; i < srg.length; ++i) {
            String m;
            String[] s = pattern.split(srg[i]);
            if (s.length < 3 || s[1].isEmpty()) continue;
            if (!s[0].isEmpty()) {
                mmCurrent = minecraftClasses.rawLookup().get(s[0]);
                if (mmCurrent == null) continue;
                current = new MinecraftRemapper.RemappedClass(mmCurrent.mappedName, mmCurrent.mappedName);
                this.classMap.put(mmCurrent.mappedName, current);
                continue;
            }
            if (current == null || mmCurrent == null) continue;
            if (s.length == 5) {
                String a;
                String m2;
                if (s[1].equals("<init>") || s[1].equals("<clinit>") || (m2 = mmCurrent.getChild(s[1] + (a = s[2].substring(0, s[2].lastIndexOf(41) + 1)))).isEmpty()) continue;
                if (current.children == null) {
                    current.children = new HashMap<String, String>();
                }
                StringBuilder sb = new StringBuilder(s[3]);
                Matcher matcher = argPattern.matcher(a);
                while (matcher.find()) {
                    String g = matcher.group(1);
                    MinecraftRemapper.RemappedClass c = minecraftClasses.rawLookup().get(g);
                    matcher.appendReplacement(sb, "L" + (c == null ? g : c.mappedName.replace('.', '/')).replace("$", "\\$") + ";");
                }
                matcher.appendTail(sb);
                current.children.put(sb.toString(), m2);
                continue;
            }
            if (s.length != 4 || (m = mmCurrent.getChild(s[1])).isEmpty()) continue;
            if (current.children == null) {
                current.children = new HashMap<String, String>();
            }
            current.children.put(s[2], m);
        }
        this.classMap.entrySet().removeIf(MinecraftRemapper.RemappedClass::isUseless);
    }

    @Override
    public Path getLocalRhinoDir() {
        return FMLPaths.GAMEDIR.get().resolve(".rhino_cache");
    }
}

