/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.rhino.mod.util;

import dev.latvian.mods.rhino.mod.util.RhinoProperties;
import dev.latvian.mods.rhino.util.Remapper;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MinecraftRemapper
implements Remapper {
    protected static final Logger LOGGER = LoggerFactory.getLogger((String)"Rhino Script Remapper");
    public static final int MM_VERSION = 1;
    public static final int VERSION = 1;
    public static final String MAPPINGS_HEADER_AND_WARNING = "# # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # #\n# IMPORTANT NOTE: This file is NOT meant to be published within public modpacks or repositories.  #\n# Its purpose is solely to allow for the use of Minecraft's \"official\" mappings within scripts    #\n# handled by Rhino, in order to enable script creators to interact with the game environment in   #\n# a more direct way. The contents of this file are not meant to be used outside of the Rhino      #\n# script environment, or for any other purpose than the one described here.                       #\n# This use of Minecraft's obfuscation mappings is governed by the Minecraft EULA,                 #\n# as well as the terms of the license provided within the original mappings file.                 #\n#                                                                                                 #\n# Mappings version: %s\t\t\t\t\t\t\t\t\t\t\t\t\t                          #\n# # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # #".formatted(1);
    public final Map<String, RemappedClass> classMap = new HashMap<String, RemappedClass>();
    private Map<String, String> inverseClassMap;
    private boolean empty = true;

    public MinecraftRemapper() {
        if (!this.isValid()) {
            return;
        }
        try {
            Path remappedPath = this.getPath("rhino_" + this.getModLoader() + "_" + this.getRuntimeMappings() + "_remapped_" + this.getMcVersion() + "_v1" + (this.isServer() ? "_server.txt" : "_client.txt"));
            if (Files.exists(remappedPath, new LinkOption[0]) && Files.size(remappedPath) > 0L) {
                RemappedClass current = null;
                for (String line : Files.readAllLines(remappedPath, StandardCharsets.UTF_8)) {
                    String[] l = line.split(" ");
                    if (l[0].equals("*")) {
                        current = new RemappedClass(l[1], l[2]);
                        this.classMap.put(current.originalName, current);
                        int cc = Integer.parseInt(l[3]);
                        if (cc <= 0) continue;
                        current.children = new HashMap<String, String>(cc);
                        continue;
                    }
                    if (current == null || l[0].startsWith("#")) continue;
                    current.children.put(l[0], l[1]);
                }
            } else {
                MinecraftClasses minecraftClasses = this.loadMojMapClasses();
                this.init(minecraftClasses);
                ArrayList<Object> list = new ArrayList<Object>();
                list.add(MAPPINGS_HEADER_AND_WARNING);
                for (Map.Entry<String, RemappedClass> entry : this.classMap.entrySet()) {
                    RemappedClass rc = entry.getValue();
                    list.add("* " + rc.originalName + " " + rc.mappedName + " " + (rc.children == null ? 0 : rc.children.size()));
                    if (rc.children == null) continue;
                    for (Map.Entry<String, String> entry1 : rc.children.entrySet()) {
                        list.add(entry1.getKey() + " " + entry1.getValue());
                    }
                }
                Files.write(remappedPath, list, new OpenOption[0]);
            }
            this.empty = false;
        }
        catch (Exception ex) {
            LOGGER.error("Failed to remap Rhino to Mojang Mappings:");
            ex.printStackTrace();
        }
    }

    private Path getPath(String file) throws Exception {
        Path gitignore;
        if (!RhinoProperties.INSTANCE.forceLocalMappings) {
            block9: {
                try {
                    Path path = Paths.get(System.getProperty("java.io.tmpdir"), new String[0]).resolve(file);
                    if (Files.exists(path, new LinkOption[0])) {
                        if (Files.isReadable(path) && Files.isWritable(path)) {
                            return path;
                        }
                        break block9;
                    }
                    Files.createFile(path, new FileAttribute[0]);
                    return path;
                }
                catch (Exception ex) {
                    LOGGER.error("Error while trying to access system temp folder!", (Throwable)ex);
                }
            }
            LOGGER.error("Failed to access mappings file in system temp, using local cache directory instead!");
        } else {
            LOGGER.info("forceLocalMappings is set, we will not attempt to use the system temp folder");
        }
        Path dir = this.getLocalRhinoDir();
        if (Files.notExists(dir, new LinkOption[0])) {
            Files.createDirectories(dir, new FileAttribute[0]);
            if (Util.m_137581_() == Util.OS.WINDOWS) {
                Files.setAttribute(dir, "dos:hidden", true, LinkOption.NOFOLLOW_LINKS);
            }
        }
        if (Files.notExists(gitignore = dir.resolve(".gitignore"), new LinkOption[0])) {
            Files.writeString(gitignore, (CharSequence)"*", StandardOpenOption.CREATE_NEW);
        }
        return dir.resolve(file);
    }

    public MinecraftClasses loadMojMapClasses() throws Exception {
        Path mojmapPath = this.getPath("rhino_mojang_mappings_" + this.getMcVersion() + "_v1" + (this.isServer() ? "_server.txt" : "_client.txt"));
        if (Files.exists(mojmapPath, new LinkOption[0]) && Files.size(mojmapPath) > 0L) {
            return this.readMojMapClasses(mojmapPath);
        }
        MinecraftClasses minecraftClasses = this.fetchMojMapClasses();
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(MAPPINGS_HEADER_AND_WARNING);
        for (Map.Entry<String, RemappedClass> entry : minecraftClasses.rawLookup.entrySet()) {
            RemappedClass rc = entry.getValue();
            list.add("* " + rc.originalName + " " + rc.mappedName + " " + (rc.children == null ? 0 : rc.children.size()));
            if (rc.children == null) continue;
            for (Map.Entry<String, String> entry1 : rc.children.entrySet()) {
                list.add(entry1.getKey() + " " + entry1.getValue());
            }
        }
        Files.write(mojmapPath, list, new OpenOption[0]);
        return minecraftClasses;
    }

    public MinecraftClasses readMojMapClasses(Path path) throws Exception {
        MinecraftClasses minecraftClasses = new MinecraftClasses(new HashMap<String, RemappedClass>(), new HashMap<String, RemappedClass>());
        RemappedClass current = null;
        for (String line : Files.readAllLines(path, StandardCharsets.UTF_8)) {
            String[] l = line.split(" ");
            if (l[0].equals("*")) {
                current = new RemappedClass(l[1], l[2]);
                minecraftClasses.rawLookup.put(current.originalName, current);
                minecraftClasses.mappedLookup.put(current.mappedName, current);
                int cc = Integer.parseInt(l[3]);
                if (cc <= 0) continue;
                current.children = new HashMap<String, String>(cc);
                continue;
            }
            if (current == null || l[0].startsWith("#")) continue;
            current.children.put(l[0], l[1]);
        }
        return minecraftClasses;
    }

    public MinecraftClasses fetchMojMapClasses() throws Exception {
        String[] mojmaps;
        URL mojmapUrl;
        MinecraftClasses minecraftClasses = new MinecraftClasses(new HashMap<String, RemappedClass>(), new HashMap<String, RemappedClass>());
        URL kubejsMappings = new URL("https://kubejs.com/mappings/%s/%s".formatted(this.getMcVersion(), this.isServer() ? "server.txt" : "client.txt"));
        try {
            mojmapUrl = new URL(IOUtils.toString((InputStream)((URLConnection)Util.m_137469_((Object)kubejsMappings.openConnection(), conn -> {
                conn.setConnectTimeout(5000);
                conn.setReadTimeout(10000);
            })).getInputStream(), (Charset)StandardCharsets.UTF_8));
        }
        catch (Exception e) {
            LOGGER.error("Failed to fetch mojang mappings data from %s".formatted(kubejsMappings));
            LOGGER.error("This likely either means that kubejs.com is down or blocked in your country.");
            LOGGER.error("We will proceed without remapping here, so you will have to use obfuscated names for internal Minecraft classes!");
            LOGGER.error("As a workaround, you can try out the fix outlined here: https://github.com/KubeJS-Mods/Rhino/issues/26#issuecomment-1187123192");
            throw e;
        }
        try {
            mojmaps = IOUtils.toString((InputStream)((URLConnection)Util.m_137469_((Object)mojmapUrl.openConnection(), conn -> {
                conn.setConnectTimeout(10000);
                conn.setReadTimeout(60000);
            })).getInputStream(), (Charset)StandardCharsets.UTF_8).split("\n");
        }
        catch (Exception e) {
            if (e instanceof InterruptedIOException) {
                LOGGER.error("Timeout while downloading mojang mappings from {}!", (Object)mojmapUrl);
            } else {
                LOGGER.error("Failed to download mojang mappings from {}!", (Object)mojmapUrl);
            }
            LOGGER.error("Your connection might be unstable or blocking Mojang's servers, please try again later.");
            LOGGER.error("We will proceed without remapping here, so you will have to use obfuscated names for internal Minecraft classes!");
            LOGGER.error("As a workaround, you can try out the fix outlined here: https://github.com/KubeJS-Mods/Rhino/issues/26#issuecomment-1187123192");
            throw e;
        }
        for (String s : mojmaps) {
            String[] s1;
            if ((s = s.trim()).startsWith("#") || !s.endsWith(":") || (s1 = s.substring(0, s.length() - 1).split(" -> ", 2)).length != 2 || s1[0].endsWith(".package-info")) continue;
            RemappedClass c = new RemappedClass(s1[1], s1[0]);
            minecraftClasses.rawLookup.put(c.originalName, c);
            minecraftClasses.mappedLookup.put(c.mappedName, c);
        }
        Pattern pattern = Pattern.compile("([\\w$<>]+)(\\(.*\\))? -> ([\\w$<>]+)");
        RemappedClass current = null;
        for (String s : mojmaps) {
            Matcher matcher;
            if ((s = s.trim()).isEmpty() || s.startsWith("#")) continue;
            if (s.endsWith(":")) {
                String raw = s.substring(s.lastIndexOf(32) + 1, s.length() - 1);
                current = minecraftClasses.rawLookup.get(raw);
                continue;
            }
            if (current == null || !(matcher = pattern.matcher(s)).find()) continue;
            String mappedName = matcher.group(1);
            String args = matcher.group(2);
            String rawName = matcher.group(3);
            if (rawName.equals(mappedName) || mappedName.startsWith("lambda$") || mappedName.startsWith("val$") || mappedName.startsWith("access$") || mappedName.startsWith("this$")) continue;
            if (current.children == null) {
                current.children = new LinkedHashMap<String, String>();
            }
            if (args != null && args.length() >= 2) {
                StringBuilder sb = new StringBuilder(rawName);
                sb.append('(');
                String a = args.substring(1, args.length() - 1);
                if (a.length() > 0) {
                    String[] a1;
                    for (String value : a1 = a.split(",")) {
                        sb.append(Remapper.getTypeName(value, minecraftClasses));
                    }
                }
                sb.append(')');
                current.children.put(sb.toString(), mappedName);
                continue;
            }
            current.children.put(rawName, mappedName);
        }
        return minecraftClasses;
    }

    public boolean isValid() {
        return true;
    }

    public abstract String getModLoader();

    public abstract boolean isServer();

    public abstract String getRuntimeMappings();

    public String getMcVersion() {
        return SharedConstants.m_183709_().getName();
    }

    public abstract void init(MinecraftClasses var1) throws Exception;

    public abstract Path getLocalRhinoDir();

    @Override
    public String remapClass(Class<?> from, String className) {
        RemappedClass c = this.empty ? null : this.classMap.get(className);
        return c == null ? "" : c.mappedName;
    }

    @Override
    public String unmapClass(String from) {
        if (this.empty) {
            return "";
        }
        if (this.inverseClassMap == null) {
            this.inverseClassMap = new HashMap<String, String>(this.classMap.size());
            for (Map.Entry<String, RemappedClass> entry : this.classMap.entrySet()) {
                this.inverseClassMap.put(entry.getValue().mappedName, entry.getKey());
            }
        }
        return this.inverseClassMap.getOrDefault(from, "");
    }

    @Override
    public String remapField(Class<?> from, Field field, String fieldName) {
        RemappedClass c = this.empty ? null : this.classMap.get(from.getName());
        return c == null ? "" : c.getChild(fieldName);
    }

    @Override
    public String remapMethod(Class<?> from, Method method, String methodString) {
        RemappedClass c = this.empty ? null : this.classMap.get(from.getName());
        return c == null ? "" : c.getChild(methodString);
    }

    public static class RemappedClass {
        public final String originalName;
        public final String mappedName;
        public Map<String, String> children;

        public RemappedClass(String on, String mn) {
            this.originalName = on;
            this.mappedName = mn;
        }

        public String toString() {
            return this.mappedName;
        }

        public String getChild(String s) {
            return this.children == null || this.children.isEmpty() ? "" : this.children.getOrDefault(s, "");
        }

        public boolean isUseless() {
            return (this.children == null || this.children.isEmpty()) && this.originalName.equals(this.mappedName);
        }

        public static boolean isUseless(Map.Entry<String, RemappedClass> entry) {
            return entry.getValue().isUseless();
        }
    }

    public record MinecraftClasses(Map<String, RemappedClass> rawLookup, Map<String, RemappedClass> mappedLookup) implements Function<String, String>
    {
        @Override
        public String apply(String s) {
            RemappedClass c = this.mappedLookup.get(s);
            return c == null ? s : c.originalName;
        }
    }
}

