/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.rhino.classdata;

import dev.latvian.mods.rhino.ScriptRuntime;
import dev.latvian.mods.rhino.classdata.ClassData;
import dev.latvian.mods.rhino.classdata.MethodInfo;
import dev.latvian.mods.rhino.classdata.MethodSignature;
import dev.latvian.mods.rhino.util.Possible;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class ClassMember {
    public final ClassData classData;
    public final String name;
    public boolean isFinal;
    public Field field;
    public Map<MethodSignature, MethodInfo> methods;
    public MethodInfo beanGet;
    public MethodInfo beanSet;
    private Map<MethodSignature, Possible<MethodInfo>> jsMethods;

    ClassMember(ClassData c, String n) {
        this.classData = c;
        this.name = n;
    }

    public String toString() {
        return this.name;
    }

    public Possible<?> get(@Nullable Object obj) throws Exception {
        if (this.beanGet != null) {
            return Possible.of(this.beanGet.method.invoke(obj, ScriptRuntime.emptyArgs));
        }
        if (this.field != null) {
            return Possible.NULL;
        }
        return Possible.EMPTY;
    }

    public Possible<?> set(@Nullable Object obj, @Nullable Object value) throws Exception {
        if (this.beanSet != null) {
            return Possible.of(this.beanSet.method.invoke(obj, value));
        }
        if (!this.isFinal) {
            this.field.set(obj, value);
            return Possible.NULL;
        }
        return Possible.EMPTY;
    }

    public Possible<?> invoke(MethodSignature sig, @Nullable Object obj, Object[] args) throws Exception {
        MethodInfo m = this.methods.get(sig);
        if (m != null) {
            return Possible.of(m.method.invoke(obj, args));
        }
        return Possible.EMPTY;
    }

    private Possible<MethodInfo> method(MethodSignature sig, Object[] args) {
        Possible<MethodInfo> p;
        if (this.methods == null) {
            return Possible.absent();
        }
        if (this.jsMethods == null) {
            this.jsMethods = new HashMap<MethodSignature, Possible<MethodInfo>>();
        }
        if ((p = this.jsMethods.get(sig)) == null) {
            p = Possible.absent();
            for (MethodInfo m : this.methods.values()) {
                if (!m.signature.matches(sig, this.classData.cache.context)) continue;
                p = Possible.of(m);
                break;
            }
            this.jsMethods.put(sig, p);
        }
        return p;
    }

    public void merge(ClassMember member) {
        boolean bl = this.isFinal = this.isFinal || member.isFinal;
        if (this.field == null) {
            this.field = member.field;
        }
        if (member.methods != null && !member.methods.isEmpty()) {
            if (this.methods == null) {
                this.methods = new HashMap<MethodSignature, MethodInfo>();
            }
            for (Map.Entry<MethodSignature, MethodInfo> entry : member.methods.entrySet()) {
                MethodInfo mi = this.methods.get(entry.getKey());
                MethodInfo m = entry.getValue();
                if (mi == null) {
                    this.methods.put(entry.getKey(), m);
                    continue;
                }
                boolean bl2 = mi.isHidden = mi.isHidden || m.isHidden;
                if (mi.bean != null) continue;
                mi.bean = m.bean;
            }
        }
        if (this.beanGet == null) {
            this.beanGet = member.beanGet;
        }
        if (this.beanSet == null) {
            this.beanSet = member.beanSet;
        }
    }
}

