/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.rhino;

import dev.latvian.mods.rhino.BaseFunction;
import dev.latvian.mods.rhino.Context;
import dev.latvian.mods.rhino.Scriptable;
import dev.latvian.mods.rhino.Undefined;

public class CustomFunction
extends BaseFunction {
    public static final Class<?>[] NO_ARGS = new Class[0];
    private final String functionName;
    private final Func func;
    private final Class<?>[] argTypes;

    public CustomFunction(String functionName, Func func, Class<?>[] argTypes) {
        this.functionName = functionName;
        this.func = func;
        this.argTypes = argTypes;
    }

    @Override
    public String getFunctionName() {
        return this.functionName;
    }

    @Override
    public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        Object[] origArgs = args;
        for (int i = 0; i < args.length; ++i) {
            Object arg = args[i];
            Object coerced = Context.jsToJava(cx, arg, this.argTypes[i]);
            if (coerced == arg) continue;
            if (origArgs == args) {
                args = (Object[])args.clone();
            }
            args[i] = coerced;
        }
        Object retval = this.func.call(args);
        if (retval == null) {
            return Undefined.instance;
        }
        Object wrapped = cx.getWrapFactory().wrap(cx, scope, retval, retval.getClass());
        if (wrapped == null) {
            wrapped = Undefined.instance;
        }
        return wrapped;
    }

    @FunctionalInterface
    public static interface Func {
        public Object call(Object[] var1);
    }

    @FunctionalInterface
    public static interface NoArgFunc
    extends Func {
        public Object call();

        @Override
        default public Object call(Object[] args) {
            return this.call();
        }
    }
}

