/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.rhino;

import dev.latvian.mods.rhino.Context;
import dev.latvian.mods.rhino.DefaultErrorReporter;
import dev.latvian.mods.rhino.ErrorReporter;

public class CompilerEnvirons {
    private ErrorReporter errorReporter = DefaultErrorReporter.instance;
    private boolean reservedKeywordAsIdentifier = true;
    private boolean allowMemberExprAsFunctionName;
    private boolean strictMode;
    private boolean warningAsError;

    public void initFromContext(Context cx) {
        this.setErrorReporter(cx.getErrorReporter());
        this.reservedKeywordAsIdentifier = cx.hasFeature(3);
        this.allowMemberExprAsFunctionName = cx.hasFeature(2);
        this.strictMode = cx.hasFeature(11);
        this.warningAsError = cx.hasFeature(12);
    }

    public final ErrorReporter getErrorReporter() {
        return this.errorReporter;
    }

    public void setErrorReporter(ErrorReporter errorReporter) {
        if (errorReporter == null) {
            throw new IllegalArgumentException();
        }
        this.errorReporter = errorReporter;
    }

    public final boolean isReservedKeywordAsIdentifier() {
        return this.reservedKeywordAsIdentifier;
    }

    public final boolean isAllowMemberExprAsFunctionName() {
        return this.allowMemberExprAsFunctionName;
    }

    public final boolean isStrictMode() {
        return this.strictMode;
    }

    public void setStrictMode(boolean strict) {
        this.strictMode = strict;
    }

    public final boolean reportWarningAsError() {
        return this.warningAsError;
    }
}

