/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.champions.common.util;

import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.level.block.entity.BeaconBlockEntity;
import net.minecraft.world.level.block.entity.TickingBlockEntity;
import top.theillusivec4.champions.common.config.ChampionsConfig;
import top.theillusivec4.champions.common.config.ConfigEnums;

public class ChampionHelper {
    public static boolean isValidChampion(Entity entity) {
        return entity instanceof LivingEntity && entity instanceof Enemy;
    }

    public static boolean checkPotential(LivingEntity livingEntity) {
        return ChampionHelper.isValidEntity(livingEntity) && ChampionHelper.isValidDimension(livingEntity.m_183503_().m_46472_().m_135782_()) && !ChampionHelper.nearActiveBeacon(livingEntity);
    }

    private static boolean isValidEntity(LivingEntity livingEntity) {
        ResourceLocation rl = livingEntity.m_6095_().getRegistryName();
        if (rl == null) {
            return false;
        }
        String entity = rl.toString();
        if (ChampionsConfig.entitiesPermission == ConfigEnums.Permission.BLACKLIST) {
            return !ChampionsConfig.entitiesList.contains(entity);
        }
        return ChampionsConfig.entitiesList.contains(entity);
    }

    private static boolean isValidDimension(ResourceLocation resourceLocation) {
        String dimension = resourceLocation.toString();
        if (ChampionsConfig.dimensionPermission == ConfigEnums.Permission.BLACKLIST) {
            return !ChampionsConfig.dimensionList.contains(dimension);
        }
        return ChampionsConfig.dimensionList.contains(dimension);
    }

    private static boolean nearActiveBeacon(LivingEntity livingEntity) {
        int range = ChampionsConfig.beaconProtectionRange;
        if (range <= 0) {
            return false;
        }
        for (TickingBlockEntity te : livingEntity.m_183503_().f_151512_) {
            BlockPos pos = te.m_142689_();
            if (!(Math.sqrt(livingEntity.m_20275_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_())) <= (double)range) || !(te instanceof BeaconBlockEntity)) continue;
            BeaconBlockEntity beacon = (BeaconBlockEntity)te;
            if (beacon.f_58650_ <= 0) continue;
            return true;
        }
        return false;
    }
}

