/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.champions.common;

import java.util.List;
import java.util.Optional;
import net.minecraft.Util;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.ChatType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Tuple;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Explosion;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.event.entity.living.LivingHealEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import top.theillusivec4.champions.api.IChampion;
import top.theillusivec4.champions.common.capability.ChampionCapability;
import top.theillusivec4.champions.common.config.ChampionsConfig;
import top.theillusivec4.champions.common.rank.Rank;
import top.theillusivec4.champions.common.registry.ChampionsRegistry;
import top.theillusivec4.champions.common.stat.ChampionsStats;
import top.theillusivec4.champions.common.util.ChampionBuilder;

public class ChampionEventsHandler {
    @SubscribeEvent
    public void onLivingXpDrop(LivingExperienceDropEvent evt) {
        LivingEntity livingEntity = evt.getEntityLiving();
        ChampionCapability.getCapability(livingEntity).ifPresent(champion -> champion.getServer().getRank().ifPresent(rank -> {
            int growth = rank.getGrowthFactor();
            if (growth > 0) {
                evt.setDroppedExperience(growth * ChampionsConfig.experienceGrowth * evt.getOriginalExperience() + evt.getOriginalExperience());
            }
        }));
    }

    @SubscribeEvent
    public void onExplosion(ExplosionEvent.Start evt) {
        Explosion explosion = evt.getExplosion();
        Entity entity = explosion.getExploder();
        if (entity != null && !entity.m_183503_().m_5776_()) {
            ChampionCapability.getCapability(entity).ifPresent(champion -> champion.getServer().getRank().ifPresent(rank -> {
                int growth = rank.getGrowthFactor();
                if (growth > 0) {
                    explosion.f_46017_ += (float)(ChampionsConfig.explosionGrowth * growth);
                }
            }));
        }
    }

    @SubscribeEvent
    public void onLivingJoinWorld(EntityJoinWorldEvent evt) {
        Entity entity = evt.getEntity();
        if (!entity.m_183503_().m_5776_()) {
            ChampionCapability.getCapability(entity).ifPresent(champion -> {
                IChampion.Server serverChampion = champion.getServer();
                Optional<Rank> maybeRank = serverChampion.getRank();
                if (maybeRank.isEmpty()) {
                    ChampionBuilder.spawn(champion);
                }
                serverChampion.getAffixes().forEach(affix -> affix.onSpawn((IChampion)champion));
                serverChampion.getRank().ifPresent(rank -> {
                    List<Tuple<MobEffect, Integer>> effects = rank.getEffects();
                    effects.forEach(effectPair -> champion.getLivingEntity().m_7292_(new MobEffectInstance((MobEffect)effectPair.m_14418_(), 200, ((Integer)effectPair.m_14419_()).intValue())));
                });
            });
        }
    }

    @SubscribeEvent
    public void onLivingUpdate(LivingEvent.LivingUpdateEvent evt) {
        LivingEntity livingEntity = evt.getEntityLiving();
        if (livingEntity.m_183503_().m_5776_()) {
            ChampionCapability.getCapability(livingEntity).ifPresent(champion -> {
                IChampion.Client clientChampion = champion.getClient();
                clientChampion.getAffixes().forEach(affix -> affix.onClientUpdate((IChampion)champion));
                clientChampion.getRank().ifPresent(rank -> {
                    if (ChampionsConfig.showParticles && (Integer)rank.m_14418_() > 0) {
                        int color = (Integer)rank.m_14419_();
                        float r = (float)(color >> 16 & 0xFF) / 255.0f;
                        float g = (float)(color >> 8 & 0xFF) / 255.0f;
                        float b = (float)(color & 0xFF) / 255.0f;
                        livingEntity.m_183503_().m_7106_((ParticleOptions)ChampionsRegistry.RANK, livingEntity.m_20182_().f_82479_ + (livingEntity.m_21187_().nextDouble() - 0.5) * (double)livingEntity.m_20205_(), livingEntity.m_20182_().f_82480_ + livingEntity.m_21187_().nextDouble() * (double)livingEntity.m_20206_(), livingEntity.m_20182_().f_82481_ + (livingEntity.m_21187_().nextDouble() - 0.5) * (double)livingEntity.m_20205_(), (double)r, (double)g, (double)b);
                    }
                });
            });
        } else if (livingEntity.f_19797_ % 10 == 0) {
            ChampionCapability.getCapability(livingEntity).ifPresent(champion -> {
                IChampion.Server serverChampion = champion.getServer();
                serverChampion.getAffixes().forEach(affix -> affix.onServerUpdate((IChampion)champion));
                serverChampion.getRank().ifPresent(rank -> {
                    if (livingEntity.f_19797_ % 4 == 0) {
                        List<Tuple<MobEffect, Integer>> effects = rank.getEffects();
                        effects.forEach(effectPair -> livingEntity.m_7292_(new MobEffectInstance((MobEffect)effectPair.m_14418_(), 100, ((Integer)effectPair.m_14419_()).intValue())));
                    }
                });
            });
        }
    }

    @SubscribeEvent
    public void onLivingAttack(LivingAttackEvent evt) {
        LivingEntity livingEntity = evt.getEntityLiving();
        if (livingEntity.m_183503_().m_5776_()) {
            return;
        }
        ChampionCapability.getCapability(livingEntity).ifPresent(champion -> {
            IChampion.Server serverChampion = champion.getServer();
            serverChampion.getAffixes().forEach(affix -> {
                if (!affix.onAttacked((IChampion)champion, evt.getSource(), evt.getAmount())) {
                    evt.setCanceled(true);
                }
            });
        });
        if (evt.isCanceled()) {
            return;
        }
        Entity source = evt.getSource().m_7640_();
        ChampionCapability.getCapability(source).ifPresent(champion -> {
            IChampion.Server serverChampion = champion.getServer();
            serverChampion.getAffixes().forEach(affix -> {
                if (!affix.onAttack((IChampion)champion, evt.getEntityLiving(), evt.getSource(), evt.getAmount())) {
                    evt.setCanceled(true);
                }
            });
        });
    }

    @SubscribeEvent
    public void onLivingHurt(LivingHurtEvent evt) {
        LivingEntity livingEntity = evt.getEntityLiving();
        if (!livingEntity.m_183503_().m_5776_()) {
            float[] amounts = new float[]{evt.getAmount(), evt.getAmount()};
            ChampionCapability.getCapability(livingEntity).ifPresent(champion -> {
                IChampion.Server serverChampion = champion.getServer();
                serverChampion.getAffixes().forEach(affix -> {
                    amounts[1] = affix.onHurt((IChampion)champion, evt.getSource(), amounts[0], amounts[1]);
                });
            });
            evt.setAmount(amounts[1]);
        }
    }

    @SubscribeEvent
    public void onLivingDamage(LivingDamageEvent evt) {
        LivingEntity livingEntity = evt.getEntityLiving();
        if (!livingEntity.m_183503_().m_5776_()) {
            float[] amounts = new float[]{evt.getAmount(), evt.getAmount()};
            ChampionCapability.getCapability(livingEntity).ifPresent(champion -> {
                IChampion.Server serverChampion = champion.getServer();
                serverChampion.getAffixes().forEach(affix -> {
                    amounts[1] = affix.onDamage((IChampion)champion, evt.getSource(), amounts[0], amounts[1]);
                });
            });
            evt.setAmount(amounts[1]);
        }
    }

    @SubscribeEvent
    public void onLivingDeath(LivingDeathEvent evt) {
        LivingEntity livingEntity = evt.getEntityLiving();
        if (livingEntity.m_183503_().m_5776_()) {
            return;
        }
        ChampionCapability.getCapability(livingEntity).ifPresent(champion -> {
            IChampion.Server serverChampion = champion.getServer();
            serverChampion.getAffixes().forEach(affix -> {
                if (!affix.onDeath((IChampion)champion, evt.getSource())) {
                    evt.setCanceled(true);
                }
            });
            serverChampion.getRank().ifPresent(rank -> {
                Entity source;
                if (!evt.isCanceled() && (source = evt.getSource().m_7639_()) instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)source;
                    if (!(source instanceof FakePlayer)) {
                        MinecraftServer server;
                        player.m_36220_(ChampionsStats.CHAMPION_MOBS_KILLED);
                        int messageTier = ChampionsConfig.deathMessageTier;
                        if (messageTier > 0 && rank.getTier() >= messageTier && (server = livingEntity.m_20194_()) != null) {
                            server.m_6846_().m_11264_((Component)new TranslatableComponent("rank.champions.title." + rank.getTier()).m_130946_(" ").m_7220_(livingEntity.m_21231_().m_19293_()), ChatType.SYSTEM, Util.f_137441_);
                        }
                    }
                }
            });
        });
    }

    @SubscribeEvent
    public void onLivingHeal(LivingHealEvent evt) {
        LivingEntity livingEntity = evt.getEntityLiving();
        if (!livingEntity.m_183503_().m_5776_()) {
            float[] amounts = new float[]{evt.getAmount(), evt.getAmount()};
            ChampionCapability.getCapability(livingEntity).ifPresent(champion -> {
                IChampion.Server serverChampion = champion.getServer();
                serverChampion.getAffixes().forEach(affix -> {
                    amounts[1] = affix.onHeal((IChampion)champion, amounts[0], amounts[1]);
                });
            });
            evt.setAmount(amounts[1]);
        }
    }
}

