/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks.net;

import dev.architectury.networking.NetworkManager;
import dev.architectury.networking.simple.BaseS2CMessage;
import dev.architectury.networking.simple.MessageType;
import dev.ftb.mods.ftbchunks.FTBChunks;
import dev.ftb.mods.ftbchunks.data.ClaimedChunk;
import dev.ftb.mods.ftbchunks.net.FTBChunksNet;
import java.util.UUID;
import net.minecraft.Util;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class SendChunkPacket
extends BaseS2CMessage {
    public ResourceKey<Level> dimension;
    public UUID teamId;
    public SingleChunk chunk;

    public SendChunkPacket() {
    }

    public MessageType getType() {
        return FTBChunksNet.SEND_CHUNK;
    }

    SendChunkPacket(FriendlyByteBuf buf) {
        this.dimension = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)buf.m_130281_());
        this.teamId = buf.m_130259_();
        this.chunk = new SingleChunk(buf, this.teamId);
    }

    public void write(FriendlyByteBuf buf) {
        buf.m_130085_(this.dimension.m_135782_());
        buf.m_130077_(this.teamId);
        this.chunk.write(buf, this.teamId);
    }

    public void handle(NetworkManager.PacketContext context) {
        FTBChunks.PROXY.updateChunk(this);
    }

    public static class SingleChunk {
        public int x;
        public int z;
        public long relativeTimeClaimed;
        public long relativeTimeForceLoaded;
        public boolean forceLoaded;

        public SingleChunk(long now, int _x, int _z, @Nullable ClaimedChunk claimedChunk) {
            this.x = _x;
            this.z = _z;
            if (claimedChunk != null) {
                this.relativeTimeClaimed = now - claimedChunk.getTimeClaimed();
                this.forceLoaded = claimedChunk.isForceLoaded();
                if (this.forceLoaded) {
                    this.relativeTimeForceLoaded = now - claimedChunk.getForceLoadedTime();
                }
            }
        }

        public SingleChunk(FriendlyByteBuf buf, UUID teamId) {
            this.x = buf.m_130242_();
            this.z = buf.m_130242_();
            if (!teamId.equals(Util.f_137441_)) {
                this.relativeTimeClaimed = buf.m_130258_();
                this.forceLoaded = buf.readBoolean();
                if (this.forceLoaded) {
                    this.relativeTimeForceLoaded = buf.m_130258_();
                }
            }
        }

        public void write(FriendlyByteBuf buf, UUID teamId) {
            buf.m_130130_(this.x);
            buf.m_130130_(this.z);
            if (!teamId.equals(Util.f_137441_)) {
                buf.m_130103_(this.relativeTimeClaimed);
                buf.writeBoolean(this.forceLoaded);
                if (this.forceLoaded) {
                    buf.m_130103_(this.relativeTimeForceLoaded);
                }
            }
        }
    }
}

