/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks.net;

import dev.architectury.networking.NetworkManager;
import dev.architectury.networking.simple.BaseC2SMessage;
import dev.architectury.networking.simple.MessageType;
import dev.ftb.mods.ftbchunks.FTBChunks;
import dev.ftb.mods.ftbchunks.data.ClaimResult;
import dev.ftb.mods.ftbchunks.data.FTBChunksAPI;
import dev.ftb.mods.ftbchunks.data.FTBChunksTeamData;
import dev.ftb.mods.ftbchunks.net.FTBChunksNet;
import dev.ftb.mods.ftbchunks.net.SendGeneralDataPacket;
import dev.ftb.mods.ftblibrary.math.XZ;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;

public class RequestChunkChangePacket
extends BaseC2SMessage {
    private static final String[] ACTION_NAMES = new String[]{"claim", "unclaim", "load", "unload"};
    private final int action;
    private final Set<XZ> chunks;

    public RequestChunkChangePacket(int a, Set<XZ> c) {
        this.action = a;
        this.chunks = c;
    }

    RequestChunkChangePacket(FriendlyByteBuf buf) {
        this.action = buf.m_130242_();
        int s = buf.m_130242_();
        this.chunks = new LinkedHashSet<XZ>(s);
        for (int i = 0; i < s; ++i) {
            int x = buf.m_130242_();
            int z = buf.m_130242_();
            this.chunks.add(XZ.of((int)x, (int)z));
        }
    }

    public MessageType getType() {
        return FTBChunksNet.REQUEST_CHUNK_CHANGE;
    }

    public void write(FriendlyByteBuf buf) {
        buf.m_130130_(this.action);
        buf.m_130130_(this.chunks.size());
        for (XZ pos : this.chunks) {
            buf.m_130130_(pos.x);
            buf.m_130130_(pos.z);
        }
    }

    public void handle(NetworkManager.PacketContext context) {
        Function<XZ, ClaimResult> consumer;
        ServerPlayer player = (ServerPlayer)context.getPlayer();
        CommandSourceStack source = player.m_20203_();
        FTBChunksTeamData data = FTBChunksAPI.getManager().getData(player);
        long now = System.currentTimeMillis();
        switch (this.action) {
            case 0: {
                consumer = pos -> {
                    ClaimResult result = data.claim(source, pos.dim(player.f_19853_), false);
                    if (result.isSuccess()) {
                        result.setClaimedTime(now);
                    }
                    return result;
                };
                break;
            }
            case 1: {
                consumer = pos -> data.unclaim(source, pos.dim(player.f_19853_), false);
                break;
            }
            case 2: {
                consumer = pos -> {
                    ClaimResult result = data.load(source, pos.dim(player.f_19853_), false);
                    if (result.isSuccess()) {
                        result.setForceLoadedTime(now);
                    }
                    return result;
                };
                break;
            }
            case 3: {
                consumer = pos -> data.unload(source, pos.dim(player.f_19853_), false);
                break;
            }
            default: {
                FTBChunks.LOGGER.warn("Unknown chunk action ID: " + this.action);
                return;
            }
        }
        for (XZ pos2 : this.chunks) {
            ClaimResult r = consumer.apply(pos2);
            if (r.isSuccess()) continue;
            FTBChunks.LOGGER.debug(String.format("%s tried to %s @ %s:%d:%d but got result %s", player.m_6302_(), ACTION_NAMES[this.action], player.f_19853_.m_46472_().m_135782_(), pos2.x, pos2.z, r));
        }
        SendGeneralDataPacket.send(data, player);
    }
}

