/*
 * Decompiled with CFR 0.152.
 */
package xyz.przemyk.simpleplanes.upgrades.storage;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import xyz.przemyk.simpleplanes.compat.ironchest.IronChestsCompat;
import xyz.przemyk.simpleplanes.container.StorageContainer;
import xyz.przemyk.simpleplanes.entities.PlaneEntity;
import xyz.przemyk.simpleplanes.setup.SimplePlanesEntities;
import xyz.przemyk.simpleplanes.setup.SimplePlanesUpgrades;
import xyz.przemyk.simpleplanes.upgrades.LargeUpgrade;
import xyz.przemyk.simpleplanes.upgrades.UpgradeType;

public class ChestUpgrade
extends LargeUpgrade
implements MenuProvider {
    public final ItemStackHandler itemStackHandler = new ItemStackHandler(27);
    public final LazyOptional<ItemStackHandler> itemHandlerLazyOptional = LazyOptional.of(() -> this.itemStackHandler);
    public Item chestType = Items.f_42009_;

    public ChestUpgrade(PlaneEntity planeEntity) {
        super((UpgradeType)((Object)SimplePlanesUpgrades.CHEST.get()), planeEntity);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.itemHandlerLazyOptional.invalidate();
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag nbt = this.itemStackHandler.serializeNBT();
        nbt.m_128359_("ChestType", this.chestType.getRegistryName().toString());
        return nbt;
    }

    @Override
    public void deserializeNBT(CompoundTag nbt) {
        this.itemStackHandler.deserializeNBT(nbt);
        Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(nbt.m_128461_("ChestType")));
        this.chestType = item == null ? Items.f_42009_ : item;
    }

    @Override
    public void writePacket(FriendlyByteBuf buffer) {
        buffer.writeRegistryId((IForgeRegistryEntry)this.chestType);
    }

    @Override
    public void readPacket(FriendlyByteBuf buffer) {
        this.chestType = (Item)buffer.readRegistryIdSafe(Item.class);
    }

    @Override
    public void onRemoved() {
        for (int i = 0; i < this.itemStackHandler.getSlots(); ++i) {
            ItemStack itemStack = this.itemStackHandler.getStackInSlot(i);
            if (itemStack.m_41619_()) continue;
            this.planeEntity.m_19983_(itemStack);
        }
        this.planeEntity.m_19998_((ItemLike)this.chestType);
    }

    @Override
    public void render(PoseStack matrixStack, MultiBufferSource buffer, int packedLight, float partialTicks) {
        matrixStack.m_85836_();
        EntityType entityType = this.planeEntity.m_6095_();
        if (entityType == SimplePlanesEntities.HELICOPTER.get()) {
            matrixStack.m_85837_(0.0, -0.1, -1.4);
        }
        matrixStack.m_85845_(Vector3f.f_122225_.m_122240_(180.0f));
        matrixStack.m_85845_(Vector3f.f_122227_.m_122240_(180.0f));
        matrixStack.m_85837_(-0.4, -1.0, -1.3);
        matrixStack.m_85841_(0.82f, 0.82f, 0.82f);
        BlockState state = this.chestType instanceof BlockItem ? ((BlockItem)this.chestType).m_40614_().m_49966_() : Blocks.f_50087_.m_49966_();
        Minecraft.m_91087_().m_91289_().renderSingleBlock(state, matrixStack, buffer, packedLight, OverlayTexture.f_118083_, (IModelData)EmptyModelData.INSTANCE);
        matrixStack.m_85849_();
    }

    public Component m_5446_() {
        return new TranslatableComponent("simpleplanes:chest");
    }

    public AbstractContainerMenu m_7208_(int id, Inventory playerInventoryIn, Player playerEntity) {
        return new StorageContainer(id, playerInventoryIn, (IItemHandler)this.itemStackHandler, this.chestType.getRegistryName().toString());
    }

    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.itemHandlerLazyOptional.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public void onApply(ItemStack itemStack, Player playerEntity) {
        this.chestType = itemStack.m_41720_();
        this.itemStackHandler.setSize(IronChestsCompat.getSize(this.chestType.getRegistryName().toString()));
    }

    @Override
    public boolean hasStorage() {
        return true;
    }

    @Override
    public void openStorageGui(ServerPlayer player) {
        NetworkHooks.openGui((ServerPlayer)player, (MenuProvider)this, buffer -> buffer.m_130070_(this.chestType.getRegistryName().toString()));
    }
}

