/*
 * Decompiled with CFR 0.152.
 */
package xyz.przemyk.simpleplanes.upgrades.shooter;

import com.mojang.math.Vector3f;
import java.util.Random;
import net.minecraft.Util;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.entity.projectile.Fireball;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.entity.projectile.SmallFireball;
import net.minecraft.world.entity.projectile.SpectralArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import xyz.przemyk.simpleplanes.entities.PlaneEntity;
import xyz.przemyk.simpleplanes.setup.SimplePlanesUpgrades;
import xyz.przemyk.simpleplanes.upgrades.Upgrade;
import xyz.przemyk.simpleplanes.upgrades.UpgradeType;

public class ShooterUpgrade
extends Upgrade {
    private boolean shootSide = false;

    public ShooterUpgrade(PlaneEntity planeEntity) {
        super((UpgradeType)((Object)SimplePlanesUpgrades.SHOOTER.get()), planeEntity);
    }

    @Override
    public void onItemRightClick(PlayerInteractEvent.RightClickItem event) {
        Player player = event.getPlayer();
        ItemStack itemStack = player.m_21120_(event.getHand());
        Vector3f motion1 = this.planeEntity.transformPos(new Vector3f(0.0f, 0.0f, (float)(1.0 + this.planeEntity.m_20184_().m_82553_())));
        Vec3 motion = new Vec3(motion1);
        Level world = event.getWorld();
        Random random = world.f_46441_;
        Vector3f pos = this.planeEntity.transformPos(new Vector3f(this.shootSide ? 0.8f : -0.8f, 0.8f, 0.8f));
        this.shootSide = !this.shootSide;
        this.updateClient();
        double x = (double)pos.m_122239_() + this.planeEntity.m_20185_();
        double y = (double)pos.m_122260_() + this.planeEntity.m_20186_();
        double z = (double)pos.m_122269_() + this.planeEntity.m_20189_();
        Item item = itemStack.m_41720_();
        if (item == Items.f_42688_) {
            FireworkRocketEntity fireworkrocketentity = new FireworkRocketEntity(world, itemStack, x, y, z, true);
            fireworkrocketentity.m_6686_(-motion.f_82479_, -motion.f_82480_, -motion.f_82481_, -((float)Math.max(0.5, motion.m_82553_() * 1.5)), 1.0f);
            world.m_7967_((Entity)fireworkrocketentity);
            if (!player.m_7500_()) {
                itemStack.m_41774_(1);
            }
        } else if (item == Items.f_42613_) {
            double d3 = random.nextGaussian() * 0.05 + 2.0 * motion.f_82479_;
            double d4 = random.nextGaussian() * 0.05;
            double d5 = random.nextGaussian() * 0.05 + 2.0 * motion.f_82481_;
            Fireball fireBallEntity = (Fireball)Util.m_137469_((Object)new SmallFireball(world, (LivingEntity)player, d3, d4, d5), p_229425_1_ -> p_229425_1_.m_37010_(itemStack));
            fireBallEntity.m_6034_(x, y, z);
            fireBallEntity.m_20256_(motion.m_82490_(2.0));
            world.m_7967_((Entity)fireBallEntity);
            if (!player.m_7500_()) {
                itemStack.m_41774_(1);
            }
        } else if (item == Items.f_42412_) {
            Arrow arrowEntity = new Arrow(world, x, y, z);
            arrowEntity.m_5602_((Entity)player);
            arrowEntity.m_20256_(motion.m_82490_(Math.max(motion.m_82553_() * 1.5, 3.0) / motion.m_82553_()));
            if (!player.m_7500_()) {
                itemStack.m_41774_(1);
                arrowEntity.f_36705_ = AbstractArrow.Pickup.ALLOWED;
            }
            world.m_7967_((Entity)arrowEntity);
        } else if (item == Items.f_42738_) {
            Arrow arrowEntity = new Arrow(world, x, y, z);
            arrowEntity.m_5602_((Entity)player);
            arrowEntity.m_36878_(itemStack);
            arrowEntity.m_20256_(motion.m_82490_(Math.max(motion.m_82553_() * 1.5, 3.0) / motion.m_82553_()));
            if (!player.m_7500_()) {
                itemStack.m_41774_(1);
                arrowEntity.f_36705_ = AbstractArrow.Pickup.ALLOWED;
            }
            world.m_7967_((Entity)arrowEntity);
        } else if (item == Items.f_42737_) {
            SpectralArrow arrowEntity = new SpectralArrow(world, x, y, z);
            arrowEntity.m_5602_((Entity)player);
            arrowEntity.m_20256_(motion.m_82490_(Math.max(motion.m_82553_() * 1.5, 3.0) / motion.m_82553_()));
            if (!player.m_7500_()) {
                itemStack.m_41774_(1);
                arrowEntity.f_36705_ = AbstractArrow.Pickup.ALLOWED;
            }
            world.m_7967_((Entity)arrowEntity);
        }
    }

    @Override
    public void writePacket(FriendlyByteBuf buffer) {
        buffer.writeBoolean(this.shootSide);
    }

    @Override
    public void readPacket(FriendlyByteBuf buffer) {
        this.shootSide = buffer.readBoolean();
    }

    @Override
    public void onRemoved() {
        this.planeEntity.m_19998_((ItemLike)Items.f_41855_);
    }
}

