/*
 * Decompiled with CFR 0.152.
 */
package xyz.przemyk.simpleplanes.upgrades.jukebox;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.RecordItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.network.PacketDistributor;
import xyz.przemyk.simpleplanes.client.MovingSound;
import xyz.przemyk.simpleplanes.entities.PlaneEntity;
import xyz.przemyk.simpleplanes.network.JukeboxPacket;
import xyz.przemyk.simpleplanes.network.SimplePlanesNetworking;
import xyz.przemyk.simpleplanes.setup.SimplePlanesEntities;
import xyz.przemyk.simpleplanes.setup.SimplePlanesUpgrades;
import xyz.przemyk.simpleplanes.upgrades.LargeUpgrade;
import xyz.przemyk.simpleplanes.upgrades.UpgradeType;

public class JukeboxUpgrade
extends LargeUpgrade {
    private ItemStack record = ItemStack.f_41583_;

    public JukeboxUpgrade(PlaneEntity planeEntity) {
        super((UpgradeType)((Object)SimplePlanesUpgrades.JUKEBOX.get()), planeEntity);
    }

    @Override
    public CompoundTag serializeNBT() {
        return this.record.m_41739_(new CompoundTag());
    }

    @Override
    public void deserializeNBT(CompoundTag nbt) {
        this.record = ItemStack.m_41712_((CompoundTag)nbt);
    }

    @Override
    public void onItemRightClick(PlayerInteractEvent.RightClickItem event) {
        RecordItem newRecordItem;
        Player player;
        ItemStack itemStack;
        Item item;
        if (!this.planeEntity.f_19853_.f_46443_ && (item = (itemStack = (player = event.getPlayer()).m_21120_(event.getHand())).m_41720_()) instanceof RecordItem && (newRecordItem = (RecordItem)item) != this.record.m_41720_()) {
            ItemStack oldRecord = this.record;
            this.record = itemStack.m_41777_();
            if (!player.m_7500_()) {
                itemStack.m_41774_(1);
            }
            if (!oldRecord.m_41619_()) {
                player.m_36356_(oldRecord);
            }
            player.m_36220_(Stats.f_12965_);
            SimplePlanesNetworking.INSTANCE.send(PacketDistributor.TRACKING_ENTITY.with(() -> this.planeEntity), (Object)new JukeboxPacket(this.planeEntity.m_142049_(), newRecordItem.getRegistryName()));
        }
    }

    @Override
    public void render(PoseStack matrixStack, MultiBufferSource buffer, int packedLight, float partialTicks) {
        matrixStack.m_85836_();
        EntityType entityType = this.planeEntity.m_6095_();
        if (entityType == SimplePlanesEntities.HELICOPTER.get()) {
            matrixStack.m_85837_(0.0, -0.1, -1.28);
        } else {
            matrixStack.m_85837_(0.0, 0.0, 0.1);
        }
        matrixStack.m_85845_(Vector3f.f_122227_.m_122240_(180.0f));
        matrixStack.m_85837_(-0.4, -1.0, 0.3);
        matrixStack.m_85841_(0.82f, 0.82f, 0.82f);
        BlockState state = Blocks.f_50131_.m_49966_();
        Minecraft.m_91087_().m_91289_().renderSingleBlock(state, matrixStack, buffer, packedLight, OverlayTexture.f_118083_, (IModelData)EmptyModelData.INSTANCE);
        matrixStack.m_85849_();
    }

    @Override
    public void writePacket(FriendlyByteBuf buffer) {
    }

    @Override
    public void readPacket(FriendlyByteBuf buffer) {
    }

    @Override
    public void onRemoved() {
        this.planeEntity.m_19998_((ItemLike)Items.f_41984_);
        this.planeEntity.m_19983_(this.record);
        if (this.planeEntity.f_19853_.f_46443_) {
            MovingSound.remove(this.planeEntity);
        }
    }
}

