/*
 * Decompiled with CFR 0.152.
 */
package xyz.przemyk.simpleplanes.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistryEntry;
import xyz.przemyk.simpleplanes.setup.SimplePlanesRecipes;

public record PlaneWorkbenchRecipe(ResourceLocation id, Ingredient ingredient, int ingredientAmount, int materialAmount, ItemStack result) implements Recipe<Container>
{
    public static final Serializer SERIALIZER = new Serializer();

    public boolean canCraft(ItemStack ingredientStack, ItemStack materialStack) {
        return ingredientStack.m_41613_() >= this.ingredientAmount && materialStack.m_41613_() >= this.materialAmount && this.ingredient.test(ingredientStack);
    }

    public ItemStack m_8043_() {
        return this.result;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return SERIALIZER;
    }

    public RecipeType<?> m_6671_() {
        return SimplePlanesRecipes.PLANE_WORKBENCH_RECIPE_TYPE;
    }

    public boolean m_5818_(Container p_77569_1_, Level p_77569_2_) {
        return false;
    }

    public ItemStack m_5874_(Container p_77572_1_) {
        return null;
    }

    public boolean m_8004_(int p_194133_1_, int p_194133_2_) {
        return false;
    }

    public static class Serializer
    extends ForgeRegistryEntry<RecipeSerializer<?>>
    implements RecipeSerializer<PlaneWorkbenchRecipe> {
        public Serializer() {
            this.setRegistryName("simpleplanes", "plane_workbench");
        }

        public PlaneWorkbenchRecipe fromJson(ResourceLocation id, JsonObject json) {
            Ingredient ingredient = Ingredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)json, (String)"ingredient"));
            int ingredientAmount = GsonHelper.m_13927_((JsonObject)json, (String)"ingredient_amount");
            int materialAmount = GsonHelper.m_13927_((JsonObject)json, (String)"material_amount");
            ItemStack result = ShapedRecipe.m_151278_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result")).m_7968_();
            return new PlaneWorkbenchRecipe(id, ingredient, ingredientAmount, materialAmount, result);
        }

        @Nullable
        public PlaneWorkbenchRecipe fromNetwork(ResourceLocation id, FriendlyByteBuf buffer) {
            Ingredient ingredient = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            int ingredientAmount = buffer.m_130242_();
            int materialAmount = buffer.m_130242_();
            ItemStack result = buffer.m_130267_();
            return new PlaneWorkbenchRecipe(id, ingredient, ingredientAmount, materialAmount, result);
        }

        public void toNetwork(FriendlyByteBuf buffer, PlaneWorkbenchRecipe recipe) {
            recipe.ingredient.m_43923_(buffer);
            buffer.m_130130_(recipe.ingredientAmount);
            buffer.m_130130_(recipe.materialAmount);
            buffer.m_130055_(recipe.result);
        }
    }
}

