/*
 * Decompiled with CFR 0.152.
 */
package xyz.przemyk.simpleplanes.network;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.network.NetworkEvent;
import xyz.przemyk.simpleplanes.container.PlaneWorkbenchContainer;

public class CycleItemsPacket {
    private final TYPE type;

    public CycleItemsPacket(TYPE type) {
        this.type = type;
    }

    public CycleItemsPacket(FriendlyByteBuf buffer) {
        this.type = TYPE.values()[buffer.readByte()];
    }

    public void toBytes(FriendlyByteBuf buffer) {
        buffer.writeByte(this.type.ordinal());
    }

    public void handle(Supplier<NetworkEvent.Context> ctxSup) {
        NetworkEvent.Context ctx = ctxSup.get();
        ctx.enqueueWork(() -> {
            ServerPlayer sender = ctx.getSender();
            AbstractContainerMenu patt874$temp = sender.f_36096_;
            if (patt874$temp instanceof PlaneWorkbenchContainer) {
                PlaneWorkbenchContainer workbenchContainer = (PlaneWorkbenchContainer)patt874$temp;
                workbenchContainer.cycleItems(this.type);
            }
        });
        ctx.setPacketHandled(true);
    }

    public static enum TYPE {
        CRAFTING_LEFT,
        CRAFTING_RIGHT;

    }
}

