/*
 * Decompiled with CFR 0.152.
 */
package xyz.przemyk.simpleplanes.entities;

import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import xyz.przemyk.simpleplanes.entities.LargePlaneEntity;
import xyz.przemyk.simpleplanes.entities.PlaneEntity;
import xyz.przemyk.simpleplanes.misc.MathUtil;
import xyz.przemyk.simpleplanes.setup.SimplePlanesConfig;
import xyz.przemyk.simpleplanes.setup.SimplePlanesItems;
import xyz.przemyk.simpleplanes.setup.SimplePlanesUpgrades;
import xyz.przemyk.simpleplanes.upgrades.UpgradeType;

public class HelicopterEntity
extends LargePlaneEntity {
    public HelicopterEntity(EntityType<? extends HelicopterEntity> entityTypeIn, Level worldIn) {
        super((EntityType<? extends LargePlaneEntity>)entityTypeIn, worldIn);
    }

    @Override
    protected float getMoveForward(Player player) {
        return player.f_20902_;
    }

    @Override
    protected PlaneEntity.TempMotionVars getMotionVars() {
        PlaneEntity.TempMotionVars motionTempMotionVars = super.getMotionVars();
        motionTempMotionVars.passiveEnginePush = 0.028f;
        motionTempMotionVars.push = 0.05f;
        motionTempMotionVars.dragQuad *= 10.0;
        motionTempMotionVars.dragMul *= 2.0;
        return motionTempMotionVars;
    }

    @Override
    protected void tickMotion(PlaneEntity.TempMotionVars tempMotionVars) {
        super.tickMotion(tempMotionVars);
    }

    @Override
    protected Vector3f getTickPush(PlaneEntity.TempMotionVars tempMotionVars) {
        if (tempMotionVars.moveForward < 0.0f && this.isPowered() && !tempMotionVars.passengerPressingSpace) {
            tempMotionVars.push = (float)((double)tempMotionVars.push * 0.2);
        }
        if (tempMotionVars.moveForward > 0.0f && this.isPowered() && !tempMotionVars.passengerPressingSpace) {
            tempMotionVars.push = (float)((double)tempMotionVars.push * 1.5);
        }
        return this.transformPos(new Vector3f(0.0f, tempMotionVars.push, 0.0f));
    }

    @Override
    protected void tickPitch(PlaneEntity.TempMotionVars tempMotionVars) {
        if (this.getHealth() <= 0) {
            this.m_146926_(-2.0f);
            this.m_20256_(this.m_20184_().m_82520_(0.0, -0.04, 0.0));
        } else if (tempMotionVars.moveForward > 0.0f) {
            this.m_146926_(Math.max(this.m_146909_() - 1.0f, -20.0f));
        } else if (tempMotionVars.moveForward < 0.0f && tempMotionVars.passengerPressingSpace) {
            this.m_146926_(Math.min(this.m_146909_() + 1.0f, 10.0f));
        } else {
            this.m_146926_(MathUtil.lerpAngle(0.2f, this.m_146909_(), 0.0f));
            double drag = 0.999;
            this.m_20256_(this.m_20184_().m_82542_(drag, 1.0, drag));
        }
    }

    @Override
    protected boolean tickOnGround(PlaneEntity.TempMotionVars tempMotionVars) {
        float push = tempMotionVars.push;
        super.tickOnGround(tempMotionVars);
        tempMotionVars.push = tempMotionVars.passengerPressingSpace ? push : 0.0f;
        return false;
    }

    @Override
    protected float getGroundPitch() {
        return 0.0f;
    }

    @Override
    public int getFuelCost() {
        return (Integer)SimplePlanesConfig.HELICOPTER_FUEL_COST.get();
    }

    @Override
    protected Quaternion tickRotateMotion(PlaneEntity.TempMotionVars tempMotionVars, Quaternion q, Vec3 motion) {
        return q;
    }

    @Override
    protected void tickRotation(PlaneEntity.TempMotionVars tempMotionVars) {
        if (this.getHealth() <= 0) {
            this.m_146922_(this.m_146908_() + (this.m_142049_() % 2 == 0 ? 16.0f : -16.0f));
            return;
        }
        int yawDiff = 2;
        if (!tempMotionVars.passengerPressingSpace) {
            float turn = tempMotionVars.moveStrafing > 0.0f ? (float)yawDiff : (tempMotionVars.moveStrafing == 0.0f ? 0.0f : (float)(-yawDiff));
            this.rotationRoll = MathUtil.lerpAngle(0.1f, this.rotationRoll, 0.0f);
            this.m_146922_(this.m_146908_() - turn);
        } else {
            int rollDiff = 15;
            float turn = tempMotionVars.moveStrafing > 0.0f ? (float)rollDiff : (tempMotionVars.moveStrafing == 0.0f ? 0.0f : (float)(-rollDiff));
            this.rotationRoll = MathUtil.lerpAngle(0.1f, this.rotationRoll, turn);
        }
    }

    @Override
    public boolean canAddUpgrade(UpgradeType upgradeType) {
        if (upgradeType == SimplePlanesUpgrades.SOLAR_PANEL.get()) {
            return false;
        }
        return super.canAddUpgrade(upgradeType);
    }

    @Override
    public void m_7332_(Entity passenger) {
        this.positionRiderGeneric(passenger);
        int index = this.m_20197_().indexOf(passenger);
        if (index == 0) {
            Vector3f pos = this.transformPos(new Vector3f(0.0f, (float)(this.m_6048_() + passenger.m_6049_()), 0.5f));
            passenger.m_6034_(this.m_20185_() + (double)pos.m_122239_(), this.m_20186_() + (double)pos.m_122260_(), this.m_20189_() + (double)pos.m_122269_());
        } else {
            if (this.hasLargeUpgrade) {
                ++index;
            }
            switch (index) {
                case 1: {
                    Vector3f pos = this.transformPos(new Vector3f(0.0f, (float)(this.m_6048_() + this.getEntityYOffset(passenger)), -0.5f));
                    passenger.m_6034_(this.m_20185_() + (double)pos.m_122239_(), this.m_20186_() + (double)pos.m_122260_(), this.m_20189_() + (double)pos.m_122269_());
                    break;
                }
                case 2: {
                    Vector3f pos = this.transformPos(new Vector3f(-1.0f, (float)(this.m_6048_() + passenger.m_6049_() - (double)0.4f), 0.0f));
                    passenger.m_6034_(this.m_20185_() + (double)pos.m_122239_(), this.m_20186_() + (double)pos.m_122260_(), this.m_20189_() + (double)pos.m_122269_());
                    break;
                }
                case 3: {
                    Vector3f pos = this.transformPos(new Vector3f(1.0f, (float)(this.m_6048_() + passenger.m_6049_()) - 0.4f, 0.0f));
                    passenger.m_6034_(this.m_20185_() + (double)pos.m_122239_(), this.m_20186_() + (double)pos.m_122260_(), this.m_20189_() + (double)pos.m_122269_());
                }
            }
        }
    }

    @Override
    public double getEntityYOffset(Entity passenger) {
        if (passenger instanceof Villager) {
            return ((Villager)passenger).m_6162_() ? -0.1 : -0.35;
        }
        return passenger.m_6049_();
    }

    @Override
    protected Item getItem() {
        return (Item)SimplePlanesItems.HELICOPTER_ITEM.get();
    }
}

