/*
 * Decompiled with CFR 0.152.
 */
package xyz.przemyk.simpleplanes.compat.jei;

import com.google.common.collect.Streams;
import java.util.Arrays;
import java.util.stream.Stream;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import xyz.przemyk.simpleplanes.blocks.PlaneWorkbenchBlock;
import xyz.przemyk.simpleplanes.container.PlaneWorkbenchContainer;
import xyz.przemyk.simpleplanes.recipes.PlaneWorkbenchRecipe;
import xyz.przemyk.simpleplanes.setup.SimplePlanesBlocks;
import xyz.przemyk.simpleplanes.setup.SimplePlanesItems;

public class PlaneWorkbenchRecipeCategory
implements IRecipeCategory<PlaneWorkbenchRecipe> {
    public static final ResourceLocation ID = new ResourceLocation("simpleplanes", "plane_workbench");
    private final IDrawable background;
    private final IDrawable icon;

    public PlaneWorkbenchRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(new ResourceLocation("jei", "textures/gui/gui_vanilla.png"), 0, 168, 125, 18);
        this.icon = guiHelper.createDrawableIngredient(VanillaTypes.ITEM, (Object)new ItemStack((ItemLike)SimplePlanesItems.PLANE_WORKBENCH.get()));
    }

    public ResourceLocation getUid() {
        return ID;
    }

    public Class<? extends PlaneWorkbenchRecipe> getRecipeClass() {
        return PlaneWorkbenchRecipe.class;
    }

    public Component getTitle() {
        return ((PlaneWorkbenchBlock)((Object)SimplePlanesBlocks.PLANE_WORKBENCH_BLOCK.get())).m_49954_();
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, PlaneWorkbenchRecipe recipe, IFocusGroup focuses) {
        Stream<ItemStack> materialStackStream = Streams.stream((Iterable)Registry.f_122824_.m_206058_(PlaneWorkbenchContainer.PLANE_MATERIALS_TAG)).map(blockHolder -> new ItemStack((ItemLike)blockHolder.m_203334_(), recipe.materialAmount()));
        builder.addSlot(RecipeIngredientRole.INPUT, 1, 1).addIngredients(Ingredient.m_43921_(Arrays.stream(recipe.ingredient().m_43908_()).map(itemStack -> new ItemStack((ItemLike)itemStack.m_41720_(), recipe.ingredientAmount()))));
        builder.addSlot(RecipeIngredientRole.INPUT, 50, 1).addIngredients(Ingredient.m_43921_(materialStackStream));
        builder.addSlot(RecipeIngredientRole.OUTPUT, 108, 1).addItemStack(recipe.result());
    }
}

