/*
 * Decompiled with CFR 0.152.
 */
package xyz.przemyk.simpleplanes.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.model.ForgeModelBakery;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import xyz.przemyk.simpleplanes.entities.PlaneEntity;
import xyz.przemyk.simpleplanes.misc.MathUtil;
import xyz.przemyk.simpleplanes.setup.SimplePlanesEntities;
import xyz.przemyk.simpleplanes.upgrades.Upgrade;

public class PlaneRenderer<T extends PlaneEntity>
extends EntityRenderer<T> {
    public static final int TICKS_PER_PROPELLER_ROTATION = 4;
    protected final EntityModel<PlaneEntity> propellerModel;
    protected final EntityModel<T> planeEntityModel;
    protected final EntityModel<PlaneEntity> planeMetalModel;
    protected final ResourceLocation metalTexture;
    protected final ResourceLocation propellerTexture;
    public static final Map<Block, ResourceLocation> cachedTextures = new HashMap<Block, ResourceLocation>();
    public static final ResourceLocation FALLBACK_TEXTURE = new ResourceLocation("minecraft", "textures/block/oak_planks.png");

    public PlaneRenderer(EntityRendererProvider.Context context, EntityModel<T> planeModel, EntityModel<PlaneEntity> planeMetalModel, EntityModel<PlaneEntity> propellerModel, float shadowSize, ResourceLocation metalTexture, ResourceLocation propellerTexture) {
        super(context);
        this.propellerModel = propellerModel;
        this.planeEntityModel = planeModel;
        this.planeMetalModel = planeMetalModel;
        this.metalTexture = metalTexture;
        this.propellerTexture = propellerTexture;
        this.f_114477_ = shadowSize;
    }

    public static float getPropellerRotation(PlaneEntity entity, float partialTicks) {
        return ((float)entity.f_19797_ + partialTicks) % 4.0f / 1.2566371f;
    }

    public void render(T planeEntity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        boolean isPlayerRidingInFirstPersonView;
        poseStack.m_85836_();
        poseStack.m_85837_(0.0, 0.375, 0.0);
        poseStack.m_85841_(-1.0f, -1.0f, 1.0f);
        poseStack.m_85845_(Vector3f.f_122225_.m_122240_(180.0f));
        double firstPersonYOffset = -0.7;
        boolean bl = isPlayerRidingInFirstPersonView = Minecraft.m_91087_().f_91074_ != null && planeEntity.m_20363_((Entity)Minecraft.m_91087_().f_91074_) && Minecraft.m_91087_().f_91066_.f_92111_ == CameraType.FIRST_PERSON;
        if (isPlayerRidingInFirstPersonView) {
            poseStack.m_85837_(0.0, firstPersonYOffset, 0.0);
        }
        Quaternion q = MathUtil.lerpQ(partialTicks, ((PlaneEntity)((Object)planeEntity)).getQ_Prev(), ((PlaneEntity)((Object)planeEntity)).getQ_Client());
        poseStack.m_85845_(q);
        EntityType entityType = planeEntity.m_6095_();
        if (entityType == SimplePlanesEntities.PLANE.get()) {
            poseStack.m_85837_(0.0, -0.5, -0.5);
        } else if (entityType == SimplePlanesEntities.LARGE_PLANE.get()) {
            poseStack.m_85837_(0.0, -0.3, -1.0);
        } else {
            poseStack.m_85837_(0.0, 0.0, 0.9);
        }
        float rockingAngle = ((PlaneEntity)((Object)planeEntity)).getRockingAngle(partialTicks);
        if (!Mth.m_14033_((float)rockingAngle, (float)0.0f)) {
            poseStack.m_85845_(new Quaternion(new Vector3f(1.0f, 0.0f, 1.0f), rockingAngle, true));
        }
        float f = (float)((PlaneEntity)((Object)planeEntity)).getTimeSinceHit() - partialTicks;
        float f1 = ((PlaneEntity)((Object)planeEntity)).getDamageTaken() - partialTicks;
        if (f1 < 0.1f) {
            f1 = 0.1f;
        }
        if (f > 0.0f) {
            float angle = Mth.m_14036_((float)(f * f1 / 200.0f), (float)-30.0f, (float)30.0f);
            f = (float)((PlaneEntity)((Object)planeEntity)).f_19797_ + partialTicks;
            poseStack.m_85845_(Vector3f.f_122227_.m_122240_(Mth.m_14031_((float)f) * angle));
        }
        poseStack.m_85837_(0.0, -1.1, 0.0);
        if (isPlayerRidingInFirstPersonView) {
            poseStack.m_85837_(0.0, -firstPersonYOffset, 0.0);
        }
        VertexConsumer vertexConsumer = buffer.m_6299_(this.planeEntityModel.m_103119_(PlaneRenderer.getMaterialTexture(planeEntity)));
        this.planeEntityModel.m_6973_(planeEntity, partialTicks, 0.0f, 0.0f, 0.0f, 0.0f);
        this.planeEntityModel.m_7695_(poseStack, vertexConsumer, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        vertexConsumer = buffer.m_6299_(this.planeMetalModel.m_103119_(this.metalTexture));
        this.planeMetalModel.m_6973_(planeEntity, partialTicks, 0.0f, 0.0f, 0.0f, 0.0f);
        this.planeMetalModel.m_7695_(poseStack, vertexConsumer, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        for (Upgrade upgrade : ((PlaneEntity)((Object)planeEntity)).upgrades.values()) {
            upgrade.render(poseStack, buffer, packedLight, partialTicks);
        }
        vertexConsumer = ItemRenderer.m_115184_((MultiBufferSource)buffer, (RenderType)this.planeEntityModel.m_103119_(this.propellerTexture), (boolean)false, (boolean)planeEntity.m_20068_());
        this.propellerModel.m_6973_(planeEntity, partialTicks, 0.0f, 0.0f, 0.0f, 0.0f);
        this.propellerModel.m_7695_(poseStack, vertexConsumer, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        poseStack.m_85836_();
        poseStack.m_85849_();
        poseStack.m_85849_();
        super.m_7392_(planeEntity, 0.0f, partialTicks, poseStack, buffer, packedLight);
    }

    public ResourceLocation getTextureLocation(PlaneEntity entity) {
        return PlaneRenderer.getMaterialTexture(entity);
    }

    public static ResourceLocation getMaterialTexture(PlaneEntity entity) {
        ResourceLocation texture;
        Block block = entity.getMaterial();
        if (cachedTextures.containsKey(block)) {
            return cachedTextures.get(block);
        }
        try {
            ResourceLocation sprite = ((BakedQuad)Minecraft.m_91087_().m_91304_().m_119422_(ForgeModelBakery.getInventoryVariant((String)Objects.requireNonNull(block.getRegistryName()).toString())).getQuads(null, Direction.SOUTH, new Random(42L), (IModelData)EmptyModelData.INSTANCE).get(0)).m_173410_().m_118413_();
            texture = new ResourceLocation(sprite.m_135827_(), "textures/" + sprite.m_135815_() + ".png");
        }
        catch (IndexOutOfBoundsException | NullPointerException exception) {
            texture = FALLBACK_TEXTURE;
        }
        cachedTextures.put(block, texture);
        return texture;
    }
}

