/*
 * Decompiled with CFR 0.152.
 */
package xyz.przemyk.simpleplanes.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import net.minecraft.client.Camera;
import net.minecraft.client.CameraType;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.item.ItemColors;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.ClientRegistry;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.client.event.ScreenOpenEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.gui.ForgeIngameGui;
import net.minecraftforge.client.gui.OverlayRegistry;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import xyz.przemyk.simpleplanes.capability.CapClientConfigProvider;
import xyz.przemyk.simpleplanes.client.gui.ElectricEngineScreen;
import xyz.przemyk.simpleplanes.client.gui.FurnaceEngineScreen;
import xyz.przemyk.simpleplanes.client.gui.PlaneWorkbenchScreen;
import xyz.przemyk.simpleplanes.client.gui.RemoveUpgradesScreen;
import xyz.przemyk.simpleplanes.client.gui.StorageScreen;
import xyz.przemyk.simpleplanes.client.render.PlaneItemColors;
import xyz.przemyk.simpleplanes.entities.LargePlaneEntity;
import xyz.przemyk.simpleplanes.entities.PlaneEntity;
import xyz.przemyk.simpleplanes.misc.MathUtil;
import xyz.przemyk.simpleplanes.network.BoostPacket;
import xyz.przemyk.simpleplanes.network.ClientConfigPacket;
import xyz.przemyk.simpleplanes.network.DropPayloadPacket;
import xyz.przemyk.simpleplanes.network.OpenEngineInventoryPacket;
import xyz.przemyk.simpleplanes.network.OpenInventoryPacket;
import xyz.przemyk.simpleplanes.network.SimplePlanesNetworking;
import xyz.przemyk.simpleplanes.setup.SimplePlanesConfig;
import xyz.przemyk.simpleplanes.setup.SimplePlanesContainers;
import xyz.przemyk.simpleplanes.setup.SimplePlanesItems;
import xyz.przemyk.simpleplanes.upgrades.Upgrade;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class ClientEventHandler {
    public static final ResourceLocation HUD_TEXTURE = new ResourceLocation("simpleplanes", "textures/gui/plane_hud.png");
    public static KeyMapping boostKey;
    public static KeyMapping openEngineInventoryKey;
    public static KeyMapping dropPayloadKey;
    private static boolean playerRotationNeedToPop;
    private static boolean oldBoostState;

    public static void clientSetup() {
        boostKey = new KeyMapping("key.plane_boost.desc", 32, "key.simpleplanes.category");
        openEngineInventoryKey = new KeyMapping("key.plane_engine_open.desc", 88, "key.simpleplanes.category");
        dropPayloadKey = new KeyMapping("key.plane_drop_payload.desc", 67, "key.simpleplanes.category");
        ClientRegistry.registerKeyBinding((KeyMapping)boostKey);
        ClientRegistry.registerKeyBinding((KeyMapping)openEngineInventoryKey);
        ClientRegistry.registerKeyBinding((KeyMapping)dropPayloadKey);
        MenuScreens.m_96206_((MenuType)((MenuType)SimplePlanesContainers.PLANE_WORKBENCH.get()), PlaneWorkbenchScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)SimplePlanesContainers.UPGRADES_REMOVAL.get()), RemoveUpgradesScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)SimplePlanesContainers.STORAGE.get()), StorageScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)SimplePlanesContainers.FURNACE_ENGINE.get()), FurnaceEngineScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)SimplePlanesContainers.ELECTRIC_ENGINE.get()), ElectricEngineScreen::new);
        OverlayRegistry.registerOverlayTop((String)"Plane HUD", (gui, matrixStack, partialTicks, screenWidth, screenHeight) -> {
            Minecraft mc = Minecraft.m_91087_();
            Gui patt4131$temp = mc.f_91065_;
            if (patt4131$temp instanceof ForgeIngameGui) {
                ForgeIngameGui forgeIngameGui = (ForgeIngameGui)patt4131$temp;
                int scaledWidth = mc.m_91268_().m_85445_();
                int scaledHeight = mc.m_91268_().m_85446_();
                Entity patt4361$temp = mc.f_91074_.m_20202_();
                if (patt4361$temp instanceof PlaneEntity) {
                    PlaneEntity planeEntity = (PlaneEntity)patt4361$temp;
                    RenderSystem.m_157427_(GameRenderer::m_172817_);
                    RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    RenderSystem.m_157456_((int)0, (ResourceLocation)HUD_TEXTURE);
                    int left_align = scaledWidth / 2 + 91;
                    int health = (int)Math.ceil(planeEntity.getHealth());
                    float healthMax = planeEntity.getMaxHealth();
                    int hearts = (int)healthMax;
                    if (hearts > 10) {
                        hearts = 10;
                    }
                    boolean FULL = false;
                    int EMPTY = 16;
                    int GOLD = 32;
                    int max_row_size = 5;
                    int heart = 0;
                    while (hearts > 0) {
                        int top = scaledHeight - forgeIngameGui.right_height;
                        int rowCount = Math.min(hearts, max_row_size);
                        hearts -= rowCount;
                        for (int i = 0; i < rowCount; ++i) {
                            int x = left_align - i * 16 - 16;
                            int vOffset = 35;
                            if (i + heart + 10 < health) {
                                ClientEventHandler.blit(matrixStack, 0, x, top, 32, vOffset, 16, 9);
                                continue;
                            }
                            if (i + heart < health) {
                                ClientEventHandler.blit(matrixStack, 0, x, top, 0, vOffset, 16, 9);
                                continue;
                            }
                            ClientEventHandler.blit(matrixStack, 0, x, top, 16, vOffset, 16, 9);
                        }
                        forgeIngameGui.right_height += 10;
                        heart += max_row_size;
                    }
                    if (planeEntity.engineUpgrade != null) {
                        ItemStack offhandStack = mc.f_91074_.m_21206_();
                        HumanoidArm primaryHand = mc.f_91074_.m_5737_();
                        planeEntity.engineUpgrade.renderPowerHUD(matrixStack, primaryHand == HumanoidArm.LEFT || offhandStack.m_41619_() ? HumanoidArm.LEFT : HumanoidArm.RIGHT, scaledWidth, scaledHeight, partialTicks);
                    }
                }
            }
        });
    }

    public static void planeColor(ColorHandlerEvent.Item event) {
        ItemColors itemColors = event.getItemColors();
        SimplePlanesItems.getPlaneItems().forEach(item -> itemColors.m_92689_(PlaneItemColors::getColor, new ItemLike[]{item}));
    }

    public static void reloadTextures(TextureStitchEvent.Post event) {
        PlaneItemColors.clearCache();
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onRenderPre(RenderLivingEvent.Pre<LivingEntity, ?> event) {
        LivingEntity livingEntity = event.getEntity();
        Entity entity = livingEntity.m_20201_();
        if (entity instanceof PlaneEntity) {
            boolean isPlayerRidingInFirstPersonView;
            PlaneEntity planeEntity = (PlaneEntity)entity;
            PoseStack matrixStack = event.getPoseStack();
            matrixStack.m_85836_();
            playerRotationNeedToPop = true;
            double firstPersonYOffset = 0.7;
            boolean bl = isPlayerRidingInFirstPersonView = Minecraft.m_91087_().f_91074_ != null && planeEntity.m_20363_((Entity)Minecraft.m_91087_().f_91074_) && Minecraft.m_91087_().f_91066_.f_92111_ == CameraType.FIRST_PERSON;
            if (isPlayerRidingInFirstPersonView) {
                matrixStack.m_85837_(0.0, firstPersonYOffset, 0.0);
            }
            matrixStack.m_85837_(0.0, 0.35, 0.0);
            Quaternion quaternion = MathUtil.lerpQ(event.getPartialTick(), planeEntity.getQ_Prev(), planeEntity.getQ_Client());
            quaternion.m_80143_(quaternion.m_80140_(), -quaternion.m_80150_(), -quaternion.m_80153_(), quaternion.m_80156_());
            matrixStack.m_85845_(quaternion);
            float rotationYaw = MathUtil.lerpAngle(event.getPartialTick(), entity.f_19859_, entity.m_146908_());
            matrixStack.m_85845_(Vector3f.f_122225_.m_122240_(rotationYaw));
            matrixStack.m_85837_(0.0, -0.35, 0.0);
            if (isPlayerRidingInFirstPersonView) {
                matrixStack.m_85837_(0.0, -firstPersonYOffset, 0.0);
            }
            if (MathUtil.degreesDifferenceAbs(planeEntity.rotationRoll, 0.0) > 90.0) {
                livingEntity.f_20885_ = planeEntity.m_146908_() * 2.0f - livingEntity.f_20885_;
            }
            if (MathUtil.degreesDifferenceAbs(planeEntity.prevRotationRoll, 0.0) > 90.0) {
                livingEntity.f_20886_ = planeEntity.f_19859_ * 2.0f - livingEntity.f_20886_;
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onRenderPost(RenderLivingEvent.Post event) {
        if (playerRotationNeedToPop) {
            playerRotationNeedToPop = false;
            event.getPoseStack().m_85849_();
            Entity entity = event.getEntity().m_20201_();
            PlaneEntity planeEntity = (PlaneEntity)entity;
            if (MathUtil.degreesDifferenceAbs(planeEntity.rotationRoll, 0.0) > 90.0) {
                event.getEntity().f_20885_ = planeEntity.m_146908_() * 2.0f - event.getEntity().f_20885_;
            }
            if (MathUtil.degreesDifferenceAbs(planeEntity.prevRotationRoll, 0.0) > 90.0) {
                event.getEntity().f_20886_ = planeEntity.f_19859_ * 2.0f - event.getEntity().f_20886_;
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onClientPlayerTick(TickEvent.PlayerTickEvent event) {
        Player player = event.player;
        if (event.phase == TickEvent.Phase.END && player instanceof LocalPlayer) {
            Entity entity = player.m_20202_();
            if (entity instanceof PlaneEntity) {
                PlaneEntity planeEntity = (PlaneEntity)entity;
                Minecraft mc = Minecraft.m_91087_();
                if (mc.f_91066_.f_92111_ == CameraType.FIRST_PERSON) {
                    float yawDiff = planeEntity.m_146908_() - planeEntity.f_19859_;
                    player.m_146922_(player.m_146908_() + yawDiff);
                    float relativePlayerYaw = Mth.m_14177_((float)(player.m_146908_() - planeEntity.m_146908_()));
                    float clampedRelativePlayerYaw = Mth.m_14036_((float)relativePlayerYaw, (float)-105.0f, (float)105.0f);
                    float diff = clampedRelativePlayerYaw - relativePlayerYaw;
                    player.f_19859_ += diff;
                    player.m_146922_(player.m_146908_() + diff);
                    player.m_5616_(player.m_146908_());
                    relativePlayerYaw = Mth.m_14177_((float)(player.m_146909_() - 0.0f));
                    clampedRelativePlayerYaw = Mth.m_14036_((float)relativePlayerYaw, (float)-50.0f, (float)50.0f);
                    float perc = (clampedRelativePlayerYaw - relativePlayerYaw) * 0.5f;
                    player.f_19860_ += perc;
                    player.m_146926_(player.m_146909_() + perc);
                } else {
                    planeEntity.applyYawToEntity((Entity)player);
                }
                if (planeEntity.engineUpgrade != null && mc.f_91080_ == null && mc.m_91265_() == null && openEngineInventoryKey.m_90859_() && planeEntity.engineUpgrade.canOpenGui()) {
                    SimplePlanesNetworking.INSTANCE.sendToServer((Object)new OpenEngineInventoryPacket());
                } else if (dropPayloadKey.m_90859_()) {
                    for (Upgrade upgrade : planeEntity.upgrades.values()) {
                        if (!upgrade.canBeDroppedAsPayload()) continue;
                        upgrade.dropAsPayload();
                        SimplePlanesNetworking.INSTANCE.sendToServer((Object)new DropPayloadPacket());
                        break;
                    }
                }
                boolean isBoosting = boostKey.m_90857_();
                if (isBoosting != oldBoostState || Math.random() < 0.1) {
                    SimplePlanesNetworking.INSTANCE.sendToServer((Object)new BoostPacket(isBoosting));
                }
                oldBoostState = isBoosting;
            } else {
                oldBoostState = false;
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onCameraSetup(EntityViewRenderEvent.CameraSetup event) {
        Camera camera = event.getCamera();
        Entity entity = camera.m_90592_();
        if (entity instanceof LocalPlayer) {
            LocalPlayer playerEntity = (LocalPlayer)entity;
            Entity entity2 = entity.m_20202_();
            if (entity2 instanceof PlaneEntity) {
                PlaneEntity planeEntity = (PlaneEntity)entity2;
                if (camera.m_90594_()) {
                    camera.m_90568_(-camera.m_90566_(4.0 * (planeEntity.getCameraDistanceMultiplayer() - 1.0)), 0.0, 0.0);
                } else {
                    double partialTicks = event.getPartialTicks();
                    Quaternion q_prev = planeEntity.getQ_Prev();
                    int max = 105;
                    float diff = (float)Mth.m_14008_((double)MathUtil.wrapSubtractDegrees(planeEntity.f_19859_, playerEntity.f_19859_), (double)(-max), (double)max);
                    float pitch = Mth.m_14036_((float)event.getPitch(), (float)-45.0f, (float)45.0f);
                    q_prev.m_80148_(Vector3f.f_122225_.m_122240_(diff));
                    q_prev.m_80148_(Vector3f.f_122223_.m_122240_(pitch));
                    MathUtil.EulerAngles angles_prev = MathUtil.toEulerAngles(q_prev);
                    Quaternion q_client = planeEntity.getQ_Client();
                    diff = (float)Mth.m_14008_((double)MathUtil.wrapSubtractDegrees(planeEntity.m_146908_(), playerEntity.m_146908_()), (double)(-max), (double)max);
                    q_client.m_80148_(Vector3f.f_122225_.m_122240_(diff));
                    q_client.m_80148_(Vector3f.f_122223_.m_122240_(pitch));
                    MathUtil.EulerAngles angles = MathUtil.toEulerAngles(q_client);
                    event.setPitch(-((float)MathUtil.lerpAngle180(partialTicks, angles_prev.pitch, angles.pitch)));
                    event.setYaw((float)MathUtil.lerpAngle(partialTicks, angles_prev.yaw, angles.yaw));
                    event.setRoll(-((float)MathUtil.lerpAngle(partialTicks, angles_prev.roll, angles.roll)));
                }
            }
        }
    }

    public static void renderHotbarItem(PoseStack matrixStack, int x, int y, float partialTicks, ItemStack stack, Minecraft mc) {
        ItemRenderer itemRenderer = mc.m_91291_();
        if (!stack.m_41619_()) {
            float f = (float)stack.m_41779_() - partialTicks;
            if (f > 0.0f) {
                matrixStack.m_85836_();
                float f1 = 1.0f + f / 5.0f;
                matrixStack.m_85837_((double)(x + 8), (double)(y + 12), 0.0);
                matrixStack.m_85841_(1.0f / f1, (f1 + 1.0f) / 2.0f, 1.0f);
                matrixStack.m_85837_((double)(-(x + 8)), (double)(-(y + 12)), 0.0);
            }
            itemRenderer.m_115203_(stack, x, y);
            if (f > 0.0f) {
                matrixStack.m_85849_();
            }
            itemRenderer.m_115169_(mc.f_91062_, stack, x, y);
        }
    }

    public static void blit(PoseStack matrixStack, int blitOffset, int x, int y, int uOffset, int vOffset, int uWidth, int vHeight) {
        GuiComponent.m_93143_((PoseStack)matrixStack, (int)x, (int)y, (int)blitOffset, (float)uOffset, (float)vOffset, (int)uWidth, (int)vHeight, (int)256, (int)256);
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void planeInventory(ScreenOpenEvent event) {
        LargePlaneEntity largePlaneEntity;
        Entity entity;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (event.getScreen() instanceof InventoryScreen && (entity = player.m_20202_()) instanceof LargePlaneEntity && (largePlaneEntity = (LargePlaneEntity)entity).hasStorageUpgrade()) {
            event.setCanceled(true);
            SimplePlanesNetworking.INSTANCE.sendToServer((Object)new OpenInventoryPacket());
        }
    }

    @SubscribeEvent
    public static void onPlayerLogin(ClientPlayerNetworkEvent.LoggedInEvent event) {
        SimplePlanesNetworking.INSTANCE.sendToServer((Object)new ClientConfigPacket((Boolean)SimplePlanesConfig.INVERTED_CONTROLS.get()));
        LocalPlayer player = event.getPlayer();
        if (player != null) {
            player.getCapability(CapClientConfigProvider.CLIENT_CONFIG_CAP).ifPresent(cap -> {
                cap.invertedControls = (Boolean)SimplePlanesConfig.INVERTED_CONTROLS.get();
            });
        }
    }

    static {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(ClientEventHandler::planeColor);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(ClientEventHandler::reloadTextures);
        playerRotationNeedToPop = false;
        oldBoostState = false;
    }
}

