/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.core.source;

import com.google.common.collect.Lists;
import com.jozufozu.flywheel.core.source.Index;
import com.jozufozu.flywheel.core.source.SourceFile;
import com.jozufozu.flywheel.core.source.SourceFinder;
import com.jozufozu.flywheel.util.ResourceUtil;
import com.jozufozu.flywheel.util.StringUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;

public class ShaderSources
implements SourceFinder {
    public static final String SHADER_DIR = "flywheel/shaders/";
    public static final ArrayList<String> EXTENSIONS = Lists.newArrayList((Object[])new String[]{".vert", ".vsh", ".frag", ".fsh", ".glsl"});
    private final Map<ResourceLocation, SourceFile> shaderSources = new HashMap<ResourceLocation, SourceFile>();
    public final Index index;

    public ShaderSources(ResourceManager manager) {
        Collection allShaders = manager.m_6540_(SHADER_DIR, s -> {
            for (String ext : EXTENSIONS) {
                if (!s.endsWith(ext)) continue;
                return true;
            }
            return false;
        });
        for (ResourceLocation location : allShaders) {
            try {
                Resource resource = manager.m_142591_(location);
                try {
                    String source = StringUtil.readToString(resource.m_6679_());
                    ResourceLocation name = ResourceUtil.removePrefixUnchecked(location, SHADER_DIR);
                    this.shaderSources.put(name, new SourceFile(this, name, source));
                }
                finally {
                    if (resource == null) continue;
                    resource.close();
                }
            }
            catch (IOException iOException) {}
        }
        this.index = new Index(this.shaderSources);
    }

    @Override
    @Nullable
    public SourceFile findSource(ResourceLocation name) {
        return this.shaderSources.get(name);
    }
}

