/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.core.model;

import com.jozufozu.flywheel.Flywheel;
import com.jozufozu.flywheel.core.model.BakedModelBuilder;
import com.jozufozu.flywheel.core.model.Bufferable;
import com.jozufozu.flywheel.core.model.ShadeSeparatedBufferBuilder;
import com.jozufozu.flywheel.core.model.ShadeSeparatingVertexConsumer;
import com.jozufozu.flywheel.core.model.WorldModelBuilder;
import com.jozufozu.flywheel.util.transform.TransformStack;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;

public class ModelUtil {
    public static final BlockRenderDispatcher VANILLA_RENDERER = ModelUtil.createVanillaRenderer();
    private static final ThreadLocal<ThreadLocalObjects> THREAD_LOCAL_OBJECTS = ThreadLocal.withInitial(ThreadLocalObjects::new);

    private static BlockRenderDispatcher createVanillaRenderer() {
        BlockRenderDispatcher defaultDispatcher = Minecraft.m_91087_().m_91289_();
        BlockRenderDispatcher dispatcher = new BlockRenderDispatcher(null, null, null);
        try {
            for (Field field : BlockRenderDispatcher.class.getDeclaredFields()) {
                field.setAccessible(true);
                field.set(dispatcher, field.get(defaultDispatcher));
            }
            ObfuscationReflectionHelper.setPrivateValue(BlockRenderDispatcher.class, (Object)dispatcher, (Object)new ModelBlockRenderer(Minecraft.m_91087_().m_91298_()), (String)"f_110900_");
        }
        catch (Exception e) {
            Flywheel.LOGGER.error("Failed to initialize vanilla BlockRenderDispatcher!", (Throwable)e);
            return defaultDispatcher;
        }
        return dispatcher;
    }

    public static ShadeSeparatedBufferBuilder getBufferBuilder(Bufferable bufferable) {
        ModelBlockRenderer blockRenderer = VANILLA_RENDERER.m_110937_();
        ThreadLocalObjects objects = THREAD_LOCAL_OBJECTS.get();
        objects.begin();
        bufferable.bufferInto(blockRenderer, objects.shadeSeparatingWrapper, objects.random);
        objects.end();
        return objects.separatedBufferBuilder;
    }

    public static ShadeSeparatedBufferBuilder getBufferBuilder(BakedModel model, BlockState referenceState, PoseStack poseStack) {
        return new BakedModelBuilder(model).withReferenceState(referenceState).withPoseStack(poseStack).build();
    }

    public static ShadeSeparatedBufferBuilder getBufferBuilder(BlockAndTintGetter renderWorld, BakedModel model, BlockState referenceState, PoseStack poseStack) {
        return new BakedModelBuilder(model).withReferenceState(referenceState).withPoseStack(poseStack).withRenderWorld(renderWorld).build();
    }

    public static ShadeSeparatedBufferBuilder getBufferBuilderFromTemplate(BlockAndTintGetter renderWorld, RenderType layer, Collection<StructureTemplate.StructureBlockInfo> blocks) {
        return new WorldModelBuilder(layer).withRenderWorld(renderWorld).withBlocks(blocks).build();
    }

    public static ShadeSeparatedBufferBuilder getBufferBuilderFromTemplate(BlockAndTintGetter renderWorld, RenderType layer, Collection<StructureTemplate.StructureBlockInfo> blocks, PoseStack poseStack) {
        return new WorldModelBuilder(layer).withRenderWorld(renderWorld).withBlocks(blocks).withPoseStack(poseStack).build();
    }

    public static Supplier<PoseStack> rotateToFace(Direction facing) {
        return () -> {
            PoseStack stack = new PoseStack();
            ((TransformStack)((TransformStack)TransformStack.cast(stack).centre()).rotateToFace(facing.m_122424_())).unCentre();
            return stack;
        };
    }

    private static class ThreadLocalObjects {
        public final Random random = new Random();
        public final ShadeSeparatingVertexConsumer shadeSeparatingWrapper = new ShadeSeparatingVertexConsumer();
        public final ShadeSeparatedBufferBuilder separatedBufferBuilder = new ShadeSeparatedBufferBuilder(512);
        public final BufferBuilder unshadedBuilder = new BufferBuilder(512);

        private ThreadLocalObjects() {
        }

        private void begin() {
            this.separatedBufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85811_);
            this.unshadedBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85811_);
            this.shadeSeparatingWrapper.prepare((VertexConsumer)this.separatedBufferBuilder, (VertexConsumer)this.unshadedBuilder);
        }

        private void end() {
            this.shadeSeparatingWrapper.clear();
            this.unshadedBuilder.m_85721_();
            this.separatedBufferBuilder.appendUnshadedVertices(this.unshadedBuilder);
            this.separatedBufferBuilder.m_85721_();
        }
    }
}

