/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.backend;

import com.jozufozu.flywheel.backend.Backend;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.function.BooleanSupplier;
import javax.annotation.Nullable;
import net.irisshaders.iris.api.v0.IrisApi;
import net.minecraft.client.Camera;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fml.ModList;

public final class ShadersModHandler {
    public static final String OPTIFINE_ROOT_PACKAGE = "net.optifine";
    public static final String SHADER_PACKAGE = "net.optifine.shaders";
    private static final boolean isOculusLoaded;
    private static final boolean isOptifineInstalled;
    private static final InternalHandler internalHandler;

    private ShadersModHandler() {
    }

    public static void init() {
    }

    public static boolean isOptifineInstalled() {
        return isOptifineInstalled;
    }

    public static boolean isOculusLoaded() {
        return isOculusLoaded;
    }

    public static boolean isShaderPackInUse() {
        return internalHandler.isShaderPackInUse();
    }

    public static boolean isRenderingShadowPass() {
        return internalHandler.isRenderingShadowPass();
    }

    static {
        Package optifinePackage = Package.getPackage(OPTIFINE_ROOT_PACKAGE);
        isOptifineInstalled = optifinePackage != null;
        isOculusLoaded = ModList.get().isLoaded("oculus");
        if (isOptifineInstalled) {
            Backend.LOGGER.info("Optifine detected.");
            internalHandler = new Optifine();
        } else if (isOculusLoaded) {
            Backend.LOGGER.info("Oculus detected.");
            internalHandler = new Oculus();
        } else {
            Backend.LOGGER.info("No shaders mod detected.");
            internalHandler = new InternalHandler(){};
        }
    }

    private static interface InternalHandler {
        default public boolean isShaderPackInUse() {
            return false;
        }

        default public boolean isRenderingShadowPass() {
            return false;
        }
    }

    private static class Optifine
    implements InternalHandler {
        private final BooleanSupplier shadersEnabledSupplier = Optifine.createShadersEnabledSupplier();
        private final BooleanSupplier shadowPassSupplier = Optifine.createShadowPassSupplier();
        private final FrustumConstructor shadowFrustumConstructor = Optifine.createShadowFrustumConstructor();

        Optifine() {
        }

        @Override
        public boolean isShaderPackInUse() {
            return this.shadersEnabledSupplier.getAsBoolean();
        }

        @Override
        public boolean isRenderingShadowPass() {
            return this.shadowPassSupplier.getAsBoolean();
        }

        @Nullable
        public Frustum createShadowFrustum(Camera camera, float partialTicks) {
            Frustum frustum = this.shadowFrustumConstructor.create(camera, partialTicks);
            if (frustum != null) {
                Vec3 position = camera.m_90583_();
                frustum.m_113002_(position.f_82479_, position.f_82480_, position.f_82481_);
            }
            return frustum;
        }

        private static FrustumConstructor createShadowFrustumConstructor() {
            try {
                Class<?> ofShaders = Class.forName("net.optifine.shaders.ShadersRender");
                Method method = ofShaders.getDeclaredMethod("makeShadowFrustum", Camera.class, Float.TYPE);
                method.setAccessible(true);
                return (cam, pt) -> {
                    try {
                        return (Frustum)method.invoke(null, cam, Float.valueOf(pt));
                    }
                    catch (Exception ignored) {
                        return null;
                    }
                };
            }
            catch (Exception ignored) {
                return ($, $$) -> null;
            }
        }

        private static BooleanSupplier createShadowPassSupplier() {
            try {
                Class<?> ofShaders = Class.forName("net.optifine.shaders.Shaders");
                Field field = ofShaders.getDeclaredField("isShadowPass");
                field.setAccessible(true);
                return () -> {
                    try {
                        return field.getBoolean(null);
                    }
                    catch (IllegalAccessException ignored) {
                        return false;
                    }
                };
            }
            catch (Exception ignored) {
                return () -> false;
            }
        }

        private static BooleanSupplier createShadersEnabledSupplier() {
            try {
                Class<?> ofShaders = Class.forName("net.optifine.shaders.Shaders");
                Field field = ofShaders.getDeclaredField("shaderPackLoaded");
                field.setAccessible(true);
                return () -> {
                    try {
                        return field.getBoolean(null);
                    }
                    catch (IllegalAccessException ignored) {
                        return false;
                    }
                };
            }
            catch (Exception ignored) {
                return () -> false;
            }
        }

        @FunctionalInterface
        public static interface FrustumConstructor {
            @Nullable
            public Frustum create(Camera var1, float var2);
        }
    }

    private static class Oculus
    implements InternalHandler {
        private Oculus() {
        }

        @Override
        public boolean isShaderPackInUse() {
            return IrisApi.getInstance().isShaderPackInUse();
        }

        @Override
        public boolean isRenderingShadowPass() {
            return IrisApi.getInstance().isRenderingShadowPass();
        }
    }
}

