/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.util;

import java.util.Random;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BarrelBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraftforge.network.PacketDistributor;
import noobanidus.mods.lootr.api.blockentity.ILootBlockEntity;
import noobanidus.mods.lootr.block.LootrShulkerBlock;
import noobanidus.mods.lootr.block.entities.LootrInventoryBlockEntity;
import noobanidus.mods.lootr.config.ConfigManager;
import noobanidus.mods.lootr.data.DataStorage;
import noobanidus.mods.lootr.data.SpecialChestInventory;
import noobanidus.mods.lootr.entity.LootrChestMinecartEntity;
import noobanidus.mods.lootr.init.ModAdvancements;
import noobanidus.mods.lootr.init.ModStats;
import noobanidus.mods.lootr.network.CloseCart;
import noobanidus.mods.lootr.network.PacketHandler;
import noobanidus.mods.lootr.network.UpdateModelData;

public class ChestUtil {
    public static Random random = new Random();

    public static boolean handleLootSneak(Block block, Level level, BlockPos pos, Player player) {
        if (level.m_5776_()) {
            return false;
        }
        if (player.m_5833_()) {
            return false;
        }
        BlockEntity te = level.m_7702_(pos);
        if (te instanceof ILootBlockEntity) {
            ILootBlockEntity tile = (ILootBlockEntity)te;
            if (tile.getOpeners().remove(player.m_142081_())) {
                te.m_6596_();
                tile.updatePacketViaState();
                UpdateModelData message = new UpdateModelData(te.m_58899_());
                PacketHandler.sendToInternal(message, (ServerPlayer)player);
            }
            return true;
        }
        return false;
    }

    public static void handleLootCartSneak(Level level, LootrChestMinecartEntity cart, Player player) {
        if (level.m_5776_()) {
            return;
        }
        if (player.m_5833_()) {
            return;
        }
        cart.getOpeners().remove(player.m_142081_());
        CloseCart open = new CloseCart(cart.m_142049_());
        PacketHandler.sendInternal(PacketDistributor.TRACKING_ENTITY.with(() -> cart), open);
    }

    public static boolean handleLootChest(Block block, Level level, BlockPos pos, Player player) {
        if (level.m_5776_()) {
            return false;
        }
        if (player.m_5833_()) {
            player.m_5893_(null);
            return false;
        }
        BlockEntity te = level.m_7702_(pos);
        if (te instanceof ILootBlockEntity) {
            ILootBlockEntity tile = (ILootBlockEntity)te;
            UUID tileId = tile.getTileId();
            if (DataStorage.isDecayed(tileId)) {
                level.m_46961_(pos, true);
                player.m_6352_((Component)new TranslatableComponent("lootr.message.decayed").m_6270_(Style.f_131099_.m_131148_(TextColor.m_131270_((ChatFormatting)ChatFormatting.RED)).m_131136_(Boolean.valueOf(true))), Util.f_137441_);
                DataStorage.removeDecayed(tileId);
                return false;
            }
            int decayValue = DataStorage.getDecayValue(tileId);
            if (decayValue > 0) {
                player.m_6352_((Component)new TranslatableComponent("lootr.message.decay_in", new Object[]{decayValue / 20}).m_6270_(Style.f_131099_.m_131148_(TextColor.m_131270_((ChatFormatting)ChatFormatting.RED)).m_131136_(Boolean.valueOf(true))), Util.f_137441_);
            } else if (decayValue == -1 && ConfigManager.isDecaying((ServerLevel)level, (ILootBlockEntity)te)) {
                DataStorage.setDecaying(tileId, (Integer)ConfigManager.DECAY_VALUE.get());
                player.m_6352_((Component)new TranslatableComponent("lootr.message.decay_start", new Object[]{(Integer)ConfigManager.DECAY_VALUE.get() / 20}).m_6270_(Style.f_131099_.m_131148_(TextColor.m_131270_((ChatFormatting)ChatFormatting.RED)).m_131136_(Boolean.valueOf(true))), Util.f_137441_);
            }
            if (block instanceof BarrelBlock) {
                ModAdvancements.BARREL_PREDICATE.trigger((ServerPlayer)player, ((ILootBlockEntity)te).getTileId());
            } else if (block instanceof ChestBlock) {
                ModAdvancements.CHEST_PREDICATE.trigger((ServerPlayer)player, ((ILootBlockEntity)te).getTileId());
            } else if (block instanceof LootrShulkerBlock) {
                ModAdvancements.SHULKER_PREDICATE.trigger((ServerPlayer)player, ((ILootBlockEntity)te).getTileId());
            }
            if (DataStorage.isRefreshed(tileId)) {
                DataStorage.refreshInventory(level, pos, ((ILootBlockEntity)te).getTileId(), (ServerPlayer)player);
                DataStorage.removeRefreshed(tileId);
                player.m_6352_((Component)new TranslatableComponent("lootr.message.refreshed").m_6270_(Style.f_131099_.m_131148_(TextColor.m_131270_((ChatFormatting)ChatFormatting.BLUE)).m_131136_(Boolean.valueOf(true))), Util.f_137441_);
            } else {
                int refreshValue = DataStorage.getRefreshValue(tileId);
                if (refreshValue > 0) {
                    player.m_6352_((Component)new TranslatableComponent("lootr.message.refresh_in", new Object[]{refreshValue / 20}).m_6270_(Style.f_131099_.m_131148_(TextColor.m_131270_((ChatFormatting)ChatFormatting.BLUE)).m_131136_(Boolean.valueOf(true))), Util.f_137441_);
                } else if (refreshValue == -1 && ConfigManager.isRefreshing((ServerLevel)level, (ILootBlockEntity)te)) {
                    DataStorage.setRefreshing(tileId, (Integer)ConfigManager.REFRESH_VALUE.get());
                    player.m_6352_((Component)new TranslatableComponent("lootr.message.refresh_start", new Object[]{(Integer)ConfigManager.REFRESH_VALUE.get() / 20}).m_6270_(Style.f_131099_.m_131148_(TextColor.m_131270_((ChatFormatting)ChatFormatting.BLUE)).m_131136_(Boolean.valueOf(true))), Util.f_137441_);
                }
            }
            SpecialChestInventory provider = DataStorage.getInventory(level, ((ILootBlockEntity)te).getTileId(), pos, (ServerPlayer)player, (RandomizableContainerBlockEntity)te, ((ILootBlockEntity)te)::unpackLootTable);
            if (!DataStorage.isScored(player.m_142081_(), ((ILootBlockEntity)te).getTileId())) {
                player.m_36246_(ModStats.LOOTED_STAT);
                ModAdvancements.SCORE_PREDICATE.trigger((ServerPlayer)player, null);
                DataStorage.score(player.m_142081_(), ((ILootBlockEntity)te).getTileId());
            }
            if (tile.getOpeners().add(player.m_142081_())) {
                te.m_6596_();
                tile.updatePacketViaState();
            }
            player.m_5893_((MenuProvider)provider);
            PiglinAi.m_34873_((Player)player, (boolean)true);
            return true;
        }
        return false;
    }

    public static void handleLootCart(Level level, LootrChestMinecartEntity cart, Player player) {
        if (!level.m_5776_()) {
            if (player.m_5833_()) {
                player.m_5893_(null);
            } else {
                ModAdvancements.CART_PREDICATE.trigger((ServerPlayer)player, cart.m_142081_());
                UUID tileId = cart.m_142081_();
                if (DataStorage.isDecayed(tileId)) {
                    cart.m_7617_(DamageSource.f_19317_);
                    player.m_6352_((Component)new TranslatableComponent("lootr.message.decayed").m_6270_(Style.f_131099_.m_131148_(TextColor.m_131270_((ChatFormatting)ChatFormatting.RED)).m_131136_(Boolean.valueOf(true))), Util.f_137441_);
                    DataStorage.removeDecayed(tileId);
                    return;
                }
                int decayValue = DataStorage.getDecayValue(tileId);
                if (decayValue > 0) {
                    player.m_6352_((Component)new TranslatableComponent("lootr.message.decay_in", new Object[]{decayValue / 20}).m_6270_(Style.f_131099_.m_131148_(TextColor.m_131270_((ChatFormatting)ChatFormatting.RED)).m_131136_(Boolean.valueOf(true))), Util.f_137441_);
                } else if (decayValue == -1 && ConfigManager.isDecaying((ServerLevel)level, cart)) {
                    DataStorage.setDecaying(tileId, (Integer)ConfigManager.DECAY_VALUE.get());
                    player.m_6352_((Component)new TranslatableComponent("lootr.message.decay_start", new Object[]{(Integer)ConfigManager.DECAY_VALUE.get() / 20}).m_6270_(Style.f_131099_.m_131148_(TextColor.m_131270_((ChatFormatting)ChatFormatting.RED)).m_131136_(Boolean.valueOf(true))), Util.f_137441_);
                }
                if (!cart.getOpeners().contains(player.m_142081_())) {
                    cart.addOpener(player);
                }
                if (!DataStorage.isScored(player.m_142081_(), cart.m_142081_())) {
                    player.m_36246_(ModStats.LOOTED_STAT);
                    ModAdvancements.SCORE_PREDICATE.trigger((ServerPlayer)player, null);
                    DataStorage.score(player.m_142081_(), cart.m_142081_());
                }
                if (DataStorage.isRefreshed(tileId)) {
                    DataStorage.refreshInventory(level, cart, (ServerPlayer)player);
                    DataStorage.removeRefreshed(tileId);
                    player.m_6352_((Component)new TranslatableComponent("lootr.message.refreshed").m_6270_(Style.f_131099_.m_131148_(TextColor.m_131270_((ChatFormatting)ChatFormatting.BLUE)).m_131136_(Boolean.valueOf(true))), Util.f_137441_);
                } else {
                    int refreshValue = DataStorage.getRefreshValue(tileId);
                    if (refreshValue > 0) {
                        player.m_6352_((Component)new TranslatableComponent("lootr.message.refresh_in", new Object[]{refreshValue / 20}).m_6270_(Style.f_131099_.m_131148_(TextColor.m_131270_((ChatFormatting)ChatFormatting.BLUE)).m_131136_(Boolean.valueOf(true))), Util.f_137441_);
                    } else if (refreshValue == -1 && ConfigManager.isRefreshing((ServerLevel)level, cart)) {
                        DataStorage.setRefreshing(tileId, (Integer)ConfigManager.REFRESH_VALUE.get());
                        player.m_6352_((Component)new TranslatableComponent("lootr.message.refresh_start", new Object[]{(Integer)ConfigManager.REFRESH_VALUE.get() / 20}).m_6270_(Style.f_131099_.m_131148_(TextColor.m_131270_((ChatFormatting)ChatFormatting.BLUE)).m_131136_(Boolean.valueOf(true))), Util.f_137441_);
                    }
                }
                SpecialChestInventory provider = DataStorage.getInventory(level, cart, (ServerPlayer)player, cart::addLoot);
                player.m_5893_((MenuProvider)provider);
            }
        }
    }

    public static boolean handleLootInventory(Block block, Level level, BlockPos pos, Player player) {
        if (level.m_5776_()) {
            return false;
        }
        if (player.m_5833_()) {
            player.m_5893_(null);
            return false;
        }
        BlockEntity te = level.m_7702_(pos);
        if (te instanceof LootrInventoryBlockEntity) {
            UUID tileId;
            LootrInventoryBlockEntity tile = (LootrInventoryBlockEntity)te;
            ModAdvancements.CHEST_PREDICATE.trigger((ServerPlayer)player, tile.getTileId());
            NonNullList<ItemStack> stacks = null;
            if (tile.getCustomInventory() != null) {
                stacks = ChestUtil.copyItemList(tile.getCustomInventory());
            }
            if (DataStorage.isRefreshed(tileId = tile.getTileId())) {
                DataStorage.refreshInventory(level, pos, ((ILootBlockEntity)te).getTileId(), stacks, (ServerPlayer)player);
                DataStorage.removeRefreshed(tileId);
                player.m_6352_((Component)new TranslatableComponent("lootr.message.refreshed").m_6270_(Style.f_131099_.m_131148_(TextColor.m_131270_((ChatFormatting)ChatFormatting.BLUE)).m_131136_(Boolean.valueOf(true))), Util.f_137441_);
            } else {
                int refreshValue = DataStorage.getRefreshValue(tileId);
                if (refreshValue > 0) {
                    player.m_6352_((Component)new TranslatableComponent("lootr.message.refresh_in", new Object[]{refreshValue / 20}).m_6270_(Style.f_131099_.m_131148_(TextColor.m_131270_((ChatFormatting)ChatFormatting.BLUE)).m_131136_(Boolean.valueOf(true))), Util.f_137441_);
                } else if (refreshValue == -1 && ConfigManager.isRefreshing((ServerLevel)level, tile)) {
                    DataStorage.setRefreshing(tileId, (Integer)ConfigManager.REFRESH_VALUE.get());
                    player.m_6352_((Component)new TranslatableComponent("lootr.message.refresh_start", new Object[]{(Integer)ConfigManager.REFRESH_VALUE.get() / 20}).m_6270_(Style.f_131099_.m_131148_(TextColor.m_131270_((ChatFormatting)ChatFormatting.BLUE)).m_131136_(Boolean.valueOf(true))), Util.f_137441_);
                }
            }
            SpecialChestInventory provider = DataStorage.getInventory(level, tile.getTileId(), stacks, (ServerPlayer)player, pos, (RandomizableContainerBlockEntity)tile);
            if (!DataStorage.isScored(player.m_142081_(), ((ILootBlockEntity)te).getTileId())) {
                player.m_36246_(ModStats.LOOTED_STAT);
                ModAdvancements.SCORE_PREDICATE.trigger((ServerPlayer)player, null);
                DataStorage.score(player.m_142081_(), ((ILootBlockEntity)te).getTileId());
            }
            if (tile.getOpeners().add(player.m_142081_())) {
                te.m_6596_();
                tile.updatePacketViaState();
            }
            player.m_5893_((MenuProvider)provider);
            PiglinAi.m_34873_((Player)player, (boolean)true);
            return true;
        }
        return false;
    }

    public static NonNullList<ItemStack> copyItemList(NonNullList<ItemStack> reference) {
        NonNullList contents = NonNullList.m_122780_((int)reference.size(), (Object)ItemStack.f_41583_);
        for (int i = 0; i < reference.size(); ++i) {
            contents.set(i, (Object)((ItemStack)reference.get(i)).m_41777_());
        }
        return contents;
    }
}

