/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.common.util;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import sonar.fluxnetworks.FluxNetworks;
import sonar.fluxnetworks.api.device.IFluxDevice;
import sonar.fluxnetworks.api.energy.IBlockEnergyBridge;
import sonar.fluxnetworks.api.energy.IItemEnergyBridge;
import sonar.fluxnetworks.common.integration.energy.FNEnergyBridge;
import sonar.fluxnetworks.common.integration.energy.ForgeEnergyBridge;

public final class EnergyUtils {
    private static final Marker MARKER = MarkerManager.getMarker((String)"Energy");
    private static final List<IBlockEnergyBridge> sBlockEnergyBridges = new ArrayList<IBlockEnergyBridge>();
    private static final Set<Block> sBlockBlacklist = new HashSet<Block>();
    private static final List<IItemEnergyBridge> sItemEnergyBridges = new ArrayList<IItemEnergyBridge>();
    private static final Set<Item> sItemBlacklist = new HashSet<Item>();

    private EnergyUtils() {
    }

    public static void reloadBlacklist(@Nonnull List<String> blockBlacklist, @Nonnull List<String> itemBlacklist) {
        sBlockBlacklist.clear();
        for (String s : blockBlacklist) {
            if (s == null || s.isEmpty()) continue;
            try {
                Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(s));
                if (block == null) continue;
                sBlockBlacklist.add(block);
            }
            catch (Exception e) {
                FluxNetworks.LOGGER.warn(MARKER, "Block blacklist error: {} has incorrect formatting", (Object)s, (Object)e);
            }
        }
        sItemBlacklist.clear();
        for (String s : itemBlacklist) {
            if (s == null || s.isEmpty()) continue;
            try {
                Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(s));
                if (item == null) continue;
                sItemBlacklist.add(item);
            }
            catch (Exception e) {
                FluxNetworks.LOGGER.warn(MARKER, "Item blacklist error: {} has incorrect formatting", (Object)s, (Object)e);
            }
        }
        FluxNetworks.LOGGER.info(MARKER, "Energy blacklist loaded: {} block entries, {} item entries", (Object)sBlockBlacklist.size(), (Object)sItemBlacklist.size());
    }

    @Nullable
    public static IBlockEnergyBridge getBridge(@Nullable BlockEntity target, @Nonnull Direction side) {
        if (target == null) {
            return null;
        }
        if (target.m_58901_()) {
            return null;
        }
        if (target instanceof IFluxDevice) {
            return null;
        }
        if (sBlockBlacklist.contains(target.m_58900_().m_60734_())) {
            return null;
        }
        for (IBlockEnergyBridge bridge : sBlockEnergyBridges) {
            if (!bridge.hasCapability(target, side)) continue;
            return bridge;
        }
        return null;
    }

    @Nullable
    public static IItemEnergyBridge getBridge(@Nullable ItemStack stack) {
        if (stack == null) {
            return null;
        }
        if (stack.m_41619_()) {
            return null;
        }
        if (sItemBlacklist.contains(stack.m_41720_())) {
            return null;
        }
        for (IItemEnergyBridge bridge : sItemEnergyBridges) {
            if (!bridge.hasCapability(stack)) continue;
            return bridge;
        }
        return null;
    }

    static {
        sBlockEnergyBridges.add(FNEnergyBridge.INSTANCE);
        sItemEnergyBridges.add(FNEnergyBridge.INSTANCE);
        sBlockEnergyBridges.add(ForgeEnergyBridge.INSTANCE);
        sItemEnergyBridges.add(ForgeEnergyBridge.INSTANCE);
    }
}

