/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.client.mui;

import icyllis.modernui.animation.LayoutTransition;
import icyllis.modernui.fragment.Fragment;
import icyllis.modernui.graphics.Canvas;
import icyllis.modernui.graphics.Paint;
import icyllis.modernui.graphics.drawable.Drawable;
import icyllis.modernui.lifecycle.LifecycleOwner;
import icyllis.modernui.math.Rect;
import icyllis.modernui.text.Editable;
import icyllis.modernui.text.InputFilter;
import icyllis.modernui.text.TextWatcher;
import icyllis.modernui.text.method.PasswordTransformationMethod;
import icyllis.modernui.text.method.TransformationMethod;
import icyllis.modernui.util.DataSet;
import icyllis.modernui.view.View;
import icyllis.modernui.view.ViewGroup;
import icyllis.modernui.widget.AdapterView;
import icyllis.modernui.widget.Button;
import icyllis.modernui.widget.EditText;
import icyllis.modernui.widget.FrameLayout;
import icyllis.modernui.widget.LinearLayout;
import icyllis.modernui.widget.RelativeLayout;
import icyllis.modernui.widget.RelativeRadioGroup;
import icyllis.modernui.widget.Spinner;
import icyllis.modernui.widget.SpinnerAdapter;
import icyllis.modernui.widget.TextView;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import sonar.fluxnetworks.api.FluxTranslate;
import sonar.fluxnetworks.api.gui.EnumNetworkColor;
import sonar.fluxnetworks.api.network.SecurityLevel;
import sonar.fluxnetworks.client.design.FluxDesign;
import sonar.fluxnetworks.client.design.PasswordFilter;
import sonar.fluxnetworks.client.design.RoundRectDrawable;
import sonar.fluxnetworks.client.design.SecurityLevelAdapter;
import sonar.fluxnetworks.client.design.TabBackground;
import sonar.fluxnetworks.client.widget.ColorButton;
import sonar.fluxnetworks.client.widget.ColorPicker;
import sonar.fluxnetworks.common.integration.MUIIntegration;
import sonar.fluxnetworks.register.ClientMessages;

public class CreateTab
extends Fragment {
    private SecurityLevel mSecurityLevel = SecurityLevel.PRIVATE;
    private EditText mName;
    private EditText mPassword;
    private Button mCreateButton;
    private RoundRectDrawable mNameBg;
    private RoundRectDrawable mPasswordBg;
    private RoundRectDrawable mCreateButtonBg;
    private RelativeRadioGroup mColorGroup;
    private ColorPicker mColorPicker;
    private int mSelectedColor = EnumNetworkColor.BLUE.getRGB();
    private final TextWatcher mTextWatcher = new TextWatcher(){

        public void beforeTextChanged(CharSequence s, int start, int count, int after) {
        }

        public void onTextChanged(CharSequence s, int start, int before, int count) {
        }

        public void afterTextChanged(Editable s) {
            CreateTab.this.updateViewStates();
        }
    };

    public void onCreate(@Nullable DataSet savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.getParentFragmentManager().setFragmentResultListener("create_network", (LifecycleOwner)this, (requestKey, result) -> {
            int code = result.getInt("code");
            FluxTranslate t = FluxTranslate.fromResponseCode(code);
            if (t != null) {
                MUIIntegration.showToastError(t);
            }
        });
    }

    @Nullable
    public View onCreateView(@Nullable ViewGroup container, @Nullable DataSet savedInstanceState) {
        int dp2 = View.dp((float)2.0f);
        LinearLayout content = new LinearLayout();
        content.setOrientation(1);
        content.setLayoutTransition(new LayoutTransition());
        TextView v = new TextView();
        v.setText((CharSequence)FluxTranslate.TAB_CREATE.get());
        v.setTextSize(16.0f);
        v.setTextColor(-4934476);
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-2, -2);
        params.gravity = 17;
        params.setMargins(0, View.dp((float)20.0f), 0, View.dp((float)12.0f));
        content.addView((View)v, (ViewGroup.LayoutParams)params);
        this.mName = FluxDesign.createTextField();
        this.mNameBg = (RoundRectDrawable)this.mName.getBackground();
        this.mName.setFilters(new InputFilter[]{new InputFilter.LengthFilter(24)});
        Object text = "";
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null) {
            text = player.m_36316_().getName() + "'s Network";
        }
        this.mName.setText((CharSequence)text);
        this.mName.setHint((CharSequence)"Network Name");
        this.mName.setHintTextColor(-8355712);
        this.mName.addTextChangedListener(this.mTextWatcher);
        LinearLayout.LayoutParams params2 = new LinearLayout.LayoutParams(-1, -2);
        params2.setMargins(View.dp((float)20.0f), dp2, View.dp((float)20.0f), View.dp((float)2.0f));
        content.addView((View)this.mName, (ViewGroup.LayoutParams)params2);
        LinearLayout group = new LinearLayout();
        group.setOrientation(0);
        TextView title = new TextView();
        title.setText((CharSequence)FluxTranslate.NETWORK_SECURITY.get());
        title.setTextSize(16.0f);
        title.setTextColor(-8355712);
        params2 = new LinearLayout.LayoutParams(-2, -2, 1.0f);
        params2.setMargins(View.dp((float)26.0f), 0, View.dp((float)20.0f), 0);
        group.addView((View)title, (ViewGroup.LayoutParams)params2);
        Spinner spinner = new Spinner();
        spinner.setPopupBackgroundDrawable(new Drawable(){
            private final int mRadius = View.dp((float)8.0f);

            public void draw(@Nonnull Canvas canvas) {
                Rect b = this.getBounds();
                float inner = (float)this.mRadius * 0.5f;
                Paint paint = Paint.take();
                paint.setColor(-819978208);
                canvas.drawRoundRect((float)b.left + inner, (float)b.top + inner, (float)b.right - inner, (float)b.bottom - inner, (float)this.mRadius, paint);
            }

            public boolean getPadding(@Nonnull Rect padding) {
                int r = (int)Math.ceil(this.mRadius);
                padding.set(r, r, r, r);
                return true;
            }
        });
        spinner.setGravity(0x800005);
        spinner.setPadding(View.dp((float)8.0f), dp2, View.dp((float)8.0f), dp2);
        spinner.setAdapter((SpinnerAdapter)new SecurityLevelAdapter());
        spinner.setSelection((int)this.mSecurityLevel.getId());
        spinner.setOnItemSelectedListener(new AdapterView.OnItemSelectedListener(){

            public void onItemSelected(AdapterView<?> parent, View view, int position, long id) {
                CreateTab.this.mSecurityLevel = (SecurityLevel)((Object)parent.getSelectedItem());
                CreateTab.this.updateViewStates();
            }

            public void onNothingSelected(AdapterView<?> parent) {
            }
        });
        params2 = new LinearLayout.LayoutParams(-2, -2);
        params2.setMargins(View.dp((float)20.0f), 0, View.dp((float)20.0f), 0);
        group.addView((View)spinner, (ViewGroup.LayoutParams)params2);
        group.setBaselineAligned(true);
        params = new LinearLayout.LayoutParams(-1, -2);
        content.addView((View)group, (ViewGroup.LayoutParams)params);
        this.mPassword = FluxDesign.createTextField();
        this.mPasswordBg = (RoundRectDrawable)this.mPassword.getBackground();
        this.mPassword.setHint((CharSequence)"Password");
        this.mPassword.setHintTextColor(-8355712);
        this.mPassword.setFilters(new InputFilter[]{PasswordFilter.getInstance()});
        this.mPassword.setTransformationMethod((TransformationMethod)PasswordTransformationMethod.getInstance());
        this.mPassword.setVisibility(this.mSecurityLevel == SecurityLevel.ENCRYPTED ? 0 : 8);
        this.mPassword.addTextChangedListener(this.mTextWatcher);
        LinearLayout.LayoutParams params3 = new LinearLayout.LayoutParams(-1, -2);
        params3.setMargins(View.dp((float)20.0f), dp2, View.dp((float)20.0f), dp2);
        content.addView((View)this.mPassword, (ViewGroup.LayoutParams)params3);
        this.mColorGroup = this.inflateColorGroup();
        params3 = new LinearLayout.LayoutParams(-2, -2);
        params3.gravity = 17;
        params3.setMargins(View.dp((float)20.0f), View.dp((float)8.0f), View.dp((float)20.0f), View.dp((float)2.0f));
        content.addView((View)this.mColorGroup, (ViewGroup.LayoutParams)params3);
        this.mColorPicker = new ColorPicker();
        this.mColorPicker.setOnColorChangeListener(new ColorPicker.OnColorChangeListener(){

            @Override
            public void onColorChanged(ColorPicker picker, int color) {
                if (CreateTab.this.mSelectedColor != color) {
                    CreateTab.this.mColorGroup.clearCheck();
                    CreateTab.this.mSelectedColor = color;
                    CreateTab.this.updateViewStates();
                }
            }

            @Override
            public void onFocusLost(ColorPicker picker, int color) {
                if (CreateTab.this.mSelectedColor != color) {
                    CreateTab.this.mColorGroup.clearCheck();
                    CreateTab.this.mSelectedColor = color;
                    CreateTab.this.updateViewStates();
                }
            }
        });
        params3 = new LinearLayout.LayoutParams(-2, -2, 1.0f);
        params3.gravity = 17;
        params3.setMargins(View.dp((float)20.0f), View.dp((float)2.0f), View.dp((float)20.0f), View.dp((float)4.0f));
        content.addView((View)this.mColorPicker, (ViewGroup.LayoutParams)params3);
        v = new Button();
        v.setText((CharSequence)"Create");
        v.setSingleLine();
        v.setTextSize(16.0f);
        v.setTextColor(FluxDesign.TEXT_COLOR);
        this.mCreateButtonBg = new RoundRectDrawable();
        v.setBackground((Drawable)this.mCreateButtonBg);
        v.setPadding(View.dp((float)8.0f), View.dp((float)4.0f), View.dp((float)8.0f), View.dp((float)4.0f));
        v.setOnClickListener(__ -> ClientMessages.createNetwork(this.requireArguments().getInt("token"), this.mName.getText().toString(), this.mSelectedColor, this.mSecurityLevel, this.mPassword.getText().toString()));
        params = new LinearLayout.LayoutParams(-2, -2);
        params.gravity = 17;
        params.setMargins(View.dp((float)20.0f), View.dp((float)4.0f), View.dp((float)20.0f), View.dp((float)20.0f));
        content.addView((View)v, (ViewGroup.LayoutParams)params);
        this.mCreateButton = v;
        this.mColorGroup.check(1);
        content.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1, 17));
        return content;
    }

    private void updateViewStates() {
        View view;
        Drawable drawable;
        boolean password = this.mSecurityLevel == SecurityLevel.ENCRYPTED;
        this.mPassword.setVisibility(password ? 0 : 8);
        if (password && this.mPassword.getText().isEmpty()) {
            this.mCreateButton.setEnabled(false);
        } else {
            this.mCreateButton.setEnabled(!this.mName.getText().isEmpty());
        }
        this.mNameBg.setColor(this.mSelectedColor);
        this.mPasswordBg.setColor(this.mSelectedColor);
        this.mCreateButtonBg.setColor(this.mSelectedColor);
        Fragment fragment = this.getParentFragment();
        if (fragment != null && (drawable = (view = fragment.requireView().findViewById(2)).getBackground()) instanceof TabBackground) {
            TabBackground bg = (TabBackground)drawable;
            bg.setColor(this.mSelectedColor);
        }
    }

    @Nonnull
    private RelativeRadioGroup inflateColorGroup() {
        RelativeRadioGroup group = new RelativeRadioGroup();
        int buttonSize = View.dp((float)32.0f);
        int margin = View.dp((float)1.0f);
        for (int i = 0; i < EnumNetworkColor.VALUES.length; ++i) {
            EnumNetworkColor color = EnumNetworkColor.VALUES[i];
            ColorButton v = new ColorButton();
            v.setColor(color.getRGB() | 0xC0000000);
            v.setId(i + 1);
            RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(buttonSize, buttonSize);
            params.setMargins(margin, margin, margin, margin);
            if (i == 0) {
                params.addRule(10);
                params.addRule(20);
            } else if (i < 7) {
                params.addRule(17, i);
            } else if (i == 7) {
                params.addRule(3, 1);
            } else {
                params.addRule(17, i);
                params.addRule(3, 1);
            }
            v.setLayoutParams((ViewGroup.LayoutParams)params);
            if (i == 0 || i == 7) {
                group.addView((View)v);
                continue;
            }
            group.postDelayed(() -> group.addView((View)v), (long)i * 50L);
        }
        group.setLayoutTransition(new LayoutTransition());
        group.setOnCheckedChangeListener((__, id) -> {
            if (id > 0) {
                this.mSelectedColor = EnumNetworkColor.VALUES[id - 1].getRGB();
                this.mColorPicker.setColor(this.mSelectedColor);
                this.updateViewStates();
            }
        });
        return group;
    }

    public void onDestroy() {
        super.onDestroy();
        this.getParentFragmentManager().clearFragmentResultListener("create_network");
    }
}

