/*
 * Decompiled with CFR 0.152.
 */
package fuzs.bettermodsbutton.client.handler;

import com.mojang.blaze3d.vertex.PoseStack;
import fuzs.bettermodsbutton.BetterModsButton;
import fuzs.bettermodsbutton.compat.catalogue.CatalogueModListFactory;
import fuzs.bettermodsbutton.config.ClientConfig;
import fuzs.bettermodsbutton.lib.core.ModLoaderEnvironment;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.PlainTextButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.PauseScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.client.gui.ModListScreen;
import net.minecraftforge.client.gui.NotificationModUpdateScreen;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;

public class ModScreenHandler {
    private NotificationModUpdateScreen gameMenuNotification;

    @SubscribeEvent
    public void onInitGui(ScreenEvent.InitScreenEvent.Post evt) {
        if (evt.getScreen().getClass() == TitleScreen.class) {
            this.handleMainMenu((ScreenEvent.InitScreenEvent)evt);
        } else if (evt.getScreen() instanceof PauseScreen && evt.getScreen().m_6702_().stream().anyMatch(listener -> listener instanceof Button)) {
            this.handlePauseScreen((ScreenEvent.InitScreenEvent)evt);
        }
    }

    @SubscribeEvent
    public void onDrawScreen(ScreenEvent.DrawScreenEvent evt) {
        if (evt.getScreen() instanceof PauseScreen) {
            this.gameMenuNotification.m_6305_(evt.getPoseStack(), evt.getMouseX(), evt.getMouseY(), evt.getPartialTicks());
        }
    }

    private void handleMainMenu(ScreenEvent.InitScreenEvent evt) {
        if (BetterModsButton.CONFIG.client().mainMenuMode == ClientConfig.MainMenuMode.NO_CHANGE) {
            return;
        }
        boolean modCount = BetterModsButton.CONFIG.client().modCount;
        this.getButton(evt.getListenersList(), "fml.menu.mods").ifPresent(arg_0 -> ((ScreenEvent.InitScreenEvent)evt).removeListener(arg_0));
        Button modsButton = null;
        switch (BetterModsButton.CONFIG.client().mainMenuMode) {
            case INSERT_BELOW_REALMS: {
                this.moveButtonsUpAndDown(evt.getListenersList(), evt.getScreen().f_96544_ / 4 + 48 + 72 + 12);
                Screen realmsNotificationsScreen = (Screen)ObfuscationReflectionHelper.getPrivateValue(TitleScreen.class, (Object)((TitleScreen)evt.getScreen()), (String)"f_96726_");
                if (realmsNotificationsScreen != null) {
                    realmsNotificationsScreen.f_96544_ -= 48;
                }
                this.getButton(evt.getListenersList(), "menu.online").ifPresent(widget -> {
                    widget.m_93674_(200);
                    widget.f_93620_ = evt.getScreen().f_96543_ / 2 - 100;
                });
                modsButton = new Button(evt.getScreen().f_96543_ / 2 - 100, evt.getScreen().f_96544_ / 4 + 48 + 72 - 12, 200, 20, this.getModsComponent(modCount, false), button -> evt.getScreen().getMinecraft().m_91152_(ModScreenHandler.createModListScreen(evt.getScreen())));
                break;
            }
            case NONE: {
                this.getButton(evt.getListenersList(), "menu.online").ifPresent(widget -> {
                    widget.m_93674_(200);
                    widget.f_93620_ = evt.getScreen().f_96543_ / 2 - 100;
                });
                break;
            }
            case LEFT_TO_REALMS: {
                modsButton = new Button(evt.getScreen().f_96543_ / 2 - 100, evt.getScreen().f_96544_ / 4 + 48 + 48, 98, 20, this.getModsComponent(modCount, true), button -> evt.getScreen().getMinecraft().m_91152_(ModScreenHandler.createModListScreen(evt.getScreen())));
                break;
            }
            case RIGHT_TO_REALMS: {
                this.getButton(evt.getListenersList(), "menu.online").ifPresent(widget -> {
                    widget.f_93620_ = evt.getScreen().f_96543_ / 2 - 100;
                });
                Screen realmsNotificationsScreen = (Screen)ObfuscationReflectionHelper.getPrivateValue(TitleScreen.class, (Object)((TitleScreen)evt.getScreen()), (String)"f_96726_");
                if (realmsNotificationsScreen != null) {
                    realmsNotificationsScreen.f_96543_ -= 204;
                }
                modsButton = new Button(evt.getScreen().f_96543_ / 2 + 2, evt.getScreen().f_96544_ / 4 + 48 + 48, 98, 20, this.getModsComponent(modCount, true), button -> evt.getScreen().getMinecraft().m_91152_(ModScreenHandler.createModListScreen(evt.getScreen())));
                break;
            }
            case REPLACE_REALMS: {
                this.getButton(evt.getListenersList(), "menu.online").ifPresent(arg_0 -> ((ScreenEvent.InitScreenEvent)evt).removeListener(arg_0));
                ObfuscationReflectionHelper.setPrivateValue(TitleScreen.class, (Object)((TitleScreen)evt.getScreen()), null, (String)"f_96726_");
                modsButton = new Button(evt.getScreen().f_96543_ / 2 - 100, evt.getScreen().f_96544_ / 4 + 48 + 48, 200, 20, this.getModsComponent(modCount, false), button -> evt.getScreen().getMinecraft().m_91152_(ModScreenHandler.createModListScreen(evt.getScreen())));
            }
        }
        if (modsButton != null) {
            evt.addListener(modsButton);
        }
        ObfuscationReflectionHelper.setPrivateValue(TitleScreen.class, (Object)((TitleScreen)evt.getScreen()), (Object)NotificationModUpdateScreen.init((TitleScreen)((TitleScreen)evt.getScreen()), BetterModsButton.CONFIG.client().updateNotification ? modsButton : null), (String)"modUpdateNotification");
    }

    private void handlePauseScreen(ScreenEvent.InitScreenEvent evt) {
        if (BetterModsButton.CONFIG.client().pauseScreenMode == ClientConfig.PauseScreenMode.NONE) {
            return;
        }
        boolean modCount = BetterModsButton.CONFIG.client().modCount;
        Button modsButton = null;
        switch (BetterModsButton.CONFIG.client().pauseScreenMode) {
            case INSERT_BELOW_FEEDBACK_AND_BUGS: {
                this.moveButtonsUpAndDown(evt.getListenersList(), evt.getScreen().f_96544_ / 4 + 96 - 16);
                modsButton = new Button(evt.getScreen().f_96543_ / 2 - 102, evt.getScreen().f_96544_ / 4 + 96 - 16 - 12, 204, 20, this.getModsComponent(modCount, false), button -> evt.getScreen().getMinecraft().m_91152_(ModScreenHandler.createModListScreen(evt.getScreen())));
                break;
            }
            case REPLACE_FEEDBACK: {
                this.getButton(evt.getListenersList(), "menu.sendFeedback").ifPresent(arg_0 -> ((ScreenEvent.InitScreenEvent)evt).removeListener(arg_0));
                modsButton = new Button(evt.getScreen().f_96543_ / 2 - 102, evt.getScreen().f_96544_ / 4 + 72 - 16, 98, 20, this.getModsComponent(modCount, true), button -> evt.getScreen().getMinecraft().m_91152_(ModScreenHandler.createModListScreen(evt.getScreen())));
                break;
            }
            case REPLACE_BUGS: {
                this.getButton(evt.getListenersList(), "menu.reportBugs").ifPresent(arg_0 -> ((ScreenEvent.InitScreenEvent)evt).removeListener(arg_0));
                modsButton = new Button(evt.getScreen().f_96543_ / 2 + 4, evt.getScreen().f_96544_ / 4 + 72 - 16, 98, 20, this.getModsComponent(modCount, true), button -> evt.getScreen().getMinecraft().m_91152_(ModScreenHandler.createModListScreen(evt.getScreen())));
                break;
            }
            case REPLACE_FEEDBACK_AND_BUGS: {
                this.getButton(evt.getListenersList(), "menu.sendFeedback").ifPresent(arg_0 -> ((ScreenEvent.InitScreenEvent)evt).removeListener(arg_0));
                this.getButton(evt.getListenersList(), "menu.reportBugs").ifPresent(arg_0 -> ((ScreenEvent.InitScreenEvent)evt).removeListener(arg_0));
                modsButton = new Button(evt.getScreen().f_96543_ / 2 - 102, evt.getScreen().f_96544_ / 4 + 72 - 16, 204, 20, this.getModsComponent(modCount, false), button -> evt.getScreen().getMinecraft().m_91152_(ModScreenHandler.createModListScreen(evt.getScreen())));
                break;
            }
            case REPLACE_AND_MOVE_LAN: {
                this.getButton(evt.getListenersList(), "menu.sendFeedback").ifPresent(arg_0 -> ((ScreenEvent.InitScreenEvent)evt).removeListener(arg_0));
                this.getButton(evt.getListenersList(), "menu.reportBugs").ifPresent(arg_0 -> ((ScreenEvent.InitScreenEvent)evt).removeListener(arg_0));
                this.getButton(evt.getListenersList(), "menu.shareToLan").ifPresent(widget -> {
                    widget.m_93674_(204);
                    widget.f_93620_ = evt.getScreen().f_96543_ / 2 - 102;
                    widget.f_93621_ = evt.getScreen().f_96544_ / 4 + 72 - 16;
                });
                modsButton = new Button(evt.getScreen().f_96543_ / 2 + 4, evt.getScreen().f_96544_ / 4 + 96 - 16, 98, 20, this.getModsComponent(modCount, true), button -> evt.getScreen().getMinecraft().m_91152_(ModScreenHandler.createModListScreen(evt.getScreen())));
                break;
            }
            case INSERT_AND_MOVE_LAN: {
                this.moveButtonsUpAndDown(evt.getListenersList(), evt.getScreen().f_96544_ / 4 + 96 - 16);
                this.getButton(evt.getListenersList(), "menu.shareToLan").ifPresent(widget -> {
                    widget.m_93674_(204);
                    widget.f_93620_ = evt.getScreen().f_96543_ / 2 - 102;
                    widget.f_93621_ = evt.getScreen().f_96544_ / 4 + 96 - 16 - 12;
                });
                modsButton = new Button(evt.getScreen().f_96543_ / 2 + 4, evt.getScreen().f_96544_ / 4 + 96 - 16 + 12, 98, 20, this.getModsComponent(modCount, true), button -> evt.getScreen().getMinecraft().m_91152_(ModScreenHandler.createModListScreen(evt.getScreen())));
            }
        }
        if (modsButton != null) {
            evt.addListener(modsButton);
        }
        this.gameMenuNotification = new NotificationModUpdateScreen(BetterModsButton.CONFIG.client().updateNotification ? modsButton : null);
        this.gameMenuNotification.m_6574_(evt.getScreen().getMinecraft(), evt.getScreen().f_96543_, evt.getScreen().f_96544_);
        this.gameMenuNotification.m_7856_();
    }

    private void moveButtonsUpAndDown(List<GuiEventListener> listeners, int splitAt) {
        for (GuiEventListener widget : listeners) {
            Button button;
            if (!(widget instanceof Button) || (button = (Button)widget) instanceof PlainTextButton) continue;
            if (splitAt <= button.f_93621_) {
                button.f_93621_ += 12;
                continue;
            }
            button.f_93621_ -= 12;
        }
    }

    private Optional<Button> getButton(List<GuiEventListener> widgets, String s) {
        for (GuiEventListener widget : widgets) {
            Button button;
            if (!(widget instanceof Button) || !this.containsKey(button = (Button)widget, s)) continue;
            return Optional.of(button);
        }
        return Optional.empty();
    }

    private boolean containsKey(Button button, String key) {
        Component message = button.m_6035_();
        return message instanceof TranslatableComponent && ((TranslatableComponent)message).m_131328_().equals(key);
    }

    private Component getModsComponent(boolean withCount, boolean compact) {
        TranslatableComponent component = new TranslatableComponent("fml.menu.mods");
        if (withCount) {
            String translationKey = compact ? "button.mods.count.compact" : "button.mods.count";
            component = component.m_130946_(" ").m_7220_((Component)new TranslatableComponent(translationKey, new Object[]{ModList.get().size()}));
        }
        return component;
    }

    private static Screen createModListScreen(Screen lastScreen) {
        if (!BetterModsButton.CONFIG.client().forceDirtBackground) {
            return new ModListScreen(lastScreen);
        }
        if (ModLoaderEnvironment.isModLoaded("catalogue")) {
            try {
                return CatalogueModListFactory.createCatalogueModListScreen();
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return new ModListScreen(lastScreen){

            public void m_96558_(PoseStack pMatrixStack, int pVOffset) {
                this.m_96626_(pVOffset);
            }
        };
    }
}

