/*
 * Decompiled with CFR 0.152.
 */
package no.dadobug;

import dev.architectury.injectables.annotations.ExpectPlatform;
import dev.architectury.registry.level.biome.BiomeModifications;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.data.worldgen.placement.OrePlacements;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tags.Tag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.MultiNoiseBiomeSource;
import net.minecraft.world.level.biome.TheEndBiomeSource;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import no.dadobug.forge.BiomeSelectorsImpl;

public class BiomeSelectors {
    public static BiomeSource overworld = MultiNoiseBiomeSource.Preset.f_187087_.m_187099_(BuiltinRegistries.f_123865_);
    public static BiomeSource nether = MultiNoiseBiomeSource.Preset.f_48512_.m_187099_(BuiltinRegistries.f_123865_);
    public static BiomeSource end = new TheEndBiomeSource(BuiltinRegistries.f_123865_, 0L);

    private BiomeSelectors() {
    }

    public static Predicate<BiomeModifications.BiomeContext> gensFeature(Holder<PlacedFeature> FeatureIn) {
        return context -> context.getProperties().getGenerationProperties().getFeatures().stream().anyMatch(ctx -> {
            for (Holder placedFeatureRegistryEntry : ctx) {
                if (!Objects.equals(BuiltinRegistries.f_194653_.m_123009_((ResourceKey)placedFeatureRegistryEntry.m_203543_().orElse(null)).orElse(null), FeatureIn.m_203334_())) continue;
                return true;
            }
            return false;
        });
    }

    public static Predicate<BiomeModifications.BiomeContext> gensEmeralds() {
        return BiomeSelectors.gensFeature((Holder<PlacedFeature>)OrePlacements.f_195309_);
    }

    public static Optional<Level> getWorld(MinecraftServer server, ResourceKey<Level> world) {
        return Optional.ofNullable(server.m_129880_(ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)world.m_135782_())));
    }

    public static Predicate<BiomeModifications.BiomeContext> inCategory(Biome.BiomeCategory category) {
        return ctx -> ctx.getProperties().getCategory() == category;
    }

    public static Predicate<BiomeModifications.BiomeContext> hasTag(Tag<Biome> tag) {
        return context -> tag.m_6497_().contains(BuiltinRegistries.f_123865_.m_7745_(context.getKey()));
    }

    public static Predicate<BiomeModifications.BiomeContext> gensInSource(BiomeSource sourceIn) {
        return context -> sourceIn.m_207840_().stream().anyMatch(biome -> ((Biome)biome.m_203334_()).equals(BuiltinRegistries.f_123865_.m_7745_(context.getKey())));
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static Predicate<BiomeModifications.BiomeContext> gensInOverworld() {
        return BiomeSelectorsImpl.gensInOverworld();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static Predicate<BiomeModifications.BiomeContext> gensInNether() {
        return BiomeSelectorsImpl.gensInNether();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static Predicate<BiomeModifications.BiomeContext> gensInEnd() {
        return BiomeSelectorsImpl.gensInEnd();
    }
}

